/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import de.mn77.base.stream.Lib_Stream;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.Lib_Jar;
import de.mn77.base.sys.file.Lib_TextFile;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.model.IncludeInfo;

public class ImportManager {
    private final HashMap<String, Boolean> imports = new HashMap();

    public void add(String basePath, String file) {
        String filePath;
        filePath = basePath != null && !file.startsWith("/") ? (filePath = String.valueOf(basePath) + Sys.getSeperatorDir() + file) : file;
        this.imports.putIfAbsent(filePath, false);
    }

    public IncludeInfo readNext(DebugInfo debug) {
        for (Map.Entry<String, Boolean> g : this.imports.entrySet()) {
            if (g.getValue().booleanValue()) continue;
            String filePath = g.getKey();
            this.imports.put(filePath, true);
            int indexJar = filePath.indexOf("!/");
            if (indexJar >= 0) {
                String jarPath = filePath.substring(indexJar + 1);
                try {
                    InputStream is = Lib_Jar.getStream(jarPath);
                    String code = Lib_Stream.readUTF8(is);
                    String jarAbsolutePath = Lib_Jar.getAbsolutePath(jarPath);
                    File file = new File(jarAbsolutePath);
                    return new IncludeInfo(file.getParent(), jarPath, code);
                }
                catch (Exception e) {
                    throw new ExternalError("Include Jar-File read error", jarPath, debug);
                }
            }
            File file = new File(filePath);
            if (!file.exists()) {
                throw new ExternalError("Include file not found", filePath, debug);
            }
            try {
                String code = Lib_TextFile.read(file);
                return new IncludeInfo(new File(filePath).getParent(), filePath, code);
            }
            catch (Exception e) {
                throw new ExternalError("Include file read error", filePath, debug);
            }
        }
        return null;
    }
}

