/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.udp;

import de.mn77.lib.udp.UdpPush;
import java.io.IOException;
import java.net.SocketException;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Chars;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.JMo_Byte;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.struct.JMo_ByteArray;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Type;

public class JMo_UdpPush
extends A_Object {
    private UdpPush udp;
    private final ArgCallBuffer par_port;

    public JMo_UdpPush(Call port) {
        this.par_port = new ArgCallBuffer(0, port);
    }

    @Override
    public void init(CallRuntime cr) {
        int port = Lib_Convert.getIntValue(cr, this.par_port.init(cr, this, A_IntNumber.class));
        try {
            this.udp = new UdpPush(port);
        }
        catch (IOException e) {
            throw new ExternalError(cr, "UDP-Network error", e.getMessage());
        }
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        return String.valueOf(Lib_Type.getName(this)) + "(" + this.par_port.get().toString(cr, STYPE.IDENT) + ")";
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "send": {
                try {
                    this.send(cr);
                }
                catch (IOException e) {
                    throw new ExternalError(cr, "UDP-Network error", e.getMessage());
                }
                return A_Object.stdResult(this);
            }
            case "close": {
                this.close(cr);
                return A_Object.stdResult(Nil.NIL);
            }
        }
        return null;
    }

    private void close(CallRuntime cr) {
        cr.argsNone();
        try {
            this.udp.close();
        }
        catch (SocketException e) {
            throw new ExternalError(cr, "UDP-Network error", e.getMessage());
        }
    }

    private void send(CallRuntime cr) throws IOException {
        I_Object[] oa = cr.argsExt(this, {Str.class}, {A_IntNumber.class}, {A_Chars.class, JMo_Byte.class, JMo_ByteArray.class});
        String address = Lib_Convert.getStringValue(cr, oa[0]);
        int port = Lib_Convert.getIntValue(cr, oa[1]);
        I_Object datax = oa[2];
        if (datax instanceof A_Chars) {
            String datas = Lib_Convert.getStringValue(cr, datax);
            this.udp.push(address, port, datas.getBytes());
            return;
        }
        if (datax instanceof JMo_Byte) {
            byte data = ((JMo_Byte)datax).getValue();
            this.udp.push(address, port, new byte[]{data});
            return;
        }
        if (datax instanceof JMo_ByteArray) {
            byte[] ba = ((JMo_ByteArray)datax).getValue();
            this.udp.push(address, port, ba);
            return;
        }
        throw new RuntimeError(cr, "Invalid type of data", "Allowed are Chars,Byte and List, but got: " + datax.getTypeName());
    }
}

