/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.edit.defs;

import java.io.File;
import org.jaymo_lang.edit.action.EVENTS;
import org.jaymo_lang.edit.action.JayMo_Actions;
import org.jaymo_lang.edit.editor.CodeEditor;
import org.jaymo_lang.edit.editor.styler.Styler;
import org.jaymo_lang.edit.lib.RecentFiles;

public class FileEditor
extends CodeEditor {
    private static final long serialVersionUID = 7841170632314601549L;
    private File currentFile = null;
    private boolean isChanged = false;
    private final JayMo_Actions actions;
    private final RecentFiles recent;

    public FileEditor(int font_char_width, int font_line_hight, JayMo_Actions actions) {
        super(font_char_width, font_line_hight);
        this.setStyler(new Styler(this));
        this.actions = actions;
        this.recent = new RecentFiles();
        this.recent.init(actions);
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public RecentFiles getRecent() {
        return this.recent;
    }

    public boolean hasUnsavedChanges() {
        return this.isChanged && (this.currentFile != null || this.getText().trim().length() > 0);
    }

    public void setChanged(boolean b) {
        boolean updateNeeded = b ^ this.isChanged;
        this.isChanged = b;
        if (updateNeeded) {
            this.actions.perform(EVENTS.CHANGED);
        }
    }

    public void setCurrentFile(File f) {
        this.currentFile = f;
        this.actions.perform(EVENTS.CHANGED);
    }
}

