/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.wiki77;

import de.mn77.base.data.convert.ConvertString;
import de.mn77.base.data.group.Group3;
import de.mn77.base.data.struct.I_List;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.error.Err;
import java.util.List;

public class Lib_Wiki77 {
    public static String convertIgnore(String text) {
        StringBuffer sb = new StringBuffer();
        boolean open = false;
        int i = 0;
        while (i < text.length()) {
            if (open) {
                if (text.startsWith("}}}", i)) {
                    open = false;
                    i += 2;
                } else {
                    sb.append(text.charAt(i));
                }
            } else if (text.startsWith("{{{", i)) {
                open = true;
                i += 2;
            } else {
                sb.append(text.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String parseHeadline(String wiki) {
        List<String> lines = Lib_Wiki77.parseLines(wiki);
        int lowNr = 10;
        String lowStr = null;
        for (String line : lines) {
            Group3<Character, Integer, String> leading = Lib_Wiki77.parseLeading(line);
            if (leading == null || ((Character)leading.o1).charValue() != '=') continue;
            if ((Integer)leading.o2 == 1) {
                return Lib_Wiki77.removeTrailing(Lib_Wiki77.specialChars(line), (Integer)leading.o2 + 1, '=');
            }
            if ((Integer)leading.o2 >= lowNr) continue;
            lowNr = (Integer)leading.o2;
            lowStr = (String)leading.o3;
        }
        if (lowNr < 10) {
            return lowStr;
        }
        return null;
    }

    public static Group3<Character, Integer, String> parseLeading(String line) {
        if (line.length() == 0) {
            return null;
        }
        char c0 = line.charAt(0);
        int amount = 0;
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char cp = cArray[n2];
            if (cp == ' ') {
                return new Group3<Character, Integer, String>(Character.valueOf(c0), amount, Lib_Wiki77.specialChars(line.substring(amount + 1)));
            }
            if (c0 == cp) {
                ++amount;
            } else {
                return null;
            }
            ++n2;
        }
        if (amount > 0) {
            return new Group3<Character, Integer, String>(Character.valueOf(c0), amount, "");
        }
        return null;
    }

    public static List<String> parseLines(String wiki) {
        return ConvertString.toList('\n', wiki);
    }

    public static String removeTrailing(String line, int start, char c) {
        int end = line.length() - 1;
        while (end >= 0 && line.charAt(end) == c || line.charAt(end) == ' ') {
            --end;
        }
        return line.substring(start, end + 1);
    }

    public static String specialChars(char c) {
        switch (c) {
            case '\u00e4': {
                return "&auml;";
            }
            case '\u00f6': {
                return "&ouml;";
            }
            case '\u00fc': {
                return "&uuml;";
            }
            case '\u00c4': {
                return "&Auml;";
            }
            case '\u00d6': {
                return "&Ouml;";
            }
            case '\u00dc': {
                return "&Uuml;";
            }
            case '\u00df': {
                return "&szlig;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
        }
        return "" + c;
    }

    public static String specialChars(String s) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            sb.append(Lib_Wiki77.specialChars(s.charAt(i)));
            ++i;
        }
        return sb.toString();
    }

    public static I_List<String> splitLines(String text) {
        Err.ifNull((Object)text);
        SimpleList<String> result = new SimpleList<String>();
        int start = 0;
        boolean nowiki = false;
        int i = 0;
        while (i < text.length()) {
            if (!nowiki && text.startsWith("{{{", i)) {
                nowiki = true;
                i += 2;
            } else {
                if (nowiki && text.startsWith("}}}", i)) {
                    nowiki = false;
                    i += 3;
                }
                if (!nowiki && text.startsWith("\\\\", i)) {
                    result.add(text.substring(start, i));
                    start = ++i + 1;
                }
            }
            ++i;
        }
        if (text.length() >= start) {
            result.add(text.substring(start));
        }
        return result;
    }

    public static I_List<String> splitTable(String line) {
        Err.ifNull((Object)line);
        SimpleList<String> result = new SimpleList<String>();
        int start = 0;
        boolean nowiki = false;
        boolean ignore = false;
        int i = 0;
        while (i < line.length()) {
            if (!nowiki && line.startsWith("{{{", i)) {
                nowiki = true;
                i += 2;
            } else if (nowiki && line.startsWith("}}}", i)) {
                nowiki = false;
                i += 2;
            } else if (ignore && line.startsWith("*/", i)) {
                ignore = false;
                ++i;
            } else if (!nowiki && line.startsWith("/*", i)) {
                ignore = true;
                ++i;
            } else if (i < line.length() && !nowiki && !ignore && line.charAt(i) == '|') {
                result.add(line.substring(start, i));
                start = i + 1;
            }
            ++i;
        }
        if (line.length() >= start) {
            result.add(line.substring(start));
        }
        return result;
    }
}

