/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.csv;

import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.table.ArrayTable;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.util.Lib_Array;

public class CsvParser {
    private final char delimiterColumn;
    private final char delimiterField;
    private final String delimiterLine;

    public CsvParser(char field, char column, String line) {
        this.delimiterField = field;
        this.delimiterColumn = column;
        this.delimiterLine = line;
    }

    public I_Table<String> parse(String csv, boolean firstLine, boolean otherLines) {
        ArrayTable result = null;
        int offset = 0;
        int lineNr = 0;
        Integer width = null;
        while (offset < csv.length()) {
            Group2<String[], Integer> g = this.parseNextLine(csv, offset);
            String[] sa = (String[])g.o1;
            offset = (Integer)g.o2;
            if (result == null) {
                width = sa.length;
                result = new ArrayTable(width);
            }
            if (sa.length == 0) continue;
            if (firstLine && lineNr == 0 || otherLines && lineNr > 0) {
                while (sa.length < width) {
                    sa = Lib_Array.append(String.class, sa, null);
                }
                result.add(sa);
            }
            ++lineNr;
        }
        return result;
    }

    private Group2<String[], Integer> parseNextLine(String text, int offset) {
        SimpleList result = new SimpleList();
        boolean open = false;
        boolean double_tf = false;
        String field = "";
        boolean active = false;
        int p = offset;
        while (p < text.length()) {
            boolean endOfText;
            char c = text.charAt(p);
            boolean bl = endOfText = p == text.length() - 1;
            if (c == this.delimiterField) {
                if (double_tf) {
                    double_tf = false;
                    field = String.valueOf(field) + c;
                } else if (open) {
                    if (endOfText || text.charAt(p + 1) != this.delimiterField) {
                        open = false;
                    } else {
                        double_tf = true;
                    }
                } else {
                    open = true;
                    active = true;
                }
            } else if (!open && c == this.delimiterColumn) {
                result.add(field);
                field = "";
                active = true;
                if (endOfText) {
                    result.add("");
                    active = false;
                }
            } else {
                if (!open && text.startsWith(this.delimiterLine, p)) {
                    if (active) {
                        result.add(field);
                        field = "";
                        active = false;
                    }
                    return new Group2<String[], Integer>(result.toArray(String.class), p + this.delimiterLine.length());
                }
                field = String.valueOf(field) + c;
            }
            ++p;
        }
        if (active) {
            result.add(field);
        }
        return new Group2<String[], Integer>(result.toArray(String.class), text.length());
    }
}

