/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.version.data;

import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.error.Err;
import de.mn77.base.version.DEVSTAGE;
import de.mn77.base.version.VersionFormatter;
import de.mn77.base.version.data.A_VersionData;
import java.util.List;

public class VersionData_Year
extends A_VersionData {
    private int year;
    private int minor;
    private int bugfix;

    public VersionData_Year(I_DateTime time, Long build, String[] sa) {
        super(time, build, sa);
    }

    public VersionData_Year(int year, int nr) {
        this(year, nr, DEVSTAGE.RELEASE);
    }

    public VersionData_Year(int year, int nr, DEVSTAGE stage) {
        this(year, nr, stage, 0);
    }

    public VersionData_Year(int year, int nr, DEVSTAGE stage, int fixnr) {
        super(stage);
        Err.ifOutOfBounds(1900, 2200, year);
        Err.ifTooSmall(1.0, nr);
        Err.ifTooSmall(0.0, fixnr);
        this.year = year;
        this.minor = nr;
        this.bugfix = fixnr;
    }

    @Override
    public String format(String format) {
        VersionFormatter form = new VersionFormatter(format);
        form.replace("%y", "" + this.year);
        form.replace("%2", "" + this.minor);
        form.replace("%3", "-" + this.bugfix);
        form.replace("%?2", this.minor == 0 ? "" : "." + this.minor);
        form.replace("%?3", this.bugfix == 0 ? "" : "-" + this.bugfix);
        return form.compute(this);
    }

    @Override
    public char getDataToken() {
        return 'y';
    }

    public int getYear() {
        return this.year;
    }

    @Override
    public void toFileData(List<Object> list) {
        list.add(this.year);
        list.add(this.minor);
        list.add(this.bugfix);
    }

    @Override
    public String toString() {
        String f = "%y.%2%?3 (Build: %b - %YYYY-MM-DD)";
        return this.format("%y.%2%?3 (Build: %b - %YYYY-MM-DD)");
    }

    @Override
    public String toStringShort() {
        String f = "%y.%2%?3";
        return this.format("%y.%2%?3");
    }

    @Override
    protected DEVSTAGE parse(String[] sa) {
        this.year = Integer.parseInt(sa[0]);
        this.minor = Integer.parseInt(sa[1]);
        this.bugfix = Integer.parseInt(sa[2]);
        return DEVSTAGE.RELEASE;
    }
}

