/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.tablestyle;

import de.mn77.base.data.constant.ALIGN;
import de.mn77.base.data.group.XY;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.tablestyle.calc.TableStyleCalc;
import de.mn77.base.error.Err;
import java.util.HashMap;

public class TableStyler {
    private boolean border = false;
    private boolean unicode = false;
    private final HashMap<XY, ALIGN> cellAligns = new HashMap();
    private Character colLineStyleDefault = null;
    private String colLineStyles = null;
    private final HashMap<Integer, ALIGN> columnAligns = new HashMap();
    private ALIGN defaultAlign = null;
    private Integer maxColWidth = null;
    private final HashMap<Integer, ALIGN> rowAligns = new HashMap();
    private Character rowLineStyleDefault = null;
    private String rowLineStyles = null;
    private int indent = 0;

    public void alignCell(int x, int y, ALIGN align) {
        Err.ifTooSmall(0.0, x);
        Err.ifTooSmall(0.0, y);
        XY p = new XY(x, y);
        this.cellAligns.put(p, align);
    }

    public void alignColumn(int column, ALIGN style) {
        Err.ifTooSmall(0.0, column);
        this.columnAligns.put(column, style);
    }

    public void alignDefault(ALIGN align) {
        this.defaultAlign = align;
    }

    public void alignRow(int row, ALIGN align) {
        Err.ifTooSmall(0.0, row);
        this.rowAligns.put(row, align);
    }

    public void colLineStyleDefault(char cStyle) {
        this.colLineStyleDefault = Character.valueOf(cStyle);
    }

    public void colLineStyles(String cStyles) {
        this.colLineStyles = cStyles;
    }

    public String compute(I_Table<?> tab) {
        TableStyleCalc tsc = new TableStyleCalc(tab);
        tsc.alignDefault(this.defaultAlign);
        tsc.alignColumns(this.columnAligns);
        tsc.alignRows(this.rowAligns);
        tsc.alignCells(this.cellAligns);
        tsc.columnLineDefault(this.colLineStyleDefault);
        tsc.columnLines(this.colLineStyles);
        tsc.rowLineDefault(this.rowLineStyleDefault);
        tsc.rowLines(this.rowLineStyles);
        tsc.indent(this.indent);
        return tsc.compute(this.border, this.unicode, this.maxColWidth);
    }

    public void rowLineStyleDefault(char rStyle) {
        this.rowLineStyleDefault = Character.valueOf(rStyle);
    }

    public void rowLineStyles(String rStyles) {
        this.rowLineStyles = rStyles;
    }

    public void setBorder(boolean b) {
        this.border = b;
    }

    public void setIndent(int indent) {
        Err.ifTooSmall(0.0, indent);
        this.indent = indent;
    }

    public void setMaxColumnWidth(int w) {
        Err.ifTooSmall(1.0, this.indent);
        this.maxColWidth = w;
    }

    public void setUnicode(boolean b) {
        this.unicode = b;
    }
}

