/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.atomic;

import de.mn77.base.data.I_Describe;
import de.mn77.base.data.util.Lib_Describe;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import java.util.Iterator;
import java.util.RandomAccess;

public class IntList
implements RandomAccess,
Iterable<Integer>,
I_Describe {
    private int[] data;
    private int size = 0;

    public IntList() {
        this.data = new int[10];
        this.size = 0;
    }

    public IntList(int initSize) {
        this.data = new int[initSize];
        this.size = 0;
    }

    public IntList(int[] ia) {
        Err.ifNull((Object)ia);
        this.data = ia;
        this.size = ia.length;
    }

    public void add(int value) {
        this.iCheckGrow(1);
        this.data[this.size] = value;
        ++this.size;
    }

    public void addAll(int ... values) {
        int len = values.length;
        this.iCheckGrow(len);
        int i = 0;
        while (i < len) {
            this.data[this.size + i] = values[i];
            ++i;
        }
        this.size += len;
    }

    public boolean contains(int x) {
        int i = 0;
        while (i < this.size) {
            if (this.data[i] == x) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int get(int idx) {
        this.iCheckBounds(idx);
        return this.data[idx];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < IntList.this.size;
            }

            @Override
            public Integer next() {
                return IntList.this.data[this.next++];
            }

            @Override
            public void remove() {
                Err.todo(new Object[0]);
            }
        };
    }

    public void set(int idx, int value) {
        this.iCheckBounds(idx);
        this.data[idx] = value;
    }

    public int size() {
        return this.size;
    }

    public int[] toArray() {
        int[] copy = new int[this.size];
        System.arraycopy(this.data, 0, copy, 0, this.size);
        return copy;
    }

    @Override
    public String toDescribe() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('(');
        int i = 0;
        while (i < this.size) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.data[i]);
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String toIdent() {
        return Lib_Describe.toIdent(this, this.size);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 0;
        while (i < this.size) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.data[i]);
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    private void iCheckBounds(int index) {
        Err.ifOutOfBounds(0, this.size - 1, index);
    }

    private void iCheckGrow(int toAdd) {
        if (this.size + toAdd <= this.data.length) {
            return;
        }
        if (this.size > 0x3FFFFFFF) {
            throw new Err_Runtime("Maximum of IntList reached", new Object[0]);
        }
        int grow = this.size <= 20 ? 10 : this.size / 2;
        int newSize = this.size + toAdd + grow;
        int[] copy = new int[newSize];
        System.arraycopy(this.data, 0, copy, 0, this.size);
        this.data = copy;
    }
}

