/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.interpolation;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import marytts.exceptions.SynthesisException;
import marytts.modules.synthesis.Voice;
import marytts.modules.synthesis.WaveformSynthesizer;
import marytts.signalproc.process.FramewiseMerger;
import marytts.signalproc.process.LSFInterpolator;
import marytts.unitselection.UnitSelectionVoice;
import marytts.unitselection.concat.BaseUnitConcatenator;
import marytts.unitselection.interpolation.InterpolatingVoice;
import marytts.util.MaryUtils;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.dom.MaryDomUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InterpolatingSynthesizer
implements WaveformSynthesizer {
    protected Logger logger;

    @Override
    public void startup() throws Exception {
        this.logger = MaryUtils.getLogger("InterpolatingSynthesizer");
        Voice.registerVoice(new InterpolatingVoice(this, "interpolatingvoice"));
        this.logger.info((Object)"started.");
    }

    @Override
    public void powerOnSelfTest() throws Error {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public AudioInputStream synthesize(List<Element> tokensAndBoundaries, Voice voice, String outputParams) throws SynthesisException {
        block23: {
            block22: {
                if (tokensAndBoundaries.size() == 0) {
                    return null;
                }
                first = tokensAndBoundaries.get(0);
                voiceElement = (Element)MaryDomUtils.getAncestor((Node)first, "voice");
                name = voiceElement.getAttribute("name");
                parts = name.split("\\s+");
                if (!InterpolatingSynthesizer.$assertionsDisabled && parts.length != 4) {
                    throw new AssertionError();
                }
                if (!InterpolatingSynthesizer.$assertionsDisabled && !parts[1].equals("with")) {
                    throw new AssertionError();
                }
                if (!InterpolatingSynthesizer.$assertionsDisabled && !parts[2].endsWith("%")) {
                    throw new AssertionError();
                }
                percent = Integer.parseInt(parts[2].substring(0, parts[2].length() - 1));
                voice1 = Voice.getVoice(parts[0]);
                if (!InterpolatingSynthesizer.$assertionsDisabled && voice1 == null) {
                    throw new AssertionError();
                }
                voice2 = Voice.getVoice(parts[3]);
                if (!InterpolatingSynthesizer.$assertionsDisabled && voice2 == null) {
                    throw new AssertionError();
                }
                if (!(voice1 instanceof UnitSelectionVoice)) {
                    throw new IllegalArgumentException("Voices of type " + voice.getClass().getName() + " not supported!");
                }
                if (!(voice2 instanceof UnitSelectionVoice)) {
                    throw new IllegalArgumentException("Voices of type " + voice.getClass().getName() + " not supported!");
                }
                usv1 = (UnitSelectionVoice)voice1;
                usv2 = (UnitSelectionVoice)voice2;
                unitSel1 = usv1.getUnitSelector();
                selectedUnits1 = unitSel1.selectUnits(tokensAndBoundaries, voice);
                unitSel2 = usv2.getUnitSelector();
                selectedUnits2 = unitSel2.selectUnits(tokensAndBoundaries, voice);
                if (!InterpolatingSynthesizer.$assertionsDisabled && selectedUnits1.size() != selectedUnits2.size()) {
                    throw new AssertionError((Object)("Unexpected difference in number of units: " + selectedUnits1.size() + " vs. " + selectedUnits2.size()));
                }
                numUnits = selectedUnits1.size();
                unitConcatenator1 = usv1.getConcatenator();
                try {
                    audio1 = unitConcatenator1.getAudio(selectedUnits1);
                    break block22;
                }
                catch (IOException ioe) {
                    sw = new StringWriter();
                    pw = new PrintWriter(sw);
                    selIt = selectedUnits1.iterator();
                    ** while (selIt.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    pw.println(selIt.next());
                    continue;
                }
lbl44:
                // 1 sources

                throw new SynthesisException("For voice " + voice1.getName() + ", problems generating audio for unit chain: " + sw.toString(), ioe);
            }
            audioSource1 = new AudioDoubleDataSource(audio1);
            unitConcatenator2 = usv2.getConcatenator();
            try {
                audio2 = unitConcatenator2.getAudio(selectedUnits2);
                break block23;
            }
            catch (IOException ioe) {
                sw = new StringWriter();
                pw = new PrintWriter(sw);
                selIt = selectedUnits2.iterator();
                ** while (selIt.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                pw.println(selIt.next());
                continue;
            }
lbl58:
            // 1 sources

            throw new SynthesisException("For voice " + voice2.getName() + ", problems generating audio for unit chain: " + sw.toString(), ioe);
        }
        audioSource2 = new AudioDoubleDataSource(audio2);
        sampleRate1 = (int)usv1.dbAudioFormat().getSampleRate();
        label1 = new double[numUnits];
        t1 = 0.0;
        sampleRate2 = (int)usv2.dbAudioFormat().getSampleRate();
        label2 = new double[numUnits];
        t2 = 0.0;
        i = 0;
        while (i < numUnits) {
            u1 = selectedUnits1.get(i);
            u2 = selectedUnits2.get(i);
            ud1 = (BaseUnitConcatenator.UnitData)u1.getConcatenationData();
            unitDuration1 = ud1.getUnitDuration();
            if (unitDuration1 < 0) {
                unitDuration1 = 0;
                d = ud1.getFrames();
                id = 0;
                while (id < d.length) {
                    unitDuration1 = (int)((long)unitDuration1 + d[id].getDuration());
                    ++id;
                }
            }
            label1[i] = t1 += (double)((float)unitDuration1 / (float)sampleRate1);
            ud2 = (BaseUnitConcatenator.UnitData)u2.getConcatenationData();
            unitDuration2 = ud2.getUnitDuration();
            if (unitDuration2 < 0) {
                unitDuration2 = 0;
                d = ud2.getFrames();
                id = 0;
                while (id < d.length) {
                    unitDuration2 = (int)((long)unitDuration2 + d[id].getDuration());
                    ++id;
                }
            }
            label2[i] = t2 += (double)((float)unitDuration2 / (float)sampleRate2);
            this.logger.debug((Object)(String.valueOf(usv1.getName()) + " [" + u1.getTarget() + "] " + label1[i] + " -- " + usv2.getName() + " [" + u2.getTarget() + "] " + label2[i]));
            ++i;
        }
        frameLength = Integer.getInteger("signalproc.lpcanalysisresynthesis.framelength", 512);
        predictionOrder = Integer.getInteger("signalproc.lpcanalysisresynthesis.predictionorder", 20);
        r = (double)percent / 100.0;
        if (!InterpolatingSynthesizer.$assertionsDisabled && !(r >= 0.0)) {
            throw new AssertionError();
        }
        if (!InterpolatingSynthesizer.$assertionsDisabled && !(r <= 1.0)) {
            throw new AssertionError();
        }
        foas = new FramewiseMerger(audioSource1, frameLength, sampleRate1, new BufferedDoubleDataSource(label1), audioSource2, sampleRate2, new BufferedDoubleDataSource(label2), new LSFInterpolator(predictionOrder, r));
        outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(foas), audio1.getFormat());
        return outputAudio;
    }
}

