/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.install;

import com.twmacinta.util.MD5;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Observable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import marytts.tools.install.LanguageComponentDescription;
import marytts.tools.install.VoiceComponentDescription;
import marytts.util.MaryUtils;
import marytts.util.dom.DomUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ComponentDescription
extends Observable
implements Comparable<ComponentDescription> {
    public static final String installerNamespaceURI = "http://mary.dfki.de/installer";
    private static final int MAX_BUFFER_SIZE = 1024;
    private String name;
    private Locale locale;
    private String version;
    private String description;
    private URL license;
    private List<URL> locations;
    private String packageFilename;
    private int packageSize;
    private String packageMD5;
    private boolean isSelected = false;
    private Status status;
    private File archiveFile;
    private File infoFile;
    private int downloaded = 0;
    private int size = -1;
    private String installedFilesNames = null;
    private Set<String> sharedFileNames;
    private ComponentDescription availableUpdate = null;

    public void replaceWithUpdate() {
        if (this.availableUpdate == null) {
            return;
        }
        this.name = this.availableUpdate.name;
        this.locale = this.availableUpdate.locale;
        this.version = this.availableUpdate.version;
        this.description = this.availableUpdate.description;
        this.license = this.availableUpdate.license;
        this.locations = this.availableUpdate.locations;
        this.packageFilename = this.availableUpdate.packageFilename;
        this.packageSize = this.availableUpdate.packageSize;
        this.packageMD5 = this.availableUpdate.packageMD5;
        this.isSelected = this.availableUpdate.isSelected;
        this.status = this.availableUpdate.status;
        this.archiveFile = this.availableUpdate.archiveFile;
        this.infoFile = this.availableUpdate.infoFile;
        this.downloaded = this.availableUpdate.downloaded;
        this.size = this.availableUpdate.size;
        this.installedFilesNames = this.availableUpdate.installedFilesNames;
        this.availableUpdate = null;
        this.stateChanged();
    }

    protected ComponentDescription(String name, String version, String packageFilename) {
        this.name = name;
        this.version = version;
        this.packageFilename = packageFilename;
    }

    protected ComponentDescription(Element xmlDescription) throws NullPointerException {
        this.name = xmlDescription.getAttribute("name");
        this.locale = MaryUtils.string2locale(xmlDescription.getAttribute("locale"));
        this.version = xmlDescription.getAttribute("version");
        Element descriptionElement = (Element)xmlDescription.getElementsByTagName("description").item(0);
        this.description = descriptionElement.getTextContent().trim();
        Element licenseElement = (Element)xmlDescription.getElementsByTagName("license").item(0);
        try {
            this.license = new URL(licenseElement.getAttribute("href").trim().replaceAll(" ", "%20"));
        }
        catch (MalformedURLException mue) {
            new Exception("Invalid license URL -- ignoring", mue).printStackTrace();
            this.license = null;
        }
        Element packageElement = (Element)xmlDescription.getElementsByTagName("package").item(0);
        this.packageFilename = packageElement.getAttribute("filename").trim();
        this.packageSize = Integer.parseInt(packageElement.getAttribute("size"));
        this.packageMD5 = packageElement.getAttribute("md5sum");
        NodeList locationElements = packageElement.getElementsByTagName("location");
        this.locations = new ArrayList<URL>(locationElements.getLength());
        int i = 0;
        int max = locationElements.getLength();
        while (i < max) {
            Element aLocationElement = (Element)locationElements.item(i);
            try {
                String urlString = aLocationElement.getAttribute("href").trim().replaceAll(" ", "%20");
                boolean isFolder = true;
                if (aLocationElement.hasAttribute("folder")) {
                    isFolder = Boolean.valueOf(aLocationElement.getAttribute("folder"));
                }
                if (isFolder && !urlString.endsWith(this.packageFilename)) {
                    if (!urlString.endsWith("/")) {
                        urlString = String.valueOf(urlString) + "/";
                    }
                    urlString = String.valueOf(urlString) + this.packageFilename;
                }
                this.locations.add(new URL(urlString));
            }
            catch (MalformedURLException mue) {
                new Exception("Invalid location -- ignoring", mue).printStackTrace();
            }
            ++i;
        }
        this.archiveFile = new File(System.getProperty("mary.downloadDir"), this.packageFilename);
        String infoFilename = String.valueOf(this.packageFilename.substring(0, this.packageFilename.lastIndexOf(46))) + "-component.xml";
        this.infoFile = new File(System.getProperty("mary.installedDir"), infoFilename);
        this.determineStatus();
        NodeList filesElements = xmlDescription.getElementsByTagName("files");
        if (filesElements.getLength() > 0) {
            Element filesElement = (Element)filesElements.item(0);
            this.installedFilesNames = filesElement.getTextContent();
        }
    }

    private void determineStatus() {
        new File(System.getProperty("mary.installedDir", "installed"));
        new File(System.getProperty("mary.downloadDir", "download"));
        this.status = this.infoFile.exists() ? Status.INSTALLED : (this.archiveFile.exists() ? (this.archiveFile.length() == (long)this.packageSize ? Status.DOWNLOADED : Status.AVAILABLE) : (this.locations.size() > 0 ? Status.AVAILABLE : Status.ERROR));
    }

    public String getComponentTypeString() {
        return "component";
    }

    public String getName() {
        return this.name;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale aLocale) {
        this.locale = aLocale;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String aVersion) {
        this.version = aVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
    }

    public URL getLicenseURL() {
        return this.license;
    }

    public void setLicenseURL(URL aLicense) {
        this.license = aLicense;
    }

    public List<URL> getLocations() {
        return this.locations;
    }

    public void removeAllLocations() {
        this.locations.clear();
    }

    public void addLocation(URL aLocation) {
        if (this.locations == null) {
            this.locations = new ArrayList<URL>();
        }
        this.locations.add(aLocation);
    }

    public String getPackageFilename() {
        return this.packageFilename;
    }

    public void setPackageFilename(String aPackageFilename) {
        this.packageFilename = aPackageFilename;
    }

    public int getPackageSize() {
        return this.packageSize;
    }

    public void setPackageSize(int aSize) {
        this.packageSize = aSize;
    }

    public String getDisplayPackageSize() {
        return MaryUtils.toHumanReadableSize(this.packageSize);
    }

    public String getPackageMD5Sum() {
        return this.packageMD5;
    }

    public void setPackageMD5Sum(String aMD5) {
        this.packageMD5 = aMD5;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean value) {
        if (value != this.isSelected) {
            this.isSelected = value;
            this.stateChanged();
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public LinkedList<String> getInstalledFileNames() {
        LinkedList<String> files = new LinkedList<String>();
        if (this.installedFilesNames != null) {
            StringTokenizer st = new StringTokenizer(this.installedFilesNames, ",");
            while (st.hasMoreTokens()) {
                String next = st.nextToken().trim();
                if ("".equals(next)) continue;
                files.addFirst(next);
            }
        }
        return files;
    }

    public void setSharedFiles(Set<String> fileList) {
        this.sharedFileNames = fileList;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComponentDescription)) {
            return false;
        }
        ComponentDescription o = (ComponentDescription)obj;
        return this.name.equals(o.name) && this.locale.equals(o.locale) && this.version.equals(o.version);
    }

    public void pause() {
        this.status = Status.PAUSED;
        this.stateChanged();
    }

    public void resume(boolean synchronous) {
        this.status = Status.DOWNLOADING;
        this.stateChanged();
        this.download(synchronous);
    }

    public void cancel() {
        this.status = Status.CANCELLED;
        this.stateChanged();
    }

    private void error() {
        this.status = Status.ERROR;
        this.stateChanged();
    }

    public void download(boolean synchronous) {
        Downloader d = new Downloader();
        if (synchronous) {
            d.run();
        } else {
            new Thread(d).start();
        }
    }

    private void stateChanged() {
        this.setChanged();
        this.notifyObservers();
    }

    public void install(boolean synchronous) throws Exception {
        this.status = Status.INSTALLING;
        this.stateChanged();
        Installer inst = new Installer();
        if (synchronous) {
            inst.run();
        } else {
            new Thread(inst).start();
        }
    }

    public boolean uninstall() {
        if (this.status != Status.INSTALLED) {
            throw new IllegalStateException("Can only uninstall installed components, but status is " + this.status.toString());
        }
        assert (this.installedFilesNames != null);
        try {
            String maryBase = System.getProperty("mary.base");
            System.out.println("Removing " + this.name + "-" + this.version + " from " + maryBase + "...");
            LinkedList<String> files = this.getInstalledFileNames();
            for (String file : files) {
                if (file.trim().equals("")) continue;
                if (this.sharedFileNames != null && this.sharedFileNames.contains(file)) {
                    System.out.println("Keeping shared file: " + file);
                    continue;
                }
                File f = new File(String.valueOf(maryBase) + "/" + file);
                if (f.isDirectory()) {
                    String[] kids = f.list();
                    if (kids.length == 0) {
                        System.err.println("Removing empty directory: " + file);
                        f.delete();
                        continue;
                    }
                    System.err.println("Cannot delete non-empty directory: " + file);
                    continue;
                }
                if (f.exists()) {
                    System.err.println("Removing file: " + file);
                    f.delete();
                    continue;
                }
                System.err.println("File doesn't exist -- cannot delete: " + file);
            }
            this.infoFile.delete();
        }
        catch (Exception e) {
            System.err.println("Cannot uninstall:");
            e.printStackTrace();
            return false;
        }
        this.determineStatus();
        return true;
    }

    public int getProgress() {
        if (this.status == Status.DOWNLOADING) {
            return (int)(100L * (long)this.downloaded / (long)this.size);
        }
        if (this.status == Status.INSTALLING) {
            return -1;
        }
        return 100;
    }

    private void writeDownloadedComponentXML() throws Exception {
        File archiveFolder = this.archiveFile.getParentFile();
        String archiveFilename = this.archiveFile.getName();
        String compdescFilename = String.valueOf(archiveFilename.substring(0, archiveFilename.lastIndexOf(46))) + "-component.xml";
        File compdescFile = new File(archiveFolder, compdescFilename);
        Document doc = this.createComponentXML();
        DomUtils.document2File(doc, compdescFile);
    }

    private void writeInstalledComponentXML() throws Exception {
        assert (this.installedFilesNames != null);
        File installedFolder = this.infoFile.getParentFile();
        String archiveFilename = this.archiveFile.getName();
        String compdescFilename = String.valueOf(archiveFilename.substring(0, archiveFilename.lastIndexOf(46))) + "-component.xml";
        File compdescFile = new File(installedFolder, compdescFilename);
        Document doc = this.createComponentXML();
        DomUtils.document2File(doc, compdescFile);
    }

    public Document createComponentXML() throws ParserConfigurationException {
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setNamespaceAware(true);
        Document doc = fact.newDocumentBuilder().newDocument();
        Element root = (Element)doc.appendChild(doc.createElementNS(installerNamespaceURI, "marytts-install"));
        Element desc = (Element)root.appendChild(doc.createElementNS(installerNamespaceURI, this.getComponentTypeString()));
        desc.setAttribute("locale", MaryUtils.locale2xmllang(this.locale));
        desc.setAttribute("name", this.name);
        desc.setAttribute("version", this.version);
        Element descriptionElt = (Element)desc.appendChild(doc.createElementNS(installerNamespaceURI, "description"));
        descriptionElt.setTextContent(this.description);
        Element licenseElt = (Element)desc.appendChild(doc.createElementNS(installerNamespaceURI, "license"));
        if (this.license != null) {
            licenseElt.setAttribute("href", this.license.toString());
        }
        Element packageElt = (Element)desc.appendChild(doc.createElementNS(installerNamespaceURI, "package"));
        packageElt.setAttribute("size", Integer.toString(this.packageSize));
        packageElt.setAttribute("md5sum", this.packageMD5);
        packageElt.setAttribute("filename", this.packageFilename);
        for (URL l : this.locations) {
            String urlString = l.toString();
            boolean isFolder = false;
            if (urlString.endsWith(this.packageFilename)) {
                urlString = urlString.substring(0, urlString.length() - this.packageFilename.length());
                isFolder = true;
            }
            Element lElt = (Element)packageElt.appendChild(doc.createElementNS(installerNamespaceURI, "location"));
            lElt.setAttribute("href", urlString);
            lElt.setAttribute("folder", String.valueOf(isFolder));
        }
        if (this.installedFilesNames != null) {
            Element filesElement = (Element)desc.appendChild(doc.createElementNS(installerNamespaceURI, "files"));
            filesElement.setTextContent(this.installedFilesNames);
        }
        return doc;
    }

    public boolean isUpdateAvailable() {
        return this.availableUpdate != null;
    }

    public ComponentDescription getAvailableUpdate() {
        return this.availableUpdate;
    }

    public void setAvailableUpdate(ComponentDescription aDesc) {
        if (aDesc == null) {
            this.availableUpdate = null;
            this.stateChanged();
            return;
        }
        if (this.status != Status.INSTALLED) {
            throw new IllegalStateException("Can only set an available update if status is installed, but status is " + this.status.toString());
        }
        if (!aDesc.getName().equals(this.name)) {
            throw new IllegalArgumentException("Only a component with the same name can be an update of this component; but this has name " + this.name + ", and argument has name " + aDesc.getName());
        }
        if (!ComponentDescription.isVersionNewerThan(aDesc.getVersion(), this.version)) {
            throw new IllegalArgumentException("Version " + aDesc.getVersion() + " is not higher than installed version " + this.version);
        }
        if (this.availableUpdate != null && !ComponentDescription.isVersionNewerThan(aDesc.getVersion(), this.availableUpdate.getVersion())) {
            return;
        }
        this.availableUpdate = aDesc;
        this.stateChanged();
    }

    public boolean isUpdateOf(ComponentDescription other) {
        return other != null && this.getClass().equals(other.getClass()) && this.name.equals(other.getName()) && other.getStatus() == Status.INSTALLED && ComponentDescription.isVersionNewerThan(this.version, other.getVersion());
    }

    public static boolean isVersionNewerThan(String oneVersion, String otherVersion) {
        if (oneVersion == null || otherVersion == null) {
            return false;
        }
        if (otherVersion.equals(String.valueOf(oneVersion) + "-SNAPSHOT")) {
            return true;
        }
        if (oneVersion.equals(String.valueOf(otherVersion) + "-SNAPSHOT")) {
            return false;
        }
        return oneVersion.compareTo(otherVersion) > 0;
    }

    @Override
    public int compareTo(ComponentDescription o) {
        int myPos = 0;
        int oPos = 0;
        if (this instanceof LanguageComponentDescription) {
            myPos = 5;
        } else if (this instanceof VoiceComponentDescription) {
            myPos = 10;
        }
        if (o instanceof LanguageComponentDescription) {
            oPos = 5;
        } else if (o instanceof VoiceComponentDescription) {
            oPos = 10;
        }
        if (oPos - myPos != 0) {
            return oPos - myPos;
        }
        return this.name.compareTo(o.name);
    }

    public static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    class Downloader
    implements Runnable {
        Downloader() {
        }

        private HttpURLConnection openAndRedirectIfRequired(URL url) throws IOException {
            int maxRedirects = 5;
            int i = 0;
            while (i < maxRedirects) {
                URL target;
                HttpURLConnection c = (HttpURLConnection)url.openConnection();
                c.setInstanceFollowRedirects(false);
                c.setRequestProperty("Range", "bytes=" + ComponentDescription.this.downloaded + "-");
                c.connect();
                int stat = c.getResponseCode();
                if (stat >= 300 && stat <= 307 && stat != 306 && stat != 304) {
                    URL base = c.getURL();
                    String location = c.getHeaderField("Location");
                    c.disconnect();
                    if (location == null) {
                        throw new SecurityException("No redirect location given.");
                    }
                    target = new URL(base, location);
                    String protocol = target.getProtocol();
                    if (!protocol.equals("http") && !protocol.equals("https")) {
                        throw new SecurityException("Redirect supported to http and https protocols only, but found '" + protocol + "'");
                    }
                } else {
                    return c;
                }
                url = target;
                ++i;
            }
            throw new SecurityException("More than five redirects, aborting");
        }

        @Override
        public void run() {
            ComponentDescription.this.status = Status.DOWNLOADING;
            ComponentDescription.this.stateChanged();
            RandomAccessFile file = null;
            InputStream stream = null;
            HttpURLConnection connection = null;
            for (URL u : ComponentDescription.this.locations) {
                try {
                    System.out.println("Trying location " + u + "...");
                    connection = this.openAndRedirectIfRequired(u);
                    if (connection.getResponseCode() / 100 != 2) {
                        throw new IOException("Non-OK response code: " + connection.getResponseCode() + " (" + connection.getResponseMessage() + ")");
                    }
                    System.out.println("...connected");
                    int contentLength = connection.getContentLength();
                    if (contentLength > -1 && contentLength != ComponentDescription.this.packageSize) {
                        throw new IOException("Expected package size " + ComponentDescription.this.packageSize + ", but web server reports " + contentLength);
                    }
                    if (ComponentDescription.this.size == -1) {
                        ComponentDescription.this.size = ComponentDescription.this.packageSize;
                        ComponentDescription.this.stateChanged();
                    }
                    System.out.println("...downloading" + (ComponentDescription.this.downloaded > 0 ? " from byte " + ComponentDescription.this.downloaded : ""));
                    boolean success = this.tryToDownloadFromLocation(file, stream, connection);
                    if (!success) continue;
                    break;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }

        private boolean tryToDownloadFromLocation(RandomAccessFile file, InputStream stream, HttpURLConnection connection) {
            boolean success;
            block28: {
                success = false;
                try {
                    try {
                        file = new RandomAccessFile(ComponentDescription.this.archiveFile, "rw");
                        file.seek(ComponentDescription.this.downloaded);
                        stream = connection.getInputStream();
                        if (ComponentDescription.this.status == Status.ERROR) {
                            ComponentDescription.this.downloaded = 0;
                        }
                        ComponentDescription.this.status = Status.DOWNLOADING;
                        byte[] buffer = new byte[1024];
                        while (ComponentDescription.this.status == Status.DOWNLOADING) {
                            int len = Math.min(buffer.length, ComponentDescription.this.size - ComponentDescription.this.downloaded);
                            int read = stream.read(buffer, 0, len);
                            if (read == -1) break;
                            file.write(buffer, 0, read);
                            ComponentDescription componentDescription = ComponentDescription.this;
                            componentDescription.downloaded = componentDescription.downloaded + read;
                            ComponentDescription.this.stateChanged();
                        }
                        if (ComponentDescription.this.status == Status.DOWNLOADING) {
                            System.err.println("Download of " + ComponentDescription.this.packageFilename + " has finished.");
                            System.err.print("Computing checksum...");
                            ComponentDescription.this.status = Status.VERIFYING;
                            ComponentDescription.this.stateChanged();
                            String hash = MD5.asHex((byte[])MD5.getHash((File)ComponentDescription.this.archiveFile));
                            if (hash.equals(ComponentDescription.this.packageMD5)) {
                                System.err.println("ok!");
                                ComponentDescription.this.writeDownloadedComponentXML();
                                ComponentDescription.this.status = Status.DOWNLOADED;
                                success = true;
                            } else {
                                System.err.println("failed!");
                                System.out.println("MD5 according to component description: " + ComponentDescription.this.packageMD5);
                                System.out.println("MD5 computed:   " + hash);
                                ComponentDescription.this.status = Status.ERROR;
                                ComponentDescription.this.downloaded = 0;
                            }
                            ComponentDescription.this.stateChanged();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ComponentDescription.this.error();
                        if (file != null) {
                            try {
                                file.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return success;
        }
    }

    class Installer
    implements Runnable {
        Installer() {
        }

        @Override
        public void run() {
            String maryBase = System.getProperty("mary.base");
            System.out.println("Installing " + ComponentDescription.this.name + "-" + ComponentDescription.this.version + " in " + maryBase + "...");
            ArrayList<String> files = new ArrayList<String>();
            try {
                ZipFile zipfile = new ZipFile(ComponentDescription.this.archiveFile);
                Enumeration<? extends ZipEntry> entries = zipfile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    files.add(entry.getName());
                    File newFile = new File(String.valueOf(maryBase) + "/" + entry.getName());
                    if (entry.isDirectory()) {
                        System.err.println("Extracting directory: " + entry.getName());
                        newFile.mkdir();
                        continue;
                    }
                    if (newFile.exists()) {
                        boolean existingIsNewer = false;
                        try {
                            JarFile existingJar = new JarFile(newFile);
                            Manifest existingManifest = existingJar.getManifest();
                            String existingVersion = existingManifest.getMainAttributes().getValue("Specification-Version");
                            JarInputStream packagedJar = new JarInputStream(zipfile.getInputStream(entry));
                            Manifest packagedManifest = packagedJar.getManifest();
                            String packagedVersion = packagedManifest.getMainAttributes().getValue("Specification-Version");
                            existingIsNewer = ComponentDescription.isVersionNewerThan(existingVersion, packagedVersion);
                            if (existingIsNewer) {
                                files.remove(entry.getName());
                            }
                        }
                        catch (Exception exception) {}
                        if (existingIsNewer) {
                            System.err.println("NOT overwriting existing newer file: " + entry.getName());
                            continue;
                        }
                    }
                    if (!newFile.getParentFile().isDirectory()) {
                        System.err.println("Creating directory tree: " + newFile.getParentFile().getAbsolutePath());
                        newFile.getParentFile().mkdirs();
                    }
                    System.err.println("Extracting file: " + entry.getName());
                    ComponentDescription.copyInputStream(zipfile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(newFile)));
                    if (!entry.getName().startsWith("bin/")) continue;
                    try {
                        if (!newFile.setExecutable(true, false)) continue;
                        System.err.println("Setting executable bit on file: " + entry.getName());
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                }
                zipfile.close();
                ComponentDescription.this.installedFilesNames = StringUtils.join(files, ", ");
                ComponentDescription.this.writeInstalledComponentXML();
            }
            catch (Exception e) {
                System.err.println("... installation failed:");
                e.printStackTrace();
                ComponentDescription.this.status = Status.ERROR;
                ComponentDescription.this.stateChanged();
            }
            System.err.println("...done");
            ComponentDescription.this.status = Status.INSTALLED;
            ComponentDescription.this.stateChanged();
        }
    }

    public static enum Status {
        AVAILABLE,
        DOWNLOADING,
        PAUSED,
        VERIFYING,
        DOWNLOADED,
        INSTALLING,
        CANCELLED,
        ERROR,
        INSTALLED;

    }
}

