/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.SynthesisException;
import marytts.modules.InternalModule;
import marytts.modules.synthesis.Voice;
import marytts.modules.synthesis.WaveformSynthesizer;
import marytts.server.MaryProperties;
import marytts.signalproc.effects.EffectsApplier;
import marytts.util.data.audio.AppendableSequenceAudioInputStream;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.NameNodeFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class Synthesis
extends InternalModule {
    private List<WaveformSynthesizer> waveformSynthesizers;
    private EffectsApplier effects;

    public Synthesis() {
        super("Synthesis", MaryDataType.ACOUSTPARAMS, MaryDataType.AUDIO, null);
    }

    @Override
    public void startup() throws Exception {
        this.startupSynthesizers();
        super.startup();
    }

    private void startupSynthesizers() throws ClassNotFoundException, InstantiationException, Exception {
        this.waveformSynthesizers = new ArrayList<WaveformSynthesizer>();
        for (String synthClassName : MaryProperties.synthesizerClasses()) {
            WaveformSynthesizer ws = (WaveformSynthesizer)Class.forName(synthClassName).newInstance();
            ws.startup();
            this.waveformSynthesizers.add(ws);
        }
    }

    @Override
    public synchronized void powerOnSelfTest() throws Error {
        for (WaveformSynthesizer ws : this.waveformSynthesizers) {
            ws.powerOnSelfTest();
        }
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        AudioInputStream ais;
        assert (d.getAudioFileFormat() != null) : "Audio file format is not set!";
        Document doc = d.getDocument();
        AudioFormat targetFormat = d.getAudioFileFormat().getFormat();
        Voice defaultVoice = d.getDefaultVoice();
        String defaultStyle = d.getDefaultStyle();
        String defaultEffects = d.getDefaultEffects();
        Locale locale = d.getLocale();
        String outputParams = d.getOutputParams();
        if (defaultVoice == null) {
            defaultVoice = Voice.getDefaultVoice(locale);
            if (defaultVoice == null) {
                throw new SynthesisException("No voice available for locale '" + locale + "'");
            }
            this.logger.info((Object)("No default voice associated with data. Assuming global default " + defaultVoice.getName()));
        }
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        result.setDocument(doc);
        result.setAudioFileFormat(d.getAudioFileFormat());
        if (d.getAudio() != null) {
            assert (d.getAudio() instanceof AppendableSequenceAudioInputStream);
            result.setAudio(d.getAudio());
        }
        NodeIterator it = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, new NameNodeFilter("t", "boundary", "vocalization"), false);
        ArrayList<Element> elements = new ArrayList<Element>();
        Element element = null;
        Voice currentVoice = defaultVoice;
        String currentStyle = defaultStyle;
        String currentEffect = defaultEffects;
        Element currentVoiceElement = null;
        Element currentSentence = null;
        while ((element = (Element)it.nextNode()) != null) {
            AudioInputStream ais2;
            Element v = (Element)MaryDomUtils.getAncestor((Node)element, "voice");
            Element s = (Element)MaryDomUtils.getAncestor((Node)element, "s");
            if (element.getNodeName().equals("vocalization")) {
                Voice newvoice;
                if (v == null || (newvoice = Voice.getVoice(v)) == null || !newvoice.hasVocalizationSupport()) continue;
                AudioInputStream ais3 = newvoice.getVocalizationSynthesizer().synthesize(newvoice, d.getAudioFileFormat(), element);
                result.appendAudio(ais3);
                continue;
            }
            if (v == null) {
                if (currentVoiceElement != null) {
                    if (!elements.isEmpty()) {
                        ais2 = this.synthesizeOneSection(elements, currentVoice, currentStyle, currentEffect, targetFormat, outputParams);
                        if (ais2 != null) {
                            result.appendAudio(ais2);
                        }
                        elements.clear();
                    }
                    currentVoice = defaultVoice;
                    currentStyle = defaultStyle;
                    currentEffect = defaultEffects;
                    currentVoiceElement = null;
                }
            } else if (v != currentVoiceElement || v.getAttribute("style") != null && v.getAttribute("style") != "" && !v.getAttribute("style").equals(currentStyle) || v.getAttribute("effect") != null && v.getAttribute("effect") != "" && !v.getAttribute("effect").equals(currentEffect)) {
                Voice newVoice;
                if (!elements.isEmpty()) {
                    ais2 = this.synthesizeOneSection(elements, currentVoice, currentStyle, currentEffect, targetFormat, outputParams);
                    if (ais2 != null) {
                        result.appendAudio(ais2);
                    }
                    elements.clear();
                }
                if ((newVoice = Voice.getVoice(v)) != null) {
                    currentVoice = newVoice;
                }
                if (v.getAttribute("style") != null && v.getAttribute("style") != "") {
                    currentStyle = v.getAttribute("style");
                }
                if (v.getAttribute("effect") != null && v.getAttribute("effect") != "") {
                    currentEffect = v.getAttribute("effect");
                }
                currentVoiceElement = v;
            }
            if (s != currentSentence) {
                if (!elements.isEmpty()) {
                    ais2 = this.synthesizeOneSection(elements, currentVoice, currentStyle, currentEffect, targetFormat, outputParams);
                    if (ais2 != null) {
                        result.appendAudio(ais2);
                    }
                    elements.clear();
                }
                currentSentence = s;
            }
            elements.add(element);
        }
        if (!elements.isEmpty() && (ais = this.synthesizeOneSection(elements, currentVoice, currentStyle, currentEffect, targetFormat, outputParams)) != null) {
            result.appendAudio(ais);
        }
        return result;
    }

    private AudioInputStream synthesizeOneSection(List<Element> tokensAndBoundaries, Voice voice, String currentStyle, String currentEffect, AudioFormat targetFormat, String outputParams) throws SynthesisException, UnsupportedAudioFileException {
        AudioInputStream ais;
        EffectsApplier ef;
        block9: {
            if (!this.containsPhoneDescendants(tokensAndBoundaries)) {
                this.logger.warn((Object)"No PHONE segments found in this section; will not attempt to synthesize it!");
                return null;
            }
            ef = new EffectsApplier();
            ef.setHMMEffectParameters(voice, currentEffect);
            ais = null;
            ais = voice.synthesize(tokensAndBoundaries, outputParams);
            if (ais == null) {
                return null;
            }
            if (!ais.getFormat().matches(targetFormat)) {
                this.logger.info((Object)("Audio format conversion required for voice " + voice.getName()));
                try {
                    AudioInputStream intermedStream;
                    ais = intermedStream = AudioSystem.getAudioInputStream(targetFormat, ais);
                }
                catch (IllegalArgumentException iae) {
                    boolean solved = false;
                    if (!targetFormat.getEncoding().equals(ais.getFormat()) && targetFormat.getSampleRate() != ais.getFormat().getSampleRate()) {
                        AudioFormat sampleRateConvFormat = new AudioFormat(ais.getFormat().getEncoding(), targetFormat.getSampleRate(), ais.getFormat().getSampleSizeInBits(), ais.getFormat().getChannels(), ais.getFormat().getFrameSize(), ais.getFormat().getFrameRate(), ais.getFormat().isBigEndian());
                        try {
                            AudioInputStream intermedStream = AudioSystem.getAudioInputStream(sampleRateConvFormat, ais);
                            ais = AudioSystem.getAudioInputStream(targetFormat, intermedStream);
                            solved = true;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                    if (solved) break block9;
                    throw new UnsupportedAudioFileException("Conversion from audio format " + ais.getFormat() + " to requested audio format " + targetFormat + " not supported.\n" + iae.getMessage());
                }
            }
        }
        if (currentEffect != null && !currentEffect.equals("")) {
            ais = ef.apply(ais, currentEffect);
        }
        return ais;
    }

    private boolean containsPhoneDescendants(List<Element> tokensAndBoundaries) {
        for (Element element : tokensAndBoundaries) {
            if (!element.getTagName().equals("t") || element.getElementsByTagName("ph").getLength() <= 0) continue;
            return true;
        }
        return false;
    }
}

