/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.datatypes.MaryXML;
import marytts.modules.InternalModule;
import marytts.modules.MaryModule;
import marytts.modules.ModuleRegistry;
import marytts.modules.Synthesis;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.server.MaryProperties;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.NameNodeFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;

public class KlattDurationModeller
extends InternalModule {
    private String localePrefix;
    private AllophoneSet allophoneSet;
    private KlattDurationParams klattDurationParams;
    private Properties klattRuleParams;
    private WeakHashMap topBaseConfMap;
    private WeakHashMap prosodyMap;

    public KlattDurationModeller(String localeString) throws IOException {
        super("KlattDurationModeller", MaryDataType.ALLOPHONES, MaryDataType.DURATIONS, MaryUtils.string2locale(localeString));
        this.localePrefix = localeString;
    }

    @Override
    public void startup() throws Exception {
        MaryModule synthesis;
        super.startup();
        try {
            synthesis = ModuleRegistry.getModule(Synthesis.class);
        }
        catch (NullPointerException nullPointerException) {
            synthesis = new Synthesis();
        }
        assert (synthesis != null);
        if (synthesis.getState() == 0) {
            synthesis.startup();
        }
        this.klattRuleParams = new Properties();
        this.klattRuleParams.load(new FileInputStream(MaryProperties.needFilename(String.valueOf(this.localePrefix) + ".cap.klattrulefile")));
        this.allophoneSet = MaryRuntimeUtils.needAllophoneSet(String.valueOf(this.localePrefix) + ".allophoneset");
        this.klattDurationParams = new KlattDurationParams(MaryProperties.needFilename(String.valueOf(this.localePrefix) + ".cap.klattdurfile"));
        this.prosodyMap = new WeakHashMap();
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Document doc = d.getDocument();
        this.determineProsodicSettings(doc);
        this.addOrDeleteBoundaries(doc);
        NodeList sentences = doc.getElementsByTagName("s");
        int i = 0;
        while (i < sentences.getLength()) {
            Element sentence = (Element)sentences.item(i);
            this.processSentence(sentence);
            ++i;
        }
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        result.setDocument(doc);
        return result;
    }

    private void determineProsodicSettings(Document doc) {
        NodeList prosodies = doc.getElementsByTagName("prosody");
        int i = 0;
        while (i < prosodies.getLength()) {
            ProsodicSettings testSettings;
            Element prosody = (Element)prosodies.item(i);
            ProsodicSettings settings = new ProsodicSettings();
            ProsodicSettings parentSettings = new ProsodicSettings();
            Element ancestor = (Element)MaryDomUtils.getAncestor((Node)prosody, "prosody");
            if (ancestor != null && (testSettings = (ProsodicSettings)this.prosodyMap.get(ancestor)) != null) {
                parentSettings = testSettings;
            }
            settings.setRate(parentSettings.rate() + this.getPercentageDelta(prosody.getAttribute("rate")));
            settings.setAccentProminence(parentSettings.accentProminence() + this.getPercentageDelta(prosody.getAttribute("accent-prominence")));
            settings.setAccentSlope(parentSettings.accentSlope() + this.getPercentageDelta(prosody.getAttribute("accent-slope")));
            settings.setNumberOfPauses(parentSettings.numberOfPauses() + this.getPercentageDelta(prosody.getAttribute("number-of-pauses")));
            settings.setPauseDuration(parentSettings.pauseDuration() + this.getPercentageDelta(prosody.getAttribute("pause-duration")));
            settings.setVowelDuration(parentSettings.vowelDuration() + this.getPercentageDelta(prosody.getAttribute("vowel-duration")));
            settings.setPlosiveDuration(parentSettings.plosiveDuration() + this.getPercentageDelta(prosody.getAttribute("plosive-duration")));
            settings.setFricativeDuration(parentSettings.fricativeDuration() + this.getPercentageDelta(prosody.getAttribute("fricative-duration")));
            settings.setNasalDuration(parentSettings.nasalDuration() + this.getPercentageDelta(prosody.getAttribute("nasal-duration")));
            settings.setLiquidDuration(parentSettings.liquidDuration() + this.getPercentageDelta(prosody.getAttribute("liquid-duration")));
            settings.setGlideDuration(parentSettings.glideDuration() + this.getPercentageDelta(prosody.getAttribute("glide-duration")));
            String sVolume = prosody.getAttribute("volume");
            if (sVolume.equals("")) {
                settings.setVolume(parentSettings.volume());
            } else if (this.isPercentageDelta(sVolume)) {
                int newVolume = parentSettings.volume() + this.getPercentageDelta(sVolume);
                if (newVolume < 0) {
                    newVolume = 0;
                } else if (newVolume > 100) {
                    newVolume = 100;
                }
                settings.setVolume(newVolume);
            } else if (this.isUnsignedNumber(sVolume)) {
                settings.setVolume(this.getUnsignedNumber(sVolume));
            } else if (sVolume.equals("silent")) {
                settings.setVolume(0);
            } else if (sVolume.equals("soft")) {
                settings.setVolume(25);
            } else if (sVolume.equals("medium")) {
                settings.setVolume(50);
            } else if (sVolume.equals("loud")) {
                settings.setVolume(75);
            }
            this.prosodyMap.put(prosody, settings);
            ++i;
        }
    }

    private void addOrDeleteBoundaries(Document doc) {
        NodeIterator it = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, new NameNodeFilter("boundary"), false);
        Element boundary = null;
        ArrayList<Element> bi1prosodyElements = null;
        while ((boundary = (Element)it.nextNode()) != null) {
            int minBI = 3;
            Element prosody = (Element)MaryDomUtils.getAncestor((Node)boundary, "prosody");
            if (prosody != null) {
                ProsodicSettings settings = (ProsodicSettings)this.prosodyMap.get(prosody);
                assert (settings != null);
                int rate = settings.rate();
                int numberOfPauses = settings.numberOfPauses();
                if (numberOfPauses <= 50) {
                    minBI = 5;
                } else if (numberOfPauses <= 75) {
                    minBI = 4;
                } else if (numberOfPauses > 150) {
                    minBI = 1;
                } else if (numberOfPauses > 125) {
                    minBI = 2;
                }
                if (rate < 90 && minBI > 1) {
                    --minBI;
                }
                if (minBI == 1) {
                    if (bi1prosodyElements == null) {
                        bi1prosodyElements = new ArrayList<Element>();
                    }
                    bi1prosodyElements.add(prosody);
                }
            }
            int bi = 3;
            try {
                bi = Integer.parseInt(boundary.getAttribute("breakindex"));
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.info((Object)("Unexpected breakindex value `" + boundary.getAttribute("breakindex") + "', assuming " + bi));
            }
            if (bi >= minBI || boundary.hasAttribute("duration")) continue;
            boundary.setAttribute("duration", "0");
        }
        if (bi1prosodyElements != null) {
            for (Element prosody : bi1prosodyElements) {
                NodeIterator nodeIt = ((DocumentTraversal)((Object)doc)).createNodeIterator(prosody, 1, new NameNodeFilter("t", "boundary"), false);
                Element el = null;
                Element prevEl = null;
                while ((el = (Element)nodeIt.nextNode()) != null) {
                    if (el.getTagName().equals("t") && prevEl != null && prevEl.getTagName().equals("t")) {
                        Element newBoundary = MaryXML.createElement(doc, "boundary");
                        newBoundary.setAttribute("breakindex", "1");
                        el.getParentNode().insertBefore(newBoundary, el);
                    }
                    prevEl = el;
                }
            }
        }
    }

    private void processSentence(Element sentence) {
        NodeList tokens = sentence.getElementsByTagName("t");
        if (tokens.getLength() < 1) {
            return;
        }
        NodeList segments = sentence.getElementsByTagName("ph");
        int i = 0;
        while (i < segments.getLength()) {
            Element segment = (Element)segments.item(i);
            int factor = 100;
            int klatt0 = this.klattRule0(segment);
            int klatt2 = this.klattRule2(segment);
            int klatt2a = this.klattRule2a(segment);
            int klatt3 = this.klattRule3(segment);
            int klatt4 = this.klattRule4(segment);
            int klatt5 = this.klattRule5(segment);
            int klatt6 = this.klattRule6(segment);
            int klatt7 = this.klattRule7(segment);
            int klatt8 = this.klattRule8(segment);
            int klatt10 = this.klattRule10(segment);
            int accentProminence = this.accentProminenceRule(segment);
            factor = factor * klatt0 / 100;
            factor = factor * klatt2 / 100;
            factor = factor * klatt2a / 100;
            factor = factor * klatt3 / 100;
            factor = factor * klatt4 / 100;
            factor = factor * klatt5 / 100;
            factor = factor * klatt6 / 100;
            factor = factor * klatt7 / 100;
            factor = factor * klatt8 / 100;
            factor = factor * klatt10 / 100;
            factor = factor * accentProminence / 100;
            int inhDuration = this.getInhDuration(segment);
            int minDuration = this.getMinDuration(segment);
            int normalDuration = minDuration + (inhDuration - minDuration) * factor / 100;
            int tempo = this.tempoRule(segment);
            int duration = normalDuration * tempo / 100;
            segment.setAttribute("d", String.valueOf(duration));
            this.logger.debug((Object)(String.valueOf(segment.getAttribute("p")) + " " + duration + "ms (tempoFactor " + tempo + "%, normal " + normalDuration + ", min " + minDuration + ", inh " + inhDuration + ") " + factor + "% (" + klatt0 + "*" + klatt2 + "*" + klatt2a + "*" + klatt3 + "*" + klatt4 + "*" + klatt5 + "*" + klatt6 + "*" + klatt7 + "*" + klatt8 + "*" + klatt10 + ")"));
            ++i;
        }
        NodeList boundaries = sentence.getElementsByTagName("boundary");
        int i2 = 0;
        while (i2 < boundaries.getLength()) {
            Element boundary = (Element)boundaries.item(i2);
            if (!boundary.hasAttribute("duration")) {
                int duration = this.klattRule1(boundary);
                boundary.setAttribute("duration", String.valueOf(duration));
            }
            ++i2;
        }
        this.calculateAccumulatedDurations(sentence);
    }

    private int klattRule0(Element segment) {
        return this.getPropertyAsInteger("rule0.all");
    }

    private int klattRule2(Element segment) {
        Element syllable = this.getSyllable(segment);
        if (this.isMinipFinal(syllable)) {
            if (this.isInNucleus(segment)) {
                return this.getPropertyAsInteger("rule2.nucleus");
            }
            if (this.isInCoda(segment) && (this.isLiquid(segment) || this.isNasal(segment) || this.isFricative(segment))) {
                return this.getPropertyAsInteger("rule2.coda");
            }
        }
        return 100;
    }

    private int klattRule2a(Element segment) {
        Element syllable = this.getSyllable(segment);
        Element token = this.getToken(syllable);
        if (this.isLastBeforeBoundary(syllable, 2) && this.hasAccent(token)) {
            if (this.isInNucleus(segment)) {
                return this.getPropertyAsInteger("rule2a.nucleus");
            }
            if (this.isInCoda(segment) && this.isNasal(segment)) {
                return this.getPropertyAsInteger("rule2a.coda");
            }
        }
        return 100;
    }

    private int klattRule3(Element segment) {
        Element syllable = this.getSyllable(segment);
        if (!this.isMajIPFinal(syllable)) {
            if (this.isInNucleus(segment)) {
                return this.getPropertyAsInteger("rule3.nucleus");
            }
        } else if (this.isInCoda(segment) && (this.isLiquid(segment) || this.isNasal(segment))) {
            return this.getPropertyAsInteger("rule3.coda");
        }
        return 100;
    }

    private int klattRule4(Element segment) {
        Element syllable = this.getSyllable(segment);
        if (!this.isWordFinal(syllable) && this.isInNucleus(segment)) {
            return this.getPropertyAsInteger("rule4.nucleus");
        }
        return 100;
    }

    private int klattRule5(Element segment) {
        Element token = this.getToken(segment);
        if (this.isPolysyllabic(token) && this.isInNucleus(segment)) {
            return this.getPropertyAsInteger("rule5.nucleus");
        }
        return 100;
    }

    private int klattRule6(Element segment) {
        Element syllable = this.getSyllable(segment);
        if (this.isInOnset(segment) && !this.isWordInitial(syllable)) {
            return this.getPropertyAsInteger("rule6.onset");
        }
        if (this.isInCoda(segment)) {
            return this.getPropertyAsInteger("rule6.coda");
        }
        return 100;
    }

    private int klattRule7(Element segment) {
        this.getToken(segment);
        Element syllable = this.getSyllable(segment);
        int stress = this.getStress(syllable);
        if (stress == 2 || stress == 0) {
            if (this.isInOnset(segment)) {
                if (this.isLiquid(segment) || this.isGlide(segment)) {
                    return this.getPropertyAsInteger("rule7.onset.liquids");
                }
                return this.getPropertyAsInteger("rule7.others");
            }
            if (this.isInNucleus(segment)) {
                if (this.isWordMedial(syllable)) {
                    return this.getPropertyAsInteger("rule7.nucleus.medial");
                }
                return this.getPropertyAsInteger("rule7.nucleus.others");
            }
            return this.getPropertyAsInteger("rule7.others");
        }
        return 100;
    }

    private int klattRule8(Element segment) {
        Element syllable = this.getSyllable(segment);
        if (this.hasAccent(syllable) && this.isInNucleus(segment)) {
            return this.getPropertyAsInteger("rule8.accent");
        }
        return 100;
    }

    private int klattRule10(Element segment) {
        boolean hasPrecedingConsonant = false;
        boolean hasFollowingConsonant = false;
        if (this.isConsonant(segment)) {
            Element following;
            Element preceding = KlattDurationModeller.getPreviousSegment(segment);
            if (preceding != null && this.isConsonant(preceding)) {
                hasPrecedingConsonant = true;
            }
            if ((following = KlattDurationModeller.getNextSegment(segment)) != null && this.isConsonant(following)) {
                hasFollowingConsonant = true;
            }
            if (hasPrecedingConsonant && hasFollowingConsonant) {
                return this.getPropertyAsInteger("rule10.surrounded");
            }
            if (hasPrecedingConsonant) {
                return this.getPropertyAsInteger("rule10.preceded");
            }
            if (hasFollowingConsonant) {
                return this.getPropertyAsInteger("rule10.followed");
            }
        }
        return 100;
    }

    private int klattRule1(Element boundary) {
        int breakindex = this.getBreakindex(boundary);
        if (breakindex >= 1 && breakindex <= 6) {
            int dist;
            int shorter;
            int longer;
            int durationMeasure = 100;
            Element prosody = (Element)MaryDomUtils.getAncestor((Node)boundary, "prosody");
            if (prosody != null) {
                ProsodicSettings settings = (ProsodicSettings)this.prosodyMap.get(prosody);
                assert (settings != null);
                int deltaRate = settings.rate() - 100;
                int deltaPauseDur = settings.pauseDuration() - 100;
                durationMeasure = 100 - deltaRate + deltaPauseDur;
            }
            if (durationMeasure == 100) {
                return this.getPropertyAsInteger("rule1.bi" + String.valueOf(breakindex) + ".medium");
            }
            if (durationMeasure > 100) {
                if (durationMeasure > 120) {
                    longer = this.getPropertyAsInteger("rule1.bi" + String.valueOf(breakindex) + ".verylong");
                    shorter = this.getPropertyAsInteger("rule1.bi" + String.valueOf(breakindex) + ".long");
                    dist = durationMeasure - 120;
                } else {
                    longer = this.getPropertyAsInteger("rule1.bi" + String.valueOf(breakindex) + ".long");
                    shorter = this.getPropertyAsInteger("rule1.bi" + String.valueOf(breakindex) + ".medium");
                    dist = durationMeasure - 100;
                }
            } else if (durationMeasure < 80) {
                longer = this.getPropertyAsInteger("rule1.bi" + String.valueOf(breakindex) + ".short");
                shorter = this.getPropertyAsInteger("rule1.bi" + String.valueOf(breakindex) + ".veryshort");
                dist = durationMeasure - 60;
            } else {
                longer = this.getPropertyAsInteger("rule1.bi" + String.valueOf(breakindex) + ".medium");
                shorter = this.getPropertyAsInteger("rule1.bi" + String.valueOf(breakindex) + ".short");
                dist = durationMeasure - 80;
            }
            int result = shorter + dist * (longer - shorter) / 20;
            if (result < 10) {
                result = 10;
            }
            return result;
        }
        return 0;
    }

    private int tempoRule(Element segment) {
        Element prosody = (Element)MaryDomUtils.getAncestor((Node)segment, "prosody");
        if (prosody != null) {
            ProsodicSettings settings = (ProsodicSettings)this.prosodyMap.get(prosody);
            assert (settings != null);
            int rate = settings.rate();
            int durFactor = 10000 / rate;
            Allophone ph = this.allophoneSet.getAllophone(segment.getAttribute("p"));
            if (ph.isVowel()) {
                durFactor = durFactor * settings.vowelDuration() / 100;
            } else if (ph.isPlosive()) {
                durFactor = durFactor * settings.plosiveDuration() / 100;
            } else if (ph.isFricative()) {
                durFactor = durFactor * settings.fricativeDuration() / 100;
            } else if (ph.isNasal()) {
                durFactor = durFactor * settings.nasalDuration() / 100;
            } else if (ph.isLiquid()) {
                durFactor = durFactor * settings.liquidDuration() / 100;
            } else if (ph.isGlide()) {
                durFactor = durFactor * settings.glideDuration() / 100;
            }
            return durFactor;
        }
        return 100;
    }

    private int accentProminenceRule(Element segment) {
        int accentProminence;
        ProsodicSettings settings;
        Element prosody;
        int returnValue = 100;
        Element syllable = this.getSyllable(segment);
        if (this.hasAccent(syllable) && (prosody = (Element)MaryDomUtils.getAncestor((Node)segment, "prosody")) != null && (settings = (ProsodicSettings)this.prosodyMap.get(prosody)) != null && (accentProminence = settings.accentProminence()) != 100) {
            if (this.isInNucleus(segment)) {
                returnValue = accentProminence;
            }
            String vq = segment.getAttribute("vq");
            if (accentProminence >= 150) {
                if (vq.equals("soft") || vq.equals("modal") || vq.equals("")) {
                    vq = "loud";
                }
            } else if (accentProminence >= 125) {
                if (vq.equals("soft")) {
                    vq = "modal";
                } else if (vq.equals("modal") || vq.equals("")) {
                    vq = "loud";
                }
            }
            if (!vq.equals(segment.getAttribute("vq"))) {
                segment.setAttribute("vq", vq);
            }
        }
        return returnValue;
    }

    private void calculateAccumulatedDurations(Element sentence) {
        Element element;
        TreeWalker tw = ((DocumentTraversal)((Object)sentence.getOwnerDocument())).createTreeWalker(sentence, 1, new NameNodeFilter("ph", "boundary"), false);
        float totalDurationInSeconds = 0.0f;
        while ((element = (Element)tw.nextNode()) != null) {
            float durationInSeconds;
            int d;
            if (element.getTagName().equals("ph")) {
                d = 0;
                try {
                    d = Integer.parseInt(element.getAttribute("d"));
                }
                catch (NumberFormatException numberFormatException) {
                    this.logger.warn((Object)("Unexpected duration value `" + element.getAttribute("d") + "'"));
                }
                durationInSeconds = 0.001f * (float)d;
                element.setAttribute("end", String.format(Locale.US, "%.3f", Float.valueOf(totalDurationInSeconds += durationInSeconds)));
                continue;
            }
            d = 0;
            try {
                d = Integer.parseInt(element.getAttribute("duration"));
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.warn((Object)("Unexpected duration value `" + element.getAttribute("duration") + "'"));
            }
            durationInSeconds = 0.001f * (float)d;
            totalDurationInSeconds += durationInSeconds;
        }
    }

    private int getPropertyAsInteger(String prop) {
        int value = 100;
        try {
            value = Integer.parseInt(this.klattRuleParams.getProperty(prop));
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.warn((Object)("Cannot read property " + prop + " in klattrule parameter file. Using default."));
        }
        return value;
    }

    private Element getToken(Element segmentOrSyllable) {
        return (Element)MaryDomUtils.getAncestor((Node)segmentOrSyllable, "t");
    }

    private Element getSyllable(Element segment) {
        return (Element)MaryDomUtils.getAncestor((Node)segment, "syllable");
    }

    private int getStress(Element syllable) {
        Element token;
        int stress = 0;
        if (syllable.hasAttribute("stress")) {
            String helper = syllable.getAttribute("stress");
            if (helper.equals("1")) {
                stress = 1;
            } else if (helper.equals("2")) {
                stress = 2;
            }
        }
        if (stress != 0 && !this.hasAccent(token = this.getToken(syllable))) {
            if (this.isPolysyllabic(token)) {
                if (stress == 1) {
                    stress = 2;
                } else if (stress == 2) {
                    stress = 0;
                }
            } else if (!this.isPronoun(token)) {
                stress = 0;
            }
        }
        return stress;
    }

    private static Element getPreviousSegment(Element segment) {
        Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, "phrase");
        return MaryDomUtils.getPreviousOfItsKindIn(segment, phrase);
    }

    private static Element getNextSegment(Element segment) {
        Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, "phrase");
        return MaryDomUtils.getNextOfItsKindIn(segment, phrase);
    }

    private static Element getPreviousSyllable(Element syllable) {
        Element phrase = (Element)MaryDomUtils.getAncestor((Node)syllable, "phrase");
        return MaryDomUtils.getPreviousOfItsKindIn(syllable, phrase);
    }

    private static Element getNextSyllable(Element syllable) {
        if (syllable == null) {
            return null;
        }
        Element phrase = (Element)MaryDomUtils.getAncestor((Node)syllable, "phrase");
        return MaryDomUtils.getNextOfItsKindIn(syllable, phrase);
    }

    private int getMinDuration(Element segment) {
        int minDuration = this.klattDurationParams.getMinDuration(segment.getAttribute("p"));
        if (this.getStress(this.getSyllable(segment)) == 0) {
            return minDuration * this.getPropertyAsInteger("rule7.mindur") / 100;
        }
        return minDuration;
    }

    private int getInhDuration(Element segment) {
        return this.klattDurationParams.getInhDuration(segment.getAttribute("p"));
    }

    private boolean isPronoun(Element token) {
        String pos = token.getAttribute("pos");
        return pos.equals("PDS") || pos.equals("PDAT") || pos.equals("PIS") || pos.equals("PIAT") || pos.equals("PIDAT") || pos.equals("PPER") || pos.equals("PPOSS") || pos.equals("PPOSAT") || pos.equals("PRELS") || pos.equals("PRELAT") || pos.equals("PRF") || pos.equals("PWS") || pos.equals("PWAT") || pos.equals("PWAV");
    }

    private boolean isPolysyllabic(Element token) {
        return token.getElementsByTagName("syllable").getLength() > 1;
    }

    private boolean hasAccent(Element token) {
        String accent = token.getAttribute("accent");
        return !accent.equals("");
    }

    private boolean isLastBeforeBoundary(Element syllable, int minBreakindex) {
        Document doc = syllable.getOwnerDocument();
        Element sentence = (Element)MaryDomUtils.getAncestor((Node)syllable, "s");
        TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(sentence, 1, new NameNodeFilter("syllable", "boundary"), false);
        tw.setCurrentNode(syllable);
        Element next = (Element)tw.nextNode();
        if (next == null) {
            return true;
        }
        return next.getNodeName().equals("boundary") && this.getBreakindex(next) >= minBreakindex;
    }

    private boolean isMajIPFinal(Element syllable) {
        return this.isLastBeforeBoundary(syllable, 4);
    }

    private boolean isMinipFinal(Element syllable) {
        return this.isLastBeforeBoundary(syllable, 3);
    }

    private boolean isWordFinal(Element syllable) {
        Element e = syllable;
        while (e != null) {
            if ((e = MaryDomUtils.getNextSiblingElement(e)) == null || !e.getNodeName().equals("syllable")) continue;
            return false;
        }
        return true;
    }

    private boolean isWordMedial(Element syllable) {
        return !this.isWordFinal(syllable) && !this.isWordInitial(syllable);
    }

    private boolean isWordInitial(Element syllable) {
        Element e = syllable;
        while (e != null) {
            if ((e = MaryDomUtils.getPreviousSiblingElement(e)) == null || !e.getNodeName().equals("syllable")) continue;
            return false;
        }
        return true;
    }

    private boolean isInOnset(Element segment) {
        Allophone ph = this.allophoneSet.getAllophone(segment.getAttribute("p"));
        if (ph.isSyllabic()) {
            return false;
        }
        Element e = MaryDomUtils.getNextSiblingElement(segment);
        while (e != null) {
            ph = this.allophoneSet.getAllophone(e.getAttribute("p"));
            assert (ph != null);
            if (ph.isSyllabic()) {
                return true;
            }
            e = MaryDomUtils.getNextSiblingElement(e);
        }
        return false;
    }

    private boolean isInNucleus(Element segment) {
        Allophone ph = this.allophoneSet.getAllophone(segment.getAttribute("p"));
        assert (ph != null);
        return ph.isSyllabic();
    }

    private boolean isInCoda(Element segment) {
        Allophone ph = this.allophoneSet.getAllophone(segment.getAttribute("p"));
        if (ph.isSyllabic()) {
            return false;
        }
        Element e = MaryDomUtils.getPreviousSiblingElement(segment);
        while (e != null) {
            ph = this.allophoneSet.getAllophone(e.getAttribute("p"));
            if (ph.isSyllabic()) {
                return true;
            }
            e = MaryDomUtils.getPreviousSiblingElement(e);
        }
        return false;
    }

    private boolean isConsonant(Element segment) {
        return !this.isVowel(segment);
    }

    private boolean isVowel(Element segment) {
        Allophone ph = this.allophoneSet.getAllophone(segment.getAttribute("p"));
        return ph.isVowel();
    }

    private boolean isLiquid(Element segment) {
        Allophone ph = this.allophoneSet.getAllophone(segment.getAttribute("p"));
        return ph.isLiquid();
    }

    private boolean isGlide(Element segment) {
        Allophone ph = this.allophoneSet.getAllophone(segment.getAttribute("p"));
        return ph.isGlide();
    }

    private boolean isNasal(Element segment) {
        Allophone ph = this.allophoneSet.getAllophone(segment.getAttribute("p"));
        return ph.isNasal();
    }

    private boolean isFricative(Element segment) {
        Allophone ph = this.allophoneSet.getAllophone(segment.getAttribute("p"));
        return ph.isFricative();
    }

    private int getBreakindex(Element boundary) {
        int breakindex = 0;
        try {
            breakindex = Integer.parseInt(boundary.getAttribute("breakindex"));
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.warn((Object)("Unexpected breakindex value `" + boundary.getAttribute("breakindex") + "'"));
        }
        return breakindex;
    }

    private boolean isPercentageDelta(String string) {
        String s = string.trim();
        if (s.length() < 3) {
            return false;
        }
        return s.substring(s.length() - 1).equals("%") && this.isNumberDelta(s.substring(0, s.length() - 1));
    }

    private int getPercentageDelta(String string) {
        String s = string.trim();
        if (!this.isPercentageDelta(s)) {
            return 0;
        }
        return this.getNumberDelta(s.substring(0, s.length() - 1));
    }

    private boolean isSemitonesDelta(String string) {
        String s = string.trim();
        if (s.length() < 4) {
            return false;
        }
        return s.substring(s.length() - 2).equals("st") && this.isNumberDelta(s.substring(0, s.length() - 2));
    }

    private double getSemitonesDelta(String string) {
        String s = string.trim();
        if (!this.isSemitonesDelta(s)) {
            return 0.0;
        }
        String num = s.substring(0, s.length() - 2);
        double value = 0.0;
        try {
            value = Double.parseDouble(num);
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.warn((Object)("Unexpected number value `" + num + "'"));
        }
        return value;
    }

    private boolean isNumberDelta(String string) {
        String s = string.trim();
        if (s.length() < 2) {
            return false;
        }
        return (s.charAt(0) == '+' || s.charAt(0) == '-') && this.isUnsignedNumber(s.substring(1));
    }

    private int getNumberDelta(String string) {
        String s = string.trim();
        if (!this.isNumberDelta(s)) {
            return 0;
        }
        double value = 0.0;
        try {
            value = Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.warn((Object)("Unexpected number value `" + s + "'"));
        }
        return (int)Math.round(value);
    }

    private boolean isUnsignedSemitones(String string) {
        String s = string.trim();
        if (s.length() < 3) {
            return false;
        }
        return s.substring(s.length() - 2).equals("st") && this.isUnsignedNumber(s.substring(0, s.length() - 2));
    }

    private double getUnsignedSemitones(String string) {
        String s = string.trim();
        if (!this.isUnsignedSemitones(s)) {
            return 0.0;
        }
        String num = s.substring(0, s.length() - 2);
        double value = 0.0;
        try {
            value = Double.parseDouble(num);
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.warn((Object)("Unexpected number value `" + num + "'"));
        }
        return value;
    }

    private boolean isUnsignedNumber(String string) {
        String s = string.trim();
        if (s.length() < 1) {
            return false;
        }
        if (s.charAt(0) != '+' && s.charAt(0) != '-') {
            try {
                Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return true;
        }
        return false;
    }

    private int getUnsignedNumber(String string) {
        String s = string.trim();
        if (!this.isUnsignedNumber(s)) {
            return 0;
        }
        double value = 0.0;
        try {
            value = Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.warn((Object)("Unexpected number value `" + s + "'"));
        }
        return (int)Math.round(value);
    }

    private boolean isNumber(String string) {
        String s = string.trim();
        if (s.length() < 1) {
            return false;
        }
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private int getNumber(String string) {
        String s = string.trim();
        if (!this.isNumber(s)) {
            return 0;
        }
        double value = 0.0;
        try {
            value = Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.warn((Object)("Unexpected number value `" + s + "'"));
        }
        return (int)Math.round(value);
    }

    private Element getStressedSyllable(Element token) {
        Element first;
        if (token == null || !token.getTagName().equals("t")) {
            return null;
        }
        Element syl = MaryDomUtils.getFirstElementByTagName(token, "syllable");
        while (syl != null && !syl.getAttribute("stress").equals("1")) {
            syl = MaryDomUtils.getNextSiblingElementByTagName(syl, "syllable");
        }
        if (syl != null) {
            return syl;
        }
        Element secondary = first = MaryDomUtils.getFirstElementByTagName(token, "syllable");
        while (secondary != null && !secondary.getAttribute("stress").equals("2")) {
            secondary = MaryDomUtils.getNextSiblingElementByTagName(secondary, "syllable");
        }
        if (secondary != null) {
            return secondary;
        }
        return first;
    }

    private Element getNucleus(Element syllable) {
        if (syllable == null || !syllable.getTagName().equals("syllable")) {
            return null;
        }
        Element seg = MaryDomUtils.getFirstElementByTagName(syllable, "ph");
        while (seg != null && !this.isInNucleus(seg)) {
            seg = MaryDomUtils.getNextSiblingElementByTagName(seg, "ph");
        }
        return seg;
    }

    public static class KlattDurationParams {
        private Map<String, Integer> inh = new HashMap<String, Integer>();
        private Map<String, Integer> min = new HashMap<String, Integer>();

        public KlattDurationParams(String filename) throws SAXException, IOException, ParserConfigurationException {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(filename));
            NodeList segElements = document.getElementsByTagName("segment");
            int i = 0;
            while (i < segElements.getLength()) {
                Element seg = (Element)segElements.item(i);
                String name = seg.getAttribute("s");
                int inherentDuration = Integer.parseInt(seg.getAttribute("inh"));
                int minimalDuration = Integer.parseInt(seg.getAttribute("min"));
                this.inh.put(name, inherentDuration);
                this.min.put(name, minimalDuration);
                ++i;
            }
        }

        public int getInhDuration(String ph) {
            return this.inh.get(ph);
        }

        public int getMinDuration(String ph) {
            return this.min.get(ph);
        }
    }

    static class ProsodicSettings {
        int rate;
        int accentProminence;
        int accentSlope;
        int numberOfPauses;
        int pauseDuration;
        int vowelDuration;
        int plosiveDuration;
        int fricativeDuration;
        int nasalDuration;
        int liquidDuration;
        int glideDuration;
        int volume;

        ProsodicSettings() {
            this.rate = 100;
            this.accentProminence = 100;
            this.accentSlope = 100;
            this.numberOfPauses = 100;
            this.pauseDuration = 100;
            this.vowelDuration = 100;
            this.plosiveDuration = 100;
            this.fricativeDuration = 100;
            this.nasalDuration = 100;
            this.liquidDuration = 100;
            this.glideDuration = 100;
            this.volume = 50;
        }

        ProsodicSettings(int rate, int accentProminence, int accentSlope, int numberOfPauses, int pauseDuration, int vowelDuration, int plosiveDuration, int fricativeDuration, int nasalDuration, int liquidDuration, int glideDuration, int volume) {
            this.rate = rate;
            this.accentProminence = accentProminence;
            this.accentSlope = accentSlope;
            this.numberOfPauses = numberOfPauses;
            this.pauseDuration = pauseDuration;
            this.vowelDuration = vowelDuration;
            this.plosiveDuration = plosiveDuration;
            this.fricativeDuration = fricativeDuration;
            this.nasalDuration = nasalDuration;
            this.liquidDuration = liquidDuration;
            this.glideDuration = glideDuration;
            this.volume = volume;
        }

        int rate() {
            return this.rate;
        }

        int accentProminence() {
            return this.accentProminence;
        }

        int accentSlope() {
            return this.accentSlope;
        }

        int numberOfPauses() {
            return this.numberOfPauses;
        }

        int pauseDuration() {
            return this.pauseDuration;
        }

        int vowelDuration() {
            return this.vowelDuration;
        }

        int plosiveDuration() {
            return this.plosiveDuration;
        }

        int fricativeDuration() {
            return this.fricativeDuration;
        }

        int nasalDuration() {
            return this.nasalDuration;
        }

        int liquidDuration() {
            return this.liquidDuration;
        }

        int glideDuration() {
            return this.glideDuration;
        }

        int volume() {
            return this.volume;
        }

        void setRate(int value) {
            this.rate = value;
        }

        void setAccentProminence(int value) {
            this.accentProminence = value;
        }

        void setAccentSlope(int value) {
            this.accentSlope = value;
        }

        void setNumberOfPauses(int value) {
            this.numberOfPauses = value;
        }

        void setPauseDuration(int value) {
            this.pauseDuration = value;
        }

        void setVowelDuration(int value) {
            this.vowelDuration = value;
        }

        void setPlosiveDuration(int value) {
            this.plosiveDuration = value;
        }

        void setFricativeDuration(int value) {
            this.fricativeDuration = value;
        }

        void setNasalDuration(int value) {
            this.nasalDuration = value;
        }

        void setLiquidDuration(int value) {
            this.liquidDuration = value;
        }

        void setGlideDuration(int value) {
            this.glideDuration = value;
        }

        void setVolume(int value) {
            this.volume = value;
        }
    }
}

