/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.SynthesisException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureProcessorManager;
import marytts.features.FeatureRegistry;
import marytts.features.FeatureVector;
import marytts.features.TargetFeatureComputer;
import marytts.htsengine.CartTreeSet;
import marytts.htsengine.HMMData;
import marytts.htsengine.HMMVoice;
import marytts.htsengine.HTSModel;
import marytts.htsengine.HTSPStream;
import marytts.htsengine.HTSParameterGeneration;
import marytts.htsengine.HTSUttModel;
import marytts.modules.InternalModule;
import marytts.modules.ModuleRegistry;
import marytts.modules.TargetFeatureLister;
import marytts.modules.synthesis.Voice;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import marytts.util.math.Polynomial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class HMMDurationF0Modeller
extends InternalModule {
    private String hmmVoiceName;
    private Locale locale;
    private FeatureProcessorManager featureProcessorManager;
    private TargetFeatureLister targetFeatureLister;
    protected TargetFeatureComputer featureComputer;

    public HMMDurationF0Modeller(String locale, String hmmVoiceName) throws Exception {
        this(MaryUtils.string2locale(locale), hmmVoiceName, FeatureRegistry.getFeatureProcessorManager(MaryUtils.string2locale(locale)));
    }

    public HMMDurationF0Modeller(Locale locale, String hmmVoiceName, FeatureProcessorManager featureProcessorManager) {
        super("HMMDurationF0Modeller", MaryDataType.ALLOPHONES, MaryDataType.ACOUSTPARAMS, locale);
        this.hmmVoiceName = hmmVoiceName;
        this.locale = locale;
        this.featureProcessorManager = featureProcessorManager;
    }

    @Override
    public void startup() throws Exception {
        super.startup();
        try {
            this.targetFeatureLister = (TargetFeatureLister)ModuleRegistry.getModule(TargetFeatureLister.class);
        }
        catch (NullPointerException nullPointerException) {
            this.targetFeatureLister = null;
        }
        if (this.targetFeatureLister == null) {
            this.logger.info((Object)"Starting my own TargetFeatureLister");
            this.targetFeatureLister = new TargetFeatureLister();
            this.targetFeatureLister.startup();
        } else if (this.targetFeatureLister.getState() == 0) {
            this.targetFeatureLister.startup();
        }
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Element e;
        HTSUttModel um = new HTSUttModel();
        HMMVoice hmmVoice = (HMMVoice)Voice.getVoice(this.hmmVoiceName);
        String features = d.getOutputParams();
        if (hmmVoice != null) {
            this.featureComputer = FeatureRegistry.getTargetFeatureComputer(hmmVoice, features);
        }
        assert (this.featureComputer != null) : "Cannot get a feature computer!";
        Document doc = d.getDocument();
        TreeWalker tw = MaryDomUtils.createTreeWalker(doc, doc, "ph", "boundary");
        ArrayList<Element> segmentsAndBoundaries = new ArrayList<Element>();
        while ((e = (Element)tw.nextNode()) != null) {
            segmentsAndBoundaries.add(e);
        }
        TargetFeatureComputer comp = FeatureRegistry.getTargetFeatureComputer(hmmVoice, features);
        String targetFeatureString = this.targetFeatureLister.listTargetFeatures(comp, segmentsAndBoundaries);
        if (hmmVoice != null) {
            String context = targetFeatureString;
            try (Scanner s = null;){
                s = new Scanner(context);
                this.processUtt(s, um, hmmVoice.getHMMData(), hmmVoice.getHMMData().getCartTreeSet());
                String realisedDurF0s = this.HmmF0Generation(um, hmmVoice.getHMMData());
                this.setActualDurationsAndF0s(tw, realisedDurF0s);
            }
        } else {
            this.logger.debug((Object)("No HMM voice called " + this.hmmVoiceName));
        }
        ByteArrayOutputStream dummy = new ByteArrayOutputStream();
        d.writeTo(dummy);
        this.applyProsodySpecifications(doc);
        return d;
    }

    private void applyProsodySpecifications(Document doc) {
        TreeWalker tw = MaryDomUtils.createTreeWalker(doc, doc, "ph", "boundary", "prosody");
        Element e = null;
        while ((e = (Element)tw.nextNode()) != null) {
            if (!"prosody".equals(e.getNodeName())) continue;
            NodeList nl = e.getElementsByTagName("ph");
            this.applyNewContourSpecifications(nl, e);
            this.applySpeechRateSpecifications(nl, e);
        }
    }

    private void applySpeechRateSpecifications(NodeList nl, Element prosodyElement) {
        String rateAttribute = null;
        if (!prosodyElement.hasAttribute("rate")) {
            return;
        }
        rateAttribute = prosodyElement.getAttribute("rate");
        Pattern p = Pattern.compile("[+|-]\\d+%");
        Matcher m = p.matcher(rateAttribute);
        if (m.find()) {
            double percentage = new Integer(rateAttribute.substring(1, rateAttribute.length() - 1)).doubleValue();
            if (rateAttribute.startsWith("+")) {
                this.setSpeechRateSpecifications(nl, percentage, -1.0);
            } else {
                this.setSpeechRateSpecifications(nl, percentage, 1.0);
            }
        }
    }

    private void setSpeechRateSpecifications(NodeList nl, double percentage, double incriment) {
        Element nd;
        int i = 0;
        while (i < nl.getLength()) {
            Element e = (Element)nl.item(i);
            if (e.hasAttribute("d")) {
                double durAttribute = new Double(e.getAttribute("d"));
                double newDurAttribute = durAttribute + incriment * percentage * durAttribute / 100.0;
                e.setAttribute("d", String.valueOf(newDurAttribute));
            }
            ++i;
        }
        Element e = (Element)nl.item(0);
        Element rootElement = e.getOwnerDocument().getDocumentElement();
        NodeIterator nit = MaryDomUtils.createNodeIterator(rootElement, "ph", "boundary");
        double duration = 0.0;
        while ((nd = (Element)nit.nextNode()) != null) {
            if ("boundary".equals(nd.getNodeName())) {
                if (nd.hasAttribute("duration")) {
                    duration += new Double(nd.getAttribute("duration")).doubleValue();
                }
            } else if (nd.hasAttribute("d")) {
                duration += new Double(nd.getAttribute("d")).doubleValue();
            }
            double endTime = 0.001 * duration;
            nd.setAttribute("end", String.valueOf(endTime));
        }
    }

    private void applyNewContourSpecifications(NodeList nl, Element prosodyElement) {
        String contourAttribute = null;
        if (prosodyElement.hasAttribute("contour")) {
            contourAttribute = prosodyElement.getAttribute("contour");
        }
        String pitchAttribute = null;
        if (prosodyElement.hasAttribute("pitch")) {
            pitchAttribute = prosodyElement.getAttribute("pitch");
        }
        if (contourAttribute == null && pitchAttribute == null) {
            return;
        }
        double[] contour = this.getContiniousContour(nl);
        contour = this.interpolateNonZeroValues(contour);
        double[] coeffs = Polynomial.fitPolynomial(contour, 1);
        double[] polyValues = Polynomial.generatePolynomialValues(coeffs, 100, 0.0, 1.0);
        double[] diffValues = new double[100];
        int i = 0;
        while (i < contour.length) {
            diffValues[i] = contour[i] - polyValues[i];
            ++i;
        }
        polyValues = this.setBaseContourModifications(polyValues, contourAttribute, pitchAttribute);
        i = 0;
        while (i < contour.length) {
            contour[i] = diffValues[i] + polyValues[i];
            ++i;
        }
        this.setModifiedContour(nl, contour);
    }

    private void setModifiedContour(NodeList nl, double[] contour) {
        Element firstElement = (Element)nl.item(0);
        Element lastElement = (Element)nl.item(nl.getLength() - 1);
        double fEnd = new Double(firstElement.getAttribute("end"));
        double fDuration = 0.001 * new Double(firstElement.getAttribute("d"));
        double lEnd = new Double(lastElement.getAttribute("end"));
        double fStart = fEnd - fDuration;
        double duration = lEnd - fStart;
        int i = 0;
        while (i < nl.getLength()) {
            Element e = (Element)nl.item(i);
            String f0Attribute = e.getAttribute("f0");
            if (f0Attribute != null && !"".equals(f0Attribute)) {
                double phoneEndTime = new Double(e.getAttribute("end"));
                double phoneDuration = 0.001 * new Double(e.getAttribute("d"));
                Pattern p = Pattern.compile("(\\d+,\\d+)");
                Matcher m = p.matcher(e.getAttribute("f0"));
                String setF0String = "";
                while (m.find()) {
                    String[] f0Values = m.group().trim().split(",");
                    Integer percent = new Integer(f0Values[0]);
                    new Integer(f0Values[1]);
                    double partPhone = phoneDuration * (percent.doubleValue() / 100.0);
                    int placeIndex = (int)Math.floor((phoneEndTime - phoneDuration - fStart + partPhone) * 100.0 / duration);
                    if (placeIndex >= 100) {
                        placeIndex = 99;
                    }
                    setF0String = String.valueOf(setF0String) + "(" + percent + "," + (int)contour[placeIndex] + ")";
                }
                e.setAttribute("f0", setF0String);
            }
            ++i;
        }
    }

    private double[] setBaseContourModifications(double[] polyValues, String contourAttribute, String pitchAttribute) {
        if (pitchAttribute != null && !"".equals(pitchAttribute)) {
            polyValues = this.setPitchSpecifications(polyValues, pitchAttribute);
        }
        if (contourAttribute != null && !"".equals(contourAttribute)) {
            polyValues = this.setContourSpecifications(polyValues, contourAttribute);
        }
        return polyValues;
    }

    private double[] setContourSpecifications(double[] polyValues, String contourAttribute) {
        Map<String, String> f0Specifications = this.getContourSpecifications(contourAttribute);
        Iterator<String> it = f0Specifications.keySet().iterator();
        double[] modifiedF0Values = new double[100];
        Arrays.fill(modifiedF0Values, 0.0);
        if (polyValues.length != modifiedF0Values.length) {
            throw new RuntimeException("The lengths of two arrays are not same!");
        }
        modifiedF0Values[0] = polyValues[0];
        modifiedF0Values[modifiedF0Values.length - 1] = polyValues[modifiedF0Values.length - 1];
        while (it.hasNext()) {
            String percent = it.next();
            String f0Value = f0Specifications.get(percent);
            int percentDuration = new Integer(percent.substring(0, percent.length() - 1));
            if (f0Value.startsWith("+")) {
                if (f0Value.endsWith("%")) {
                    double f0Mod = new Double(f0Value.substring(1, f0Value.length() - 1));
                    modifiedF0Values[percentDuration] = polyValues[percentDuration] + polyValues[percentDuration] * (f0Mod / 100.0);
                    continue;
                }
                if (!f0Value.endsWith("Hz")) continue;
                int f0Mod = new Integer(f0Value.substring(1, f0Value.length() - 2));
                modifiedF0Values[percentDuration] = polyValues[percentDuration] + (double)f0Mod;
                continue;
            }
            if (!f0Value.startsWith("-")) continue;
            if (f0Value.endsWith("%")) {
                double f0Mod = new Double(f0Value.substring(1, f0Value.length() - 1));
                modifiedF0Values[percentDuration] = polyValues[percentDuration] - polyValues[percentDuration] * (f0Mod / 100.0);
                continue;
            }
            if (!f0Value.endsWith("Hz")) continue;
            int f0Mod = new Integer(f0Value.substring(1, f0Value.length() - 2));
            modifiedF0Values[percentDuration] = polyValues[percentDuration] - (double)f0Mod;
        }
        modifiedF0Values = this.interpolateNonZeroValues(modifiedF0Values);
        return modifiedF0Values;
    }

    private double[] setPitchSpecifications(double[] polyValues, String pitchAttribute) {
        block10: {
            double modificationPitch;
            block8: {
                block9: {
                    pitchAttribute.startsWith("+");
                    modificationPitch = new Integer(pitchAttribute.substring(1, pitchAttribute.length() - 1)).doubleValue();
                    if (!pitchAttribute.startsWith("+")) break block8;
                    if (!pitchAttribute.endsWith("%")) break block9;
                    int i = 0;
                    while (i < polyValues.length) {
                        polyValues[i] = polyValues[i] + polyValues[i] * (modificationPitch / 100.0);
                        ++i;
                    }
                    break block10;
                }
                if (!pitchAttribute.endsWith("Hz")) break block10;
                int i = 0;
                while (i < polyValues.length) {
                    polyValues[i] = polyValues[i] + modificationPitch;
                    ++i;
                }
                break block10;
            }
            if (pitchAttribute.startsWith("-")) {
                if (pitchAttribute.endsWith("%")) {
                    int i = 0;
                    while (i < polyValues.length) {
                        polyValues[i] = polyValues[i] - polyValues[i] * (modificationPitch / 100.0);
                        ++i;
                    }
                } else if (pitchAttribute.endsWith("Hz")) {
                    int i = 0;
                    while (i < polyValues.length) {
                        polyValues[i] = polyValues[i] - modificationPitch;
                        ++i;
                    }
                }
            }
        }
        return polyValues;
    }

    private Map<String, String> getContourSpecifications(String attribute) {
        HashMap<String, String> f0Map = new HashMap<String, String>();
        Pattern p = Pattern.compile("(\\d+%,[+|-]\\d+[%|Hz])");
        Matcher m = p.matcher(attribute);
        while (m.find()) {
            String[] f0Values = m.group().trim().split(",");
            f0Map.put(f0Values[0], f0Values[1]);
        }
        return f0Map;
    }

    private double[] interpolateNonZeroValues(double[] contour) {
        int i = 0;
        while (i < contour.length) {
            if (contour[i] == 0.0) {
                int j;
                int index = this.findNextIndexNonZero(contour, i);
                if (index == -1) {
                    j = i;
                    while (j < contour.length) {
                        contour[j] = contour[j - 1];
                        ++j;
                    }
                    break;
                }
                j = i;
                while (j < index) {
                    contour[j] = i == 0 ? contour[index] : contour[j - 1] + (contour[index] - contour[i - 1]) / (double)(index - i);
                    ++j;
                }
                i = index - 1;
            }
            ++i;
        }
        return contour;
    }

    private int findNextIndexNonZero(double[] contour, int current) {
        int i = current + 1;
        while (i < contour.length) {
            if (contour[i] != 0.0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private double[] getContiniousContour(NodeList nl) {
        Element firstElement = (Element)nl.item(0);
        Element lastElement = (Element)nl.item(nl.getLength() - 1);
        double[] contour = new double[100];
        Arrays.fill(contour, 0.0);
        double fEnd = new Double(firstElement.getAttribute("end"));
        double fDuration = 0.001 * new Double(firstElement.getAttribute("d"));
        double lEnd = new Double(lastElement.getAttribute("end"));
        double fStart = fEnd - fDuration;
        double duration = lEnd - fStart;
        int i = 0;
        while (i < nl.getLength()) {
            Element e = (Element)nl.item(i);
            String f0Attribute = e.getAttribute("f0");
            if (f0Attribute != null && !"".equals(f0Attribute)) {
                double phoneEndTime = new Double(e.getAttribute("end"));
                double phoneDuration = 0.001 * new Double(e.getAttribute("d"));
                Map<Integer, Integer> f0Map = this.getPhoneF0Data(e.getAttribute("f0"));
                for (Integer percent : f0Map.keySet()) {
                    Integer f0Value = f0Map.get(percent);
                    double partPhone = phoneDuration * (percent.doubleValue() / 100.0);
                    int placeIndex = (int)Math.floor((phoneEndTime - phoneDuration - fStart + partPhone) * 100.0 / duration);
                    if (placeIndex >= 100) {
                        placeIndex = 99;
                    }
                    contour[placeIndex] = f0Value.doubleValue();
                }
            }
            ++i;
        }
        return contour;
    }

    private Map<Integer, Integer> getPhoneF0Data(String attribute) {
        HashMap<Integer, Integer> f0Map = new HashMap<Integer, Integer>();
        Pattern p = Pattern.compile("(\\d+,\\d+)");
        Matcher m = p.matcher(attribute);
        while (m.find()) {
            String[] f0Values = m.group().trim().split(",");
            f0Map.put(new Integer(f0Values[0]), new Integer(f0Values[1]));
        }
        return f0Map;
    }

    private String processUtt(Scanner s, HTSUttModel um, HMMData htsData, CartTreeSet cart) throws Exception {
        HTSModel m;
        String nextLine;
        double diffdurOld = 0.0;
        double diffdurNew = 0.0;
        float fperiodmillisec = (float)htsData.getFperiod() / (float)htsData.getRate() * 1000.0f;
        float fperiodsec = (float)htsData.getFperiod() / (float)htsData.getRate();
        boolean firstPh = true;
        boolean lastPh = false;
        Integer numLab = 0;
        FeatureDefinition feaDef = htsData.getFeatureDefinition();
        while (s.hasNext()) {
            nextLine = s.nextLine();
            if (nextLine.trim().equals("")) break;
        }
        while (s.hasNext()) {
            nextLine = s.nextLine();
            if (nextLine.trim().equals("")) break;
        }
        int i = 0;
        while (s.hasNext()) {
            nextLine = s.nextLine();
            FeatureVector fv = feaDef.toFeatureVector(0, nextLine);
            um.addUttModel(new HTSModel(cart.getNumStates()));
            m = um.getUttModel(i);
            m.setPhoneName(fv.getFeatureAsString(feaDef.getFeatureIndex("phone"), feaDef));
            if (!s.hasNext()) {
                lastPh = true;
            }
            diffdurNew = cart.searchDurInCartTree(m, fv, htsData, firstPh, lastPh, diffdurOld);
            um.setTotalFrame(um.getTotalFrame() + m.getTotalDur());
            m.setTotalDurMillisec((int)(fperiodmillisec * (float)m.getTotalDur()));
            diffdurOld = diffdurNew;
            Float.valueOf((float)um.getTotalFrame() * fperiodsec);
            numLab = numLab + 1;
            Integer dur = m.getTotalDurMillisec();
            um.concatRealisedAcoustParams(String.valueOf(m.getPhoneName()) + " " + dur.toString() + "\n");
            cart.searchLf0InCartTree(m, fv, feaDef, htsData.getUV());
            um.setNumModel(um.getNumModel() + 1);
            um.setNumState(um.getNumState() + cart.getNumStates());
            ++i;
            if (!firstPh) continue;
            firstPh = false;
        }
        i = 0;
        while (i < um.getNumUttModel()) {
            m = um.getUttModel(i);
            int mstate = 0;
            while (mstate < cart.getNumStates()) {
                int frame = 0;
                while (frame < m.getDur(mstate)) {
                    if (m.getVoiced(mstate)) {
                        um.setLf0Frame(um.getLf0Frame() + 1);
                    }
                    ++frame;
                }
                ++mstate;
            }
            ++i;
        }
        return um.getRealisedAcoustParams();
    }

    public String HmmF0Generation(HTSUttModel um, HMMData htsData) throws Exception {
        int frame;
        int hmmState;
        HTSModel m;
        HTSPStream lf0Pst = null;
        CartTreeSet ms = htsData.getCartTreeSet();
        lf0Pst = new HTSPStream(ms.getLf0Stream(), um.getLf0Frame(), HMMData.FeatureType.LF0, 200);
        int lf0Frame = 0;
        int uttFrame = 0;
        boolean[] voiced = new boolean[um.getTotalFrame()];
        int i = 0;
        while (i < um.getNumUttModel()) {
            m = um.getUttModel(i);
            hmmState = 0;
            while (hmmState < ms.getNumStates()) {
                frame = 0;
                while (frame < m.getDur(hmmState)) {
                    voiced[uttFrame] = m.getVoiced(hmmState);
                    ++uttFrame;
                    if (m.getVoiced(hmmState)) {
                        ++lf0Frame;
                    }
                    ++frame;
                }
                ++hmmState;
            }
            ++i;
        }
        uttFrame = 0;
        lf0Frame = 0;
        i = 0;
        while (i < um.getNumUttModel()) {
            m = um.getUttModel(i);
            hmmState = 0;
            while (hmmState < ms.getNumStates()) {
                frame = 0;
                while (frame < m.getDur(hmmState)) {
                    int k = 0;
                    while (k < ms.getLf0Stream()) {
                        int lw = lf0Pst.getDWLeftBoundary(k);
                        int rw = lf0Pst.getDWRightBoundary(k);
                        boolean nobound = true;
                        int n = lw;
                        while (n <= rw) {
                            nobound = uttFrame + n <= 0 || um.getTotalFrame() <= uttFrame + n ? false : nobound && voiced[uttFrame + n];
                            ++n;
                        }
                        if (voiced[uttFrame]) {
                            lf0Pst.setMseq(lf0Frame, k, m.getLf0Mean(hmmState, k));
                            if (nobound || k == 0) {
                                lf0Pst.setIvseq(lf0Frame, k, HTSParameterGeneration.finv(m.getLf0Variance(hmmState, k)));
                            } else {
                                lf0Pst.setIvseq(lf0Frame, k, 0.0);
                            }
                        }
                        ++k;
                    }
                    if (voiced[uttFrame]) {
                        ++lf0Frame;
                    }
                    ++uttFrame;
                    ++frame;
                }
                ++hmmState;
            }
            ++i;
        }
        double[] f0s = new double[voiced.length];
        i = 0;
        if (lf0Frame > 0) {
            this.logger.info((Object)"Parameter generation for LF0: ");
            lf0Pst.mlpg(htsData, htsData.getUseGV());
            int t = 0;
            while (t < voiced.length) {
                if (voiced[t]) {
                    f0s[t] = Math.exp(lf0Pst.getPar(i, 0));
                    ++i;
                } else {
                    f0s[t] = 0.0;
                }
                ++t;
            }
        }
        String f0Values = "";
        int t = 0;
        i = 0;
        while (i < um.getNumUttModel()) {
            m = um.getUttModel(i);
            f0Values = String.valueOf(f0Values) + m.getPhoneName() + " " + m.getTotalDurMillisec() + " ";
            double totalDur = m.getTotalDur();
            int totalFrames = 0;
            if (this.checkModelVoiced(m, ms.getNumStates())) {
                int j = 0;
                while (j < ms.getNumStates()) {
                    frame = 0;
                    while (frame < m.getDur(j)) {
                        ++totalFrames;
                        if (f0s[t] > 0.0) {
                            f0Values = String.valueOf(f0Values) + "(" + Integer.toString((int)((double)totalFrames / totalDur * 100.0)) + "," + Integer.toString((int)f0s[t]) + ")";
                        }
                        ++t;
                        ++frame;
                    }
                    ++j;
                }
            } else {
                t += m.getTotalDur();
                f0Values = String.valueOf(f0Values) + "0";
            }
            f0Values = String.valueOf(f0Values) + "\n";
            ++i;
        }
        return f0Values;
    }

    public void setActualDurations(TreeWalker tw, String durations) throws SynthesisException {
        Element e;
        Scanner s = null;
        Vector<String> ph = new Vector<String>();
        Vector<Integer> dur = new Vector<Integer>();
        float totalDur = 0.0f;
        s = new Scanner(durations).useDelimiter("\n");
        while (s.hasNext()) {
            String line = s.next();
            String[] str = line.split(" ");
            ph.add(str[0]);
            dur.add(Integer.valueOf(str[1]));
        }
        if (dur.size() > 1 && ((String)ph.get(0)).contentEquals("_")) {
            dur.set(1, (Integer)dur.get(1) + (Integer)dur.get(0));
            ph.set(0, "");
            ph.set(0, "");
        }
        tw.setCurrentNode(tw.getRoot());
        while ((e = (Element)tw.nextNode()) != null) {
            int index;
            if (e.getTagName().equals("ph")) {
                Element phone = e;
                String p = phone.getAttribute("p");
                index = ph.indexOf(p);
                int currentDur = (Integer)dur.elementAt(index);
                phone.setAttribute("d", String.valueOf(currentDur));
                phone.setAttribute("end", String.valueOf(totalDur += (float)currentDur * 0.001f));
                ph.set(index, "");
                continue;
            }
            if (!e.getTagName().contentEquals("boundary")) continue;
            int breakindex = 0;
            try {
                breakindex = Integer.parseInt(e.getAttribute("breakindex"));
            }
            catch (NumberFormatException numberFormatException) {}
            if (!e.hasAttribute("duration") && breakindex < 3) continue;
            index = ph.indexOf("_");
            int currentDur = (Integer)dur.elementAt(index);
            totalDur += (float)currentDur * 0.001f;
            e.setAttribute("duration", String.valueOf(currentDur));
            ph.set(index, "");
        }
    }

    public void setActualDurationsAndF0s(TreeWalker tw, String durF0s) throws SynthesisException {
        Element e;
        Scanner s = null;
        Vector<String> ph = new Vector<String>();
        Vector<Integer> dur = new Vector<Integer>();
        Vector<String> f0 = new Vector<String>();
        float totalDur = 0.0f;
        s = new Scanner(durF0s).useDelimiter("\n");
        while (s.hasNext()) {
            String line = s.next();
            String[] str = line.split(" ");
            ph.add(str[0]);
            dur.add(Integer.valueOf(str[1]));
            f0.add(str[2]);
        }
        if (dur.size() > 1 && ((String)ph.get(0)).contentEquals("_")) {
            dur.set(1, (Integer)dur.get(1) + (Integer)dur.get(0));
            ph.set(0, "");
            ph.set(0, "");
        }
        tw.setCurrentNode(tw.getRoot());
        while ((e = (Element)tw.nextNode()) != null) {
            int index;
            if (e.getTagName().equals("ph")) {
                Element phone = e;
                String p = phone.getAttribute("p");
                index = ph.indexOf(p);
                int currentDur = (Integer)dur.elementAt(index);
                String currentF0 = (String)f0.elementAt(index);
                phone.setAttribute("d", String.valueOf(currentDur));
                phone.setAttribute("end", String.valueOf(totalDur += (float)currentDur * 0.001f));
                if (!currentF0.contentEquals("0")) {
                    phone.setAttribute("f0", currentF0);
                }
                ph.set(index, "");
                continue;
            }
            if (!e.getTagName().contentEquals("boundary")) continue;
            int breakindex = 0;
            try {
                breakindex = Integer.parseInt(e.getAttribute("breakindex"));
            }
            catch (NumberFormatException numberFormatException) {}
            if (!e.hasAttribute("duration") && breakindex < 3) continue;
            index = ph.indexOf("_");
            int currentDur = (Integer)dur.elementAt(index);
            totalDur += (float)currentDur * 0.001f;
            e.setAttribute("duration", String.valueOf(currentDur));
            ph.set(index, "");
        }
    }

    private boolean checkModelVoiced(HTSModel m, int numStates) {
        int numVoiced = 0;
        int numUnvoiced = 0;
        int i = 0;
        while (i < numStates) {
            if (m.getVoiced(i)) {
                ++numVoiced;
            } else {
                ++numUnvoiced;
            }
            ++i;
        }
        return numVoiced >= numUnvoiced;
    }
}

