/*
 * Decompiled with CFR 0.152.
 */
package marytts.htsengine;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Vector;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;

public class PhoneTranslator {
    private Logger logger = MaryUtils.getLogger("PhoneTranslator");
    private String contextFeatureFile;
    private String trickyPhonesFile;
    private int iPhoneme;
    private int iPrevPhoneme;
    private int iPrevPrevPhoneme;
    private int iNextPhoneme;
    private int iNextNextPhoneme;
    private Map<String, String> trickyPhones = new HashMap<String, String>();
    private Map<String, String> actualPhones = new HashMap<String, String>();

    public PhoneTranslator(InputStream trickyPhonesStream) throws IOException {
        if (trickyPhonesStream != null) {
            this.loadTrickyPhones(trickyPhonesStream);
        }
    }

    public void setContextFeatureFile(String str) {
        this.contextFeatureFile = str;
    }

    public String features2context(FeatureDefinition def, FeatureVector featureVector, Vector<String> featureList) {
        if (featureList == null) {
            featureList = new Vector<String>(Arrays.asList(def.getFeatureNames().split("\\s+")));
        }
        int feaAsInt = featureVector.getFeatureAsInt(this.iPhoneme);
        String mary_phone = this.replaceTrickyPhones(def.getFeatureValueAsString(this.iPhoneme, feaAsInt));
        feaAsInt = featureVector.getFeatureAsInt(this.iPrevPhoneme);
        String mary_prev_phone = feaAsInt > 0 ? this.replaceTrickyPhones(def.getFeatureValueAsString(this.iPrevPhoneme, feaAsInt)) : mary_phone;
        feaAsInt = featureVector.getFeatureAsInt(this.iPrevPrevPhoneme);
        String mary_prev_prev_phone = feaAsInt > 0 ? this.replaceTrickyPhones(def.getFeatureValueAsString(this.iPrevPrevPhoneme, feaAsInt)) : mary_prev_phone;
        feaAsInt = featureVector.getFeatureAsInt(this.iNextPhoneme);
        String mary_next_phone = feaAsInt > 0 ? this.replaceTrickyPhones(def.getFeatureValueAsString(this.iNextPhoneme, feaAsInt)) : mary_phone;
        feaAsInt = featureVector.getFeatureAsInt(this.iNextNextPhoneme);
        String mary_next_next_phone = feaAsInt > 0 ? this.replaceTrickyPhones(def.getFeatureValueAsString(this.iNextNextPhoneme, feaAsInt)) : mary_next_phone;
        StringBuilder contextName = new StringBuilder();
        contextName.append("prev_prev_phone=" + mary_prev_prev_phone);
        contextName.append("|prev_phone=" + mary_prev_phone);
        contextName.append("|phone=" + mary_phone);
        contextName.append("|next_phone=" + mary_next_phone);
        contextName.append("|next_next_phone=" + mary_next_next_phone);
        contextName.append("||");
        for (String f : featureList) {
            if (!def.hasFeature(f)) {
                throw new IllegalArgumentException("Feature '" + f + "' is not known in the feature definition. Valid features are: " + def.getFeatureNames());
            }
            contextName.append(f);
            contextName.append("=");
            String value = def.getFeatureValueAsString(f, featureVector);
            if (f.contains("sentence_punc") || f.contains("punctuation")) {
                value = this.replacePunc(value);
            } else if (f.contains("tobi")) {
                value = this.replaceToBI(value);
            }
            contextName.append(value);
            contextName.append("|");
        }
        return contextName.toString();
    }

    public String features2LongContext(FeatureDefinition def, FeatureVector featureVector, Vector<String> featureList) {
        if (featureList == null) {
            featureList = new Vector<String>(Arrays.asList(def.getFeatureNames().split("\\s+")));
        }
        StringBuilder contextName = new StringBuilder();
        contextName.append("|");
        for (String f : featureList) {
            if (!def.hasFeature(f)) {
                throw new IllegalArgumentException("Feature '" + f + "' is not known in the feature definition. Valid features are: " + def.getFeatureNames());
            }
            contextName.append(f);
            contextName.append("=");
            String value = def.getFeatureValueAsString(f, featureVector);
            if (f.endsWith("phone")) {
                value = this.replaceTrickyPhones(value);
            } else if (f.contains("sentence_punc") || f.contains("punctuation")) {
                value = this.replacePunc(value);
            } else if (f.contains("tobi")) {
                value = this.replaceToBI(value);
            }
            contextName.append(value);
            contextName.append("|");
        }
        return contextName.toString();
    }

    private void loadTrickyPhones(InputStream trickyStream) throws IOException {
        Scanner aliasList = null;
        aliasList = new Scanner(new BufferedReader(new InputStreamReader(trickyStream, "UTF-8")));
        this.logger.debug((Object)"loading tricky phones");
        while (aliasList.hasNext()) {
            String line = aliasList.nextLine();
            String[] ph = line.split(" ");
            this.trickyPhones.put(ph[0], ph[1]);
            this.actualPhones.put(ph[1], ph[0]);
            this.logger.debug((Object)("  " + ph[0] + " -->  " + ph[1]));
        }
        if (aliasList != null) {
            aliasList.close();
        }
    }

    public String replaceTrickyPhones(String lab) {
        String s = lab;
        if (this.trickyPhones.containsKey(lab)) {
            s = this.trickyPhones.get(lab);
        }
        return s;
    }

    public String replaceBackTrickyPhones(String lab) {
        String s = lab;
        if (this.actualPhones.containsKey(lab)) {
            s = this.actualPhones.get(lab);
        }
        return s;
    }

    public String shortenPfeat(String fea) {
        String s = fea;
        s = s.replace("phone", "phn");
        s = s.replace("prev", "p");
        s = s.replace("next", "n");
        s = s.replace("sentence", "snt");
        s = s.replace("phrase", "phr");
        s = s.replace("word", "wrd");
        s = s.replace("from_", "");
        s = s.replace("to_", "");
        s = s.replace("in_", "");
        s = s.replace("is_", "");
        s = s.replace("break", "brk");
        s = s.replace("start", "stt");
        s = s.replace("accented", "acc");
        s = s.replace("accent", "acc");
        s = s.replace("stressed", "str");
        s = s.replace("punctuation", "punc");
        s = s.replace("frequency", "freq");
        s = s.replace("position", "pos");
        s = s.replace("halfphone_lr", "lr");
        return s;
    }

    public String replacePunc(String lab) {
        String s = lab;
        if (lab.contentEquals(".")) {
            s = "pt";
        } else if (lab.contentEquals(",")) {
            s = "cm";
        } else if (lab.contentEquals("(")) {
            s = "op";
        } else if (lab.contentEquals(")")) {
            s = "cp";
        } else if (lab.contentEquals("?")) {
            s = "in";
        } else if (lab.contentEquals("\"")) {
            s = "qt";
        }
        return s;
    }

    public String replaceBackPunc(String lab) {
        String s = lab;
        if (lab.contentEquals("pt")) {
            s = ".";
        } else if (lab.contentEquals("cm")) {
            s = ",";
        } else if (lab.contentEquals("op")) {
            s = "(";
        } else if (lab.contentEquals("cp")) {
            s = ")";
        } else if (lab.contentEquals("in")) {
            s = "?";
        } else if (lab.contentEquals("qt")) {
            s = "\"";
        }
        return s;
    }

    public String replaceToBI(String lab) {
        String s = lab;
        if (lab.contains("*")) {
            s = s.replace("*", "st");
        }
        if (lab.contains("%")) {
            s = s.replace("%", "pc");
        }
        if (lab.contains("^")) {
            s = s.replace("^", "ht");
        }
        return s;
    }

    public String replaceBackToBI(String lab) {
        String s = lab;
        if (lab.contains("st")) {
            s = s.replace("st", "*");
        }
        if (lab.contains("pc")) {
            s = s.replace("pc", "%");
        }
        if (lab.contains("ht")) {
            s = s.replace("ht", "^");
        }
        return s;
    }

    public static void main(String[] args) throws Exception {
        PhoneTranslator phTrans = new PhoneTranslator(new FileInputStream("/project/mary/marcela/HMM-voices/turkish/mary/trickyPhones.txt"));
        String oriLab = "@'";
        String alias = phTrans.replaceTrickyPhones(oriLab);
        String ori = phTrans.replaceBackTrickyPhones(alias);
        System.out.println("oriLab=" + oriLab + "  alias=" + alias + "  ori=" + ori);
        oriLab = "e~";
        alias = phTrans.replaceTrickyPhones(oriLab);
        ori = phTrans.replaceBackTrickyPhones(alias);
        System.out.println("oriLab=" + oriLab + "  alias=" + alias + "  ori=" + ori);
    }
}

