/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.datatypes.MaryXML;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.NameNodeFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class JTokeniser
extends marytts.modules.JTokeniser {
    protected static final Set<String> nonAbbrevs = new HashSet<String>(Arrays.asList("m", "km", "dm", "cm", "mm", "g", "kg", "mg", "s", "sec", "ms", "min", "\u00b0C", "\u00b0F", "Hz", "kHz", "MHz", "GHz", "Pa", "J", "kJ", "kW", "MW", "GW", "mW", "l", "dl", "cl", "ml", "Bq", "EL", "TL", "kcal", "oz", "qm", "m\u00b2", "m\u00b3", "ccm", "%"));

    public JTokeniser() {
        super(MaryDataType.RAWMARYXML, MaryDataType.TOKENS, Locale.GERMAN);
    }

    public MaryData process(MaryData d) throws Exception {
        MaryData result = super.process(d);
        this.tokenizerFixes(result);
        return result;
    }

    protected void tokenizerFixes(MaryData d) {
        Document doc = d.getDocument();
        NodeIterator ni = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, (NodeFilter)new NameNodeFilter(new String[]{"t"}), false);
        Element t = null;
        while ((t = (Element)ni.nextNode()) != null) {
            String s1;
            String s = MaryDomUtils.tokenText((Element)t);
            if (!s.endsWith(".") || !nonAbbrevs.contains(s1 = s.substring(0, s.length() - 1))) continue;
            MaryDomUtils.setTokenText((Element)t, (String)s1);
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)t, (String)"s");
            assert (sentence != null);
            if (!MaryDomUtils.isLastOfItsKindIn((Node)t, (Node)sentence)) {
                Element firstInSentence = MaryDomUtils.getFirstElementByTagName((Node)sentence, (String)"t");
                Element newSentence = MaryDomUtils.encloseNodesWithNewElement((Node)firstInSentence, (Node)t, (String)"s");
                sentence.getParentNode().insertBefore(newSentence, sentence);
                sentence = newSentence;
            }
            Element newT = MaryXML.appendChildElement((Node)sentence, (String)"t");
            MaryDomUtils.setTokenText((Element)newT, (String)".");
        }
    }
}

