/*
 * Decompiled with CFR 0.152.
 */
package javax.visrec.ml.classification;

import java.nio.file.Path;
import javax.visrec.ml.classification.BinaryClassifier;
import javax.visrec.ml.model.ModelBuilder;
import javax.visrec.ml.model.ModelCreationException;
import javax.visrec.spi.ServiceProvider;

public interface NeuralNetBinaryClassifier<T>
extends BinaryClassifier<T> {
    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T>
    implements ModelBuilder<BinaryClassifier<T>> {
        private BuildingBlock<T> block;

        private Builder() {
            this(new BuildingBlock());
        }

        private Builder(BuildingBlock<T> block) {
            this.block = block;
        }

        public <R> Builder<R> inputClass(Class<R> cls) {
            BuildingBlock newBlock = BuildingBlock.copyWithNewTargetClass((BuildingBlock)this.block, cls);
            return new Builder<T>(newBlock);
        }

        public Builder<T> inputsNum(int inputsNum) {
            ((BuildingBlock)this.block).inputsNum = inputsNum;
            return this;
        }

        public Builder<T> hiddenLayers(int ... hiddenLayers) {
            BuildingBlock.access$402(this.block, hiddenLayers);
            return this;
        }

        public Builder<T> maxError(float maxError) {
            ((BuildingBlock)this.block).maxError = maxError;
            return this;
        }

        public Builder<T> maxEpochs(int maxEpochs) {
            ((BuildingBlock)this.block).maxEpochs = maxEpochs;
            return this;
        }

        public Builder<T> learningRate(float learningRate) {
            ((BuildingBlock)this.block).learningRate = learningRate;
            return this;
        }

        public Builder<T> trainingPath(Path trainingPath) {
            ((BuildingBlock)this.block).trainingPath = trainingPath;
            return this;
        }

        public Builder<T> threshold(float threshold) {
            ((BuildingBlock)this.block).threshold = threshold;
            return this;
        }

        public BuildingBlock<T> getBuildingBlock() {
            return this.block;
        }

        @Override
        public BinaryClassifier<T> build() throws ModelCreationException {
            return ServiceProvider.current().getClassifierFactoryService().createNeuralNetBinaryClassifier(this.block);
        }
    }

    public static class BuildingBlock<T> {
        private Class<T> inputCls;
        private int inputsNum;
        private int[] hiddenLayers;
        private float maxError;
        private int maxEpochs;
        private float learningRate;
        private Path trainingPath;
        private float threshold;

        private BuildingBlock() {
        }

        public Class<T> getInputClass() {
            return this.inputCls;
        }

        public int getInputsNum() {
            return this.inputsNum;
        }

        public int[] getHiddenLayers() {
            return this.hiddenLayers;
        }

        public float getMaxError() {
            return this.maxError;
        }

        public int getMaxEpochs() {
            return this.maxEpochs;
        }

        public float getLearningRate() {
            return this.learningRate;
        }

        public Path getTrainingPath() {
            return this.trainingPath;
        }

        public float getThreshold() {
            return this.threshold;
        }

        private static <R> BuildingBlock<R> copyWithNewTargetClass(BuildingBlock<?> block, Class<R> cls) {
            BuildingBlock newBlock = new BuildingBlock();
            newBlock.inputCls = cls;
            newBlock.inputsNum = block.inputsNum;
            newBlock.hiddenLayers = block.hiddenLayers;
            newBlock.maxError = block.maxError;
            newBlock.maxEpochs = block.maxEpochs;
            newBlock.learningRate = block.learningRate;
            newBlock.trainingPath = block.trainingPath;
            newBlock.threshold = block.threshold;
            return newBlock;
        }

        static /* synthetic */ int[] access$402(BuildingBlock x0, int[] x1) {
            x0.hiddenLayers = x1;
            return x1;
        }
    }
}

