/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.stores;

import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.utils.ConversionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ResourceStoreClassLoader
extends ClassLoader {
    private final Log log = LogFactory.getLog(ResourceStoreClassLoader.class);
    private final ResourceStore[] stores;

    public ResourceStoreClassLoader(ClassLoader pParent, ResourceStore[] pStores) {
        super(pParent);
        this.stores = new ResourceStore[pStores.length];
        System.arraycopy(pStores, 0, this.stores, 0, this.stores.length);
    }

    private Class<?> fastFindClass(String name) {
        if (this.stores != null) {
            for (ResourceStore store : this.stores) {
                byte[] clazzBytes = store.read(ConversionUtils.convertClassToResourcePath(name));
                if (clazzBytes == null) continue;
                this.log.debug((Object)(this.getId() + " found class: " + name + " (" + clazzBytes.length + " bytes)"));
                return this.defineClass(name, clazzBytes, 0, clazzBytes.length);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            clazz = this.fastFindClass(name);
            if (clazz == null) {
                ClassLoader parent = this.getParent();
                if (parent == null) throw new ClassNotFoundException(name);
                clazz = parent.loadClass(name);
            } else {
                this.log.debug((Object)(this.getId() + " loaded from store: " + name));
            }
        }
        if (!resolve) return clazz;
        this.resolveClass(clazz);
        return clazz;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.fastFindClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    private String getId() {
        return "" + this + "[" + this.getClass().getClassLoader() + "]";
    }
}

