/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.readers;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jci.readers.ResourceReader;

public class MemoryResourceReader
implements ResourceReader {
    private Map<String, byte[]> resources = null;

    @Override
    public boolean isAvailable(String pResourceName) {
        if (this.resources == null) {
            return false;
        }
        return this.resources.containsKey(pResourceName);
    }

    public void add(String pResourceName, byte[] pContent) {
        if (this.resources == null) {
            this.resources = new HashMap<String, byte[]>();
        }
        this.resources.put(pResourceName, pContent);
    }

    public void remove(String pResourceName) {
        if (this.resources != null) {
            this.resources.remove(pResourceName);
        }
    }

    @Override
    public byte[] getBytes(String pResourceName) {
        return this.resources.get(pResourceName);
    }

    @Deprecated
    public String[] list() {
        if (this.resources == null) {
            return new String[0];
        }
        return this.resources.keySet().toArray(new String[this.resources.size()]);
    }
}

