/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.readers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.jci.readers.ResourceReader;

public final class FileResourceReader
implements ResourceReader {
    private final File root;

    public FileResourceReader(File pRoot) {
        this.root = pRoot;
    }

    @Override
    public boolean isAvailable(String pResourceName) {
        return new File(this.root, pResourceName).exists();
    }

    @Override
    public byte[] getBytes(String pResourceName) {
        try {
            return FileUtils.readFileToString((File)new File(this.root, pResourceName), (String)"UTF-8").getBytes();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public String[] list() {
        ArrayList<String> files = new ArrayList<String>();
        this.list(this.root, files);
        return files.toArray(new String[files.size()]);
    }

    @Deprecated
    private void list(File pFile, List<String> pFiles) {
        if (pFile.isDirectory()) {
            File[] directoryFiles = pFile.listFiles();
            for (int i = 0; i < directoryFiles.length; ++i) {
                this.list(directoryFiles[i], pFiles);
            }
        } else {
            pFiles.add(pFile.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1));
        }
    }
}

