/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.listeners;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.JavaCompiler;
import org.apache.commons.jci.compilers.JavaCompilerFactory;
import org.apache.commons.jci.listeners.ReloadingListener;
import org.apache.commons.jci.monitor.FilesystemAlterationObserver;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.readers.FileResourceReader;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.stores.TransactionalResourceStore;
import org.apache.commons.jci.utils.ConversionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompilingListener
extends ReloadingListener {
    private final Log log = LogFactory.getLog(CompilingListener.class);
    private final JavaCompiler compiler;
    private final TransactionalResourceStore transactionalStore;
    private ResourceReader reader;
    private CompilationResult lastResult;

    public CompilingListener() {
        this(new JavaCompilerFactory().createCompiler("eclipse"));
    }

    public CompilingListener(JavaCompiler pCompiler) {
        this(pCompiler, new TransactionalResourceStore(new MemoryResourceStore()));
    }

    public CompilingListener(JavaCompiler pCompiler, TransactionalResourceStore pTransactionalStore) {
        super(pTransactionalStore);
        this.compiler = pCompiler;
        this.transactionalStore = pTransactionalStore;
        this.lastResult = null;
    }

    public JavaCompiler getCompiler() {
        return this.compiler;
    }

    public String getSourceFileExtension() {
        return ".java";
    }

    public ResourceReader getReader(FilesystemAlterationObserver pObserver) {
        return new FileResourceReader(pObserver.getRootDirectory());
    }

    public String getSourceNameFromFile(FilesystemAlterationObserver pObserver, File pFile) {
        return ConversionUtils.stripExtension(ConversionUtils.getResourceNameFromFileName(ConversionUtils.relative(pObserver.getRootDirectory(), pFile))) + this.getSourceFileExtension();
    }

    @Override
    public ResourceStore getStore() {
        return this.transactionalStore;
    }

    public synchronized CompilationResult getCompilationResult() {
        return this.lastResult;
    }

    public void onStart(FilesystemAlterationObserver pObserver) {
        super.onStart(pObserver);
        this.reader = this.getReader(pObserver);
        this.transactionalStore.onStart();
    }

    public String[] getResourcesToCompile(FilesystemAlterationObserver pObserver) {
        Collection created = this.getCreatedFiles();
        Collection changed = this.getChangedFiles();
        ArrayList<String> resourceNames = new ArrayList<String>();
        for (File createdFile : created) {
            if (!createdFile.getName().endsWith(this.getSourceFileExtension())) continue;
            resourceNames.add(this.getSourceNameFromFile(pObserver, createdFile));
        }
        for (File changedFile : changed) {
            if (!changedFile.getName().endsWith(this.getSourceFileExtension())) continue;
            resourceNames.add(this.getSourceNameFromFile(pObserver, changedFile));
        }
        String[] result = new String[resourceNames.size()];
        resourceNames.toArray(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReloadRequired(FilesystemAlterationObserver pObserver) {
        String[] resourcesToCompile;
        Object resourceName;
        boolean reload = false;
        Collection created = this.getCreatedFiles();
        Collection changed = this.getChangedFiles();
        Collection deleted = this.getDeletedFiles();
        this.log.debug((Object)("created:" + created.size() + " changed:" + changed.size() + " deleted:" + deleted.size() + " resources"));
        if (deleted.size() > 0) {
            for (File deletedFile : deleted) {
                resourceName = ConversionUtils.getResourceNameFromFileName(ConversionUtils.relative(pObserver.getRootDirectory(), deletedFile));
                if (resourceName.endsWith(this.getSourceFileExtension())) {
                    this.transactionalStore.remove(ConversionUtils.stripExtension(resourceName) + ".class");
                    continue;
                }
                this.transactionalStore.remove((String)resourceName);
            }
            reload = true;
        }
        if ((resourcesToCompile = this.getResourcesToCompile(pObserver)).length > 0) {
            this.log.debug((Object)(resourcesToCompile.length + " classes to compile"));
            CompilationResult result = this.compiler.compile(resourcesToCompile, this.reader, this.transactionalStore);
            resourceName = this;
            synchronized (resourceName) {
                this.lastResult = result;
            }
            CompilationProblem[] errors = result.getErrors();
            CompilationProblem[] warnings = result.getWarnings();
            this.log.debug((Object)(errors.length + " errors, " + warnings.length + " warnings"));
            if (errors.length > 0) {
                for (int j = 0; j < resourcesToCompile.length; ++j) {
                    this.transactionalStore.remove(resourcesToCompile[j]);
                }
            }
            reload = true;
        }
        return reload;
    }
}

