/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning.kmeans;

import org.neuroph.nnet.learning.kmeans.Cluster;

public class KVector {
    private double[] values;
    private Cluster cluster;
    private double distance;

    public KVector(int size) {
        this.values = new double[size];
    }

    public KVector(double[] values) {
        this.values = values;
    }

    public void setValueAt(int idx, double value) {
        this.values[idx] = value;
    }

    public double getValueAt(int idx) {
        return this.values[idx];
    }

    public double[] getValues() {
        return this.values;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        if (this.cluster != null) {
            this.cluster.removePoint(this);
        }
        this.cluster = cluster;
    }

    public double getIntensity() {
        double intensity = 0.0;
        for (double value : this.values) {
            intensity += value * value;
        }
        intensity = Math.sqrt(intensity);
        return intensity;
    }

    public double distanceFrom(KVector otherVector) {
        double[] otherValues = otherVector.getValues();
        double distanceFrom = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            distanceFrom += Math.pow(otherValues[i] - this.values[i], 2.0);
        }
        distanceFrom = Math.sqrt(distanceFrom);
        return distanceFrom;
    }

    public double setDistanceFrom(KVector someVector) {
        double[] otherValues = someVector.getValues();
        this.distance = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            this.distance += Math.pow(otherValues[i] - this.values[i], 2.0);
        }
        this.distance = Math.sqrt(this.distance);
        return this.distance;
    }

    public int size() {
        return this.values.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("KMeansVector{");
        for (int i = 0; i < this.values.length; ++i) {
            sb.append("[" + i + "]=" + this.values[i] + ",");
        }
        sb.append('}');
        return sb.toString();
    }

    public double getDistance() {
        return this.distance;
    }
}

