/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.nnet.learning.UnsupervisedHebbianLearning;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.LayerFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuralNetworkType;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class UnsupervisedHebbianNetwork
extends NeuralNetwork {
    private static final long serialVersionUID = 2L;

    public UnsupervisedHebbianNetwork(int inputNeuronsNum, int outputNeuronsNum) {
        this.createNetwork(inputNeuronsNum, outputNeuronsNum, TransferFunctionType.LINEAR);
    }

    public UnsupervisedHebbianNetwork(int inputNeuronsNum, int outputNeuronsNum, TransferFunctionType transferFunctionType) {
        this.createNetwork(inputNeuronsNum, outputNeuronsNum, transferFunctionType);
    }

    private void createNetwork(int inputNeuronsNum, int outputNeuronsNum, TransferFunctionType transferFunctionType) {
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("transferFunction", (Object)transferFunctionType);
        neuronProperties.setProperty("transferFunction.slope", new Double(1.0));
        this.setNetworkType(NeuralNetworkType.UNSUPERVISED_HEBBIAN_NET);
        Layer inputLayer = LayerFactory.createLayer(inputNeuronsNum, neuronProperties);
        this.addLayer(inputLayer);
        Layer outputLayer = LayerFactory.createLayer(outputNeuronsNum, neuronProperties);
        this.addLayer(outputLayer);
        ConnectionFactory.fullConnect(inputLayer, outputLayer);
        NeuralNetworkFactory.setDefaultIO(this);
        this.setLearningRule(new UnsupervisedHebbianLearning());
    }
}

