/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;
import org.neuroph.core.input.Difference;
import org.neuroph.core.transfer.Linear;
import org.neuroph.nnet.learning.KohonenLearning;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.LayerFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuralNetworkType;
import org.neuroph.util.NeuronProperties;

public class Kohonen
extends NeuralNetwork {
    private static final long serialVersionUID = 1L;

    public Kohonen(int inputNeuronsCount, int outputNeuronsCount) {
        this.createNetwork(inputNeuronsCount, outputNeuronsCount);
    }

    private void createNetwork(int inputNeuronsCount, int outputNeuronsCount) {
        NeuronProperties inputNeuronProperties = new NeuronProperties();
        NeuronProperties outputNeuronProperties = new NeuronProperties(Neuron.class, Difference.class, Linear.class);
        this.setNetworkType(NeuralNetworkType.KOHONEN);
        Layer inLayer = LayerFactory.createLayer(inputNeuronsCount, inputNeuronProperties);
        this.addLayer(inLayer);
        Layer mapLayer = LayerFactory.createLayer(outputNeuronsCount, outputNeuronProperties);
        this.addLayer(mapLayer);
        ConnectionFactory.fullConnect(inLayer, mapLayer);
        NeuralNetworkFactory.setDefaultIO(this);
        this.setLearningRule(new KohonenLearning());
    }
}

