/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.transfer;

import java.io.Serializable;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.util.NeurophProperties;

public class Tanh
extends TransferFunction
implements Serializable {
    private static final long serialVersionUID = 2L;
    private double slope = 1.0;
    private double amplitude = 1.0;
    private double derivativeOutput;

    public Tanh() {
    }

    public Tanh(double slope) {
        this.slope = slope;
    }

    public Tanh(NeurophProperties properties) {
        try {
            this.slope = (Double)properties.getProperty("transferFunction.slope");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid transfer function properties! Using default values.");
        }
    }

    @Override
    public final double getOutput(double input) {
        if (Math.abs(input) * this.slope > 100.0) {
            return Math.signum(input) * 1.0;
        }
        double E_x = Math.exp(2.0 * this.slope * input);
        this.output = this.amplitude * ((E_x - 1.0) / (E_x + 1.0));
        return this.output;
    }

    @Override
    public final double getDerivative(double input) {
        if (Math.abs(input) * this.slope > 100.0) {
            return 0.0;
        }
        double E_x = Math.exp(2.0 * this.slope * input);
        double tanhsx = (E_x - 1.0) / (E_x + 1.0);
        this.derivativeOutput = this.amplitude * this.slope * (1.0 - tanhsx * tanhsx);
        return this.derivativeOutput;
    }

    public double getSlope() {
        return this.slope;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(double amplitude) {
        this.amplitude = amplitude;
    }
}

