/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.neuroph.util.VectorParser;

public class DataSetRow
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected double[] input;
    private double[] desiredOutput;

    public DataSetRow(String input, String desiredOutput) {
        this.input = VectorParser.parseDoubleArray(input);
        this.desiredOutput = VectorParser.parseDoubleArray(desiredOutput);
    }

    public DataSetRow(double[] input, double[] desiredOutput) {
        this.input = input;
        this.desiredOutput = desiredOutput;
    }

    public DataSetRow(double ... input) {
        this.input = input;
    }

    public DataSetRow(ArrayList<Double> input, ArrayList<Double> desiredOutput) {
        this.input = VectorParser.toDoubleArray(input);
        this.desiredOutput = VectorParser.toDoubleArray(desiredOutput);
    }

    public DataSetRow(ArrayList<Double> input) {
        this.input = VectorParser.toDoubleArray(input);
    }

    public double[] getInput() {
        return this.input;
    }

    public void setInput(double[] input) {
        this.input = input;
    }

    public double[] getDesiredOutput() {
        return this.desiredOutput;
    }

    public void setDesiredOutput(double[] desiredOutput) {
        this.desiredOutput = desiredOutput;
    }

    public boolean isSupervised() {
        return this.desiredOutput != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Input: ");
        for (double in : this.input) {
            sb.append(in).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length() - 1);
        if (this.isSupervised()) {
            sb.append(" Desired output: ");
            for (double out : this.desiredOutput) {
                sb.append(out).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length() - 1);
        }
        return sb.toString();
    }

    public double[] toArray() {
        double[] row = new double[this.input.length + this.desiredOutput.length];
        System.arraycopy(this.input, 0, row, 0, this.input.length);
        System.arraycopy(this.desiredOutput, 0, row, this.input.length, this.desiredOutput.length);
        return row;
    }

    public String toCSV() {
        StringBuilder sb = new StringBuilder();
        for (double in : this.input) {
            sb.append(in).append(", ");
        }
        if (this.isSupervised()) {
            for (double out : this.desiredOutput) {
                sb.append(out).append(", ");
            }
        }
        sb.delete(sb.length() - 2, sb.length() - 1);
        return sb.toString();
    }

    public int hashCode() {
        int hash = 5;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataSetRow other = (DataSetRow)obj;
        if (!Arrays.equals(this.input, other.input)) {
            return false;
        }
        return Arrays.equals(this.desiredOutput, other.desiredOutput);
    }
}

