/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.swt.graphic;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.I_File;
import de.mn77.lib.graphic.I_ImageX;
import de.mn77.lib.graphic.MImageX;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.io.File;
import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.jaymo_lang.lib.graphic.JMo_Image;

public class SWT_Image {
    private Image image = null;

    public static SWT_Image newDirect(Object image) {
        Err.ifNull((Object)image);
        return image instanceof SWT_Image ? (SWT_Image)image : new SWT_Image(image);
    }

    public SWT_Image(I_File img) throws Err_FileSys {
        Err.fsIfMissing((Object)img);
        this.image = this.iLoad(img);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SWT_Image(Object img) {
        Err.ifNull((Object)img);
        if (img instanceof String[] && ((String[])img).length > 0) {
            img = ((String[])img)[0];
        }
        if (img instanceof Image) {
            this.image = (Image)img;
            return;
        } else if (img instanceof ImageData) {
            this.image = new Image((Device)Display.getDefault(), (ImageData)img);
            return;
        } else if (img instanceof InputStream) {
            this.image = this.iLoad(img);
            return;
        } else if (img instanceof SWT_Image) {
            this.image = new Image(null, ((SWT_Image)img).getImage(), 0);
            return;
        } else if (img instanceof JMo_Image) {
            this.image = new Image((Device)Display.getDefault(), this.iConvertToSWT((BufferedImage)((JMo_Image)img).internalGet().getImage()));
            return;
        } else if (img instanceof Integer) {
            this.image = Display.getDefault().getSystemImage(((Integer)img).intValue());
            return;
        } else {
            if (!(img instanceof String)) throw Err.invalid((Object[])new Object[]{"Invalid class", img.getClass().getCanonicalName()});
            if (!new File("" + img).exists()) throw Err.invalid((Object[])new Object[]{"File is missing", img});
            this.image = this.iLoad(img);
        }
    }

    public SWT_Image copy() {
        return new SWT_Image(new Image(null, this.image, 0));
    }

    public void dispose() {
        this.image.dispose();
    }

    public int getHeight() {
        return this.image.getBounds().height;
    }

    public Image getImage() {
        return this.image;
    }

    public int getWidth() {
        return this.image.getBounds().width;
    }

    public boolean isDisposed() {
        return this.image.isDisposed();
    }

    public JMo_Image toJayMoImage() {
        ImageData data = this.image.getImageData();
        MImageX img = new MImageX((Object)data);
        return new JMo_Image((I_ImageX)img);
    }

    private ImageData iConvertToSWT(BufferedImage bufferedImage) {
        DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
        PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
        ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
        int rgb = 0;
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                rgb = bufferedImage.getRGB(x, y);
                data.setPixel(x, y, rgb);
                ++x;
            }
            ++y;
        }
        return data;
    }

    private Image iLoad(Object o) {
        ImageLoader loader = new ImageLoader();
        ImageData[] data = o instanceof InputStream ? loader.load((InputStream)o) : loader.load("" + o);
        return new Image(null, data[0]);
    }
}

