/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.swt.dialog;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.jaymo_lang.ext.swt.core.I_SWT_Window;
import org.jaymo_lang.ext.swt.dialog.A_SWT_Dialog2;
import org.jaymo_lang.runtime.CallRuntime;

public class SWT_Dialog
extends A_SWT_Dialog2<MessageBox> {
    private int icon = 0;
    private int button = 0;
    private Listener buttonAbort = null;
    private Listener buttonYes = null;
    private Listener buttonNo = null;
    private Listener buttonOk = null;
    private final String text;
    private String titel = "";

    public SWT_Dialog(String text) {
        this.text = text;
    }

    public void open(CallRuntime cr) {
        this.open(cr, true);
    }

    public void open(CallRuntime cr, boolean wait) {
        Shell[] shells;
        Display display = Display.getDefault();
        Shell shell = display.getActiveShell();
        if (shell == null && (shells = Display.getDefault().getShells()).length > 0) {
            shell = shells[0];
        }
        if (shell == null) {
            MOut.error((String)this.text);
            MOut.error((String)"Keine Shell f\u00fcr Dialogfenster vorhanden!");
            return;
        }
        I_SWT_Window fenster = (I_SWT_Window)shell.getData();
        Err.ifNull((Object)fenster);
        Shell shellw = shell;
        if (wait) {
            fenster.startSync(cr, () -> {
                try {
                    this.iFensterOeffnen(cr, shellw);
                }
                catch (Throwable t) {
                    Err.show((Throwable)t);
                }
            });
        } else {
            fenster.startAsync(cr, () -> {
                try {
                    this.iFensterOeffnen(cr, shellw);
                }
                catch (Throwable t) {
                    Err.show((Throwable)t);
                }
            });
        }
    }

    public SWT_Dialog setListenerAbort(Listener s) {
        this.buttonAbort = this.iSetButton(256, s);
        return this;
    }

    public SWT_Dialog setListenerNo(Listener s) {
        this.buttonNo = this.iSetButton(128, s);
        return this;
    }

    public SWT_Dialog setListenerOk(Listener s) {
        this.buttonOk = this.iSetButton(32, s);
        return this;
    }

    public SWT_Dialog setListenerYes(Listener s) {
        this.buttonYes = this.iSetButton(64, s);
        return this;
    }

    public SWT_Dialog setTypeError() {
        this.iIcon(1);
        return this;
    }

    public SWT_Dialog setTypeInformation() {
        this.iIcon(2);
        return this;
    }

    public SWT_Dialog setTypeQuestion() {
        this.iIcon(4);
        return this;
    }

    public SWT_Dialog setTypeWarning() {
        this.iIcon(8);
        return this;
    }

    @Override
    protected MessageBox swtCreate(Shell vater, int style) {
        return new MessageBox(vater, style);
    }

    @Override
    protected void swtInit() {
        ((MessageBox)this.swt()).setMessage(this.text);
        ((MessageBox)this.swt()).setText(this.titel);
    }

    @Override
    protected int swtStyle() {
        if (this.icon == 0) {
            this.iIcon(2);
        }
        return this.icon | this.button;
    }

    private void iFensterOeffnen(CallRuntime cr, Shell shellw) {
        this.createSWT(cr, (Widget)shellw);
        int erg = ((MessageBox)this.swt()).open();
        if (erg == 64 && this.buttonYes != null) {
            this.buttonYes.handleEvent(null);
        }
        if (erg == 128 && this.buttonNo != null) {
            this.buttonNo.handleEvent(null);
        }
        if (erg == 256 && this.buttonAbort != null) {
            this.buttonAbort.handleEvent(null);
        }
        if (erg == 32 && this.buttonOk != null) {
            this.buttonOk.handleEvent(null);
        }
    }

    private void iIcon(int icon) {
        if (this.icon != 0) {
            Err.invalid((Object[])new Object[]{"Typ wurde bereits gesetzt"});
        }
        this.icon = icon;
        if (icon == 1) {
            this.titel = "Fehler";
        }
        if (icon == 2) {
            this.titel = "Hinweis";
        }
        if (icon == 4) {
            this.titel = "Frage";
        }
        if (icon == 8) {
            this.titel = "Warning";
        }
    }

    private Listener iSetButton(int typ, Listener neu) {
        if ((this.button & typ) > 0) {
            Err.invalid((Object[])new Object[]{"Knopf wurde bereits gesetzt"});
        }
        this.button |= typ;
        return neu;
    }
}

