/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.pdf.fill;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfWriter;
import de.mn77.base.data.struct.I_Iterable;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.ext.pdf.fill.PDF_FillInfo;
import de.mn77.ext.pdf.fill.PDF_Filler;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Map;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_PdfFiller
extends A_ObjectSimple {
    private final ArgCallBuffer par_source;
    private PDF_Filler pdf;

    public JMo_PdfFiller(Call source) {
        this.par_source = new ArgCallBuffer(0, source);
    }

    public void init(CallRuntime cr) {
        Str o = (Str)this.par_source.init(cr, (I_Object)this, Str.class);
        String s = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)o);
        this.pdf = new PDF_Filler(s);
    }

    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "fields": 
            case "available": {
                return this.mFields(cr);
            }
            case "fill": {
                this.fill(cr);
                return this;
            }
        }
        return null;
    }

    private void fill(CallRuntime cr) {
        I_Object[] args = cr.args((I_Object)this, new Class[]{Str.class, JMo_List.class, JMo_Map.class});
        Str target = (Str)args[0];
        JMo_List pages = (JMo_List)args[1];
        JMo_Map info = (JMo_Map)args[2];
        SimpleList pdfPages = new SimpleList();
        for (I_Object page : pages.getInternalCollection()) {
            Iterator pageMap = ((JMo_Map)page).copyToTable();
            HashMap<String, String> daten = new HashMap<String, String>();
            Object object = pageMap.iterator();
            while (object.hasNext()) {
                I_Object[] pm = (I_Object[])object.next();
                daten.put(Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)pm[0]), Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)pm[1]));
            }
            pdfPages.add(daten);
        }
        PDF_FillInfo pdfinfo = new PDF_FillInfo();
        for (I_Object[] iof : info.copyToTable()) {
            String s1 = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)iof[0]).toLowerCase();
            String s2 = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)iof[1]);
            block10 : switch (s1) {
                case "author": {
                    pdfinfo.AUTHOR.set((Object)s2);
                    break;
                }
                case "creator": {
                    pdfinfo.ERSTELLER.set((Object)s2);
                    break;
                }
                case "title": {
                    pdfinfo.TITEL.set((Object)s2);
                    break;
                }
                case "subject": {
                    pdfinfo.BETREFF.set((Object)s2);
                    break;
                }
                case "compress": {
                    pdfinfo.COMPRESS.set((Object)s2.equals("true"));
                    break;
                }
                case "version": {
                    switch (s2) {
                        case "1.2": {
                            pdfinfo.PDF_VERSION.set((Object)PdfWriter.PDF_VERSION_1_2);
                            break block10;
                        }
                        case "1.3": {
                            pdfinfo.PDF_VERSION.set((Object)PdfWriter.PDF_VERSION_1_3);
                            break block10;
                        }
                        case "1.4": {
                            pdfinfo.PDF_VERSION.set((Object)PdfWriter.PDF_VERSION_1_4);
                            break block10;
                        }
                        case "1.5": {
                            pdfinfo.PDF_VERSION.set((Object)PdfWriter.PDF_VERSION_1_5);
                            break block10;
                        }
                        case "1.6": {
                            pdfinfo.PDF_VERSION.set((Object)PdfWriter.PDF_VERSION_1_6);
                            break block10;
                        }
                        case "1.7": {
                            pdfinfo.PDF_VERSION.set((Object)PdfWriter.PDF_VERSION_1_7);
                            break block10;
                        }
                    }
                    throw new RuntimeError(cr, "Invalid value for PDF-version", "Got: " + s2);
                }
                case "conformance": {
                    switch (s2) {
                        case "PDFA1A": {
                            pdfinfo.PDF_FORMAT.set((Object)3);
                            break block10;
                        }
                        case "PDFA1B": {
                            pdfinfo.PDF_FORMAT.set((Object)4);
                            break block10;
                        }
                    }
                    throw new RuntimeError(cr, "Invalid conformance value", "Got: " + s2);
                }
                default: {
                    throw new RuntimeError(cr, "Unknown Document-Info-Fieldname", "Got field: " + s1);
                }
            }
        }
        String target2 = target.getValue();
        try {
            this.pdf.fill(new FileOutputStream(target2), String.valueOf(target2) + ".temp", (I_Iterable<Map<String, String>>)pdfPages, pdfinfo);
        }
        catch (DocumentException | Err_FileSys | FileNotFoundException e) {
            Err.exit((Throwable)e);
        }
    }

    private JMo_List mFields(CallRuntime cr) {
        cr.argsNone();
        try {
            I_Iterable<String> fields = this.pdf.getFieldNames();
            SimpleList al = new SimpleList(fields.size());
            for (String field : fields) {
                al.add((Object)new Str(field));
            }
            return new JMo_List(al);
        }
        catch (IOException e) {
            throw new ExternalError(cr, "File-Error", e.getMessage());
        }
    }
}

