/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.pdf.create.page;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import de.mn77.base.data.constant.position.Lib_Position;
import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.lib.graphic.I_Image;
import java.util.ArrayList;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.ext.pdf.create.IText_Calculator;
import org.jaymo_lang.ext.pdf.create.I_IText_BaseItem;
import org.jaymo_lang.ext.pdf.create.constant.JMo_IText_PageSize;
import org.jaymo_lang.ext.pdf.create.page.I_IText_PageData;
import org.jaymo_lang.ext.pdf.create.page.item.I_IText_PageItem;
import org.jaymo_lang.ext.pdf.create.page.item.JMo_IText_ItemCircle;
import org.jaymo_lang.ext.pdf.create.page.item.JMo_IText_ItemImage;
import org.jaymo_lang.ext.pdf.create.page.item.JMo_IText_ItemLine;
import org.jaymo_lang.ext.pdf.create.page.item.JMo_IText_ItemRectangle;
import org.jaymo_lang.ext.pdf.create.page.item.JMo_IText_ItemText;
import org.jaymo_lang.lib.graphic.JMo_Image;
import org.jaymo_lang.lib.graphic.Lib_Color;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Dec;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.magic.con.MagicPosition;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;

public class JMo_IText_Page
extends A_ObjectSimple
implements I_IText_BaseItem,
I_IText_PageData {
    private int[] defaultColorLine = null;
    private int[] defaultColorFont = null;
    private int[] defaultColorFill = null;
    private String defaultFont;
    private POSITION_H defaultFontAlign;
    private Integer defaultFontSize = null;
    private Float defaultLineThickness = null;
    private Rectangle format;
    private boolean isLandscape = false;
    private final ArrayList<I_IText_PageItem> items = new ArrayList();
    private final IText_Calculator calc;

    public JMo_IText_Page(IText_Calculator calc) {
        this.format = JMo_IText_PageSize.DEFAULT;
        this.calc = calc;
    }

    public void draw(CallRuntime cr, PdfContentByte cb) {
        Rectangle rect = this.format;
        if (this.isLandscape) {
            rect = rect.rotate();
        }
        for (I_IText_PageItem e : this.items) {
            e.draw(cr, this, cb, this.calc);
        }
    }

    @Override
    public Rectangle getFormat() {
        return this.format;
    }

    @Override
    public float getHeight() {
        Rectangle format = this.format;
        if (this.isLandscape) {
            format = format.rotate();
        }
        return format.getHeight();
    }

    @Override
    public float getWidth() {
        Rectangle rect = this.format;
        if (this.isLandscape) {
            rect = rect.rotate();
        }
        return rect.getWidth();
    }

    @Override
    public boolean isLandscape() {
        return this.isLandscape;
    }

    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "newRectangle": {
                return this.mNewRectangle(cr);
            }
            case "newLine": {
                return this.mNewLine(cr);
            }
            case "newText": {
                return this.mNewText(cr);
            }
            case "newCircle": {
                return this.mNewCircle(cr);
            }
            case "newImage": {
                return this.mNewImage(cr);
            }
            case "width": {
                return this.mWidth(cr);
            }
            case "height": {
                return this.mHeight(cr);
            }
            case "setFormat": {
                return this.mSetFormat(cr);
            }
            case "setOrientation": {
                return this.mSetOrientation(cr);
            }
            case "setDefaultFont": {
                return this.mSetDefaultFont(cr);
            }
            case "setDefaultFontSize": 
            case "setDefaultFontsize": {
                return this.mSetDefaultFontSize(cr);
            }
            case "setDefaultThickness": {
                return this.mSetDefaultThickness(cr);
            }
            case "setDefaultColorFont": 
            case "setDefaultFontColor": {
                return this.mSetDefaultColorFont(cr);
            }
            case "setDefaultFontAlign": {
                return this.mSetDefaultFontAlign(cr);
            }
            case "setDefaultColorLine": 
            case "setDefaultLineColor": {
                return this.mSetDefaultColorLine(cr);
            }
            case "setDefaultColorFill": 
            case "setDefaultFillColor": {
                return this.mSetDefaultColorFill(cr);
            }
        }
        return null;
    }

    private JMo_Dec mHeight(CallRuntime cr) {
        cr.argsNone();
        float f = this.getHeight();
        f = this.calc.width(f);
        return JMo_Dec.valueOf((CallRuntime)cr, (double)f);
    }

    private JMo_IText_ItemCircle mNewCircle(CallRuntime cr) {
        I_Object[] args = cr.args((I_Object)this, new Class[]{A_Number.class, A_Number.class, A_Number.class});
        float x = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[0]);
        float y = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[1]);
        float r = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[2]);
        JMo_IText_ItemCircle result = new JMo_IText_ItemCircle(x, y, r, this.defaultLineThickness, this.defaultColorLine, this.defaultColorFill);
        this.items.add(result);
        return result;
    }

    private JMo_IText_ItemImage mNewImage(CallRuntime cr) {
        I_Object[] args = cr.argsFlex((I_Object)this, 3, 5);
        Lib_Error.ifIs((CallRuntime)cr, (int)4, (int)args.length, (String)"amount of arguments");
        boolean has5Args = args.length == 5;
        JMo_Image image = (JMo_Image)cr.argType(args[0], JMo_Image.class);
        float x = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)cr.argType(args[1], A_Number.class));
        float y = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)cr.argType(args[2], A_Number.class));
        int dx = has5Args ? Lib_Convert.getIntValue((CallRuntime)cr, (I_Object)cr.argType(args[3], Int.class)) : image.internalGet().getWidth();
        int dy = has5Args ? Lib_Convert.getIntValue((CallRuntime)cr, (I_Object)cr.argType(args[4], Int.class)) : image.internalGet().getHeight();
        JMo_IText_ItemImage result = new JMo_IText_ItemImage((I_Image)image.internalGet(), x, y, dx, dy);
        this.items.add(result);
        return result;
    }

    private JMo_IText_ItemLine mNewLine(CallRuntime cr) {
        I_Object[] args = cr.args((I_Object)this, new Class[]{A_Number.class, A_Number.class, A_Number.class, A_Number.class});
        float x1 = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[0]);
        float y1 = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[1]);
        float x2 = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[2]);
        float y2 = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[3]);
        JMo_IText_ItemLine result = new JMo_IText_ItemLine(x1, y1, x2, y2, this.defaultLineThickness, this.defaultColorLine);
        this.items.add(result);
        return result;
    }

    private JMo_IText_ItemRectangle mNewRectangle(CallRuntime cr) {
        I_Object[] args = cr.args((I_Object)this, new Class[]{A_Number.class, A_Number.class, A_Number.class, A_Number.class});
        float x = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[0]);
        float y = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[1]);
        float dx = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[2]);
        float dy = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[3]);
        JMo_IText_ItemRectangle result = new JMo_IText_ItemRectangle(x, y, dx, dy, this.defaultLineThickness, this.defaultColorLine, this.defaultColorFill);
        this.items.add(result);
        return result;
    }

    private JMo_IText_ItemText mNewText(CallRuntime cr) {
        I_Object[] args = cr.args((I_Object)this, new Class[]{A_Number.class, A_Number.class, Str.class});
        float x = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[0]);
        float y = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)args[1]);
        String text = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)args[2]);
        JMo_IText_ItemText result = new JMo_IText_ItemText(x, y, text, this.defaultFont, this.defaultFontSize, this.defaultColorFont, this.defaultFontAlign);
        this.items.add(result);
        return result;
    }

    private JMo_IText_Page mSetDefaultColorFill(CallRuntime cr) {
        I_Object[] args = cr.argsFlex((I_Object)this, 1, 3);
        this.defaultColorFill = Lib_Color.argsToRGB((CallRuntime)cr, (I_Object[])args);
        return this;
    }

    private JMo_IText_Page mSetDefaultColorFont(CallRuntime cr) {
        I_Object[] args = cr.argsFlex((I_Object)this, 1, 3);
        this.defaultColorFont = Lib_Color.argsToRGB((CallRuntime)cr, (I_Object[])args);
        return this;
    }

    private JMo_IText_Page mSetDefaultColorLine(CallRuntime cr) {
        I_Object[] args = cr.argsFlex((I_Object)this, 1, 3);
        this.defaultColorLine = Lib_Color.argsToRGB((CallRuntime)cr, (I_Object[])args);
        return this;
    }

    private JMo_IText_Page mSetDefaultFont(CallRuntime cr) {
        String fontname;
        I_Object arg = cr.args((I_Object)this, new Class[]{Str.class})[0];
        this.defaultFont = fontname = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)arg);
        return this;
    }

    private JMo_IText_Page mSetDefaultFontAlign(CallRuntime cr) {
        I_Object arg = cr.args((I_Object)this, new Class[]{MagicPosition.class})[0];
        POSITION pos = ((MagicPosition)arg).get();
        if (!Lib_Position.isHorizontal((POSITION)pos)) {
            throw new RuntimeError(cr, "Invalid alignment", "Text alignment must be left, center or right!");
        }
        this.defaultFontAlign = (POSITION_H)pos;
        return this;
    }

    private JMo_IText_Page mSetDefaultFontSize(CallRuntime cr) {
        I_Object arg = cr.args((I_Object)this, new Class[]{Int.class})[0];
        int size = Lib_Convert.getIntValue((CallRuntime)cr, (I_Object)arg);
        Lib_Error.ifNotBetween((CallRuntime)cr, (int)4, (int)100, (int)size, (String)"fontsize");
        this.defaultFontSize = size;
        return this;
    }

    private JMo_IText_Page mSetDefaultThickness(CallRuntime cr) {
        I_Object arg = cr.args((I_Object)this, new Class[]{A_Number.class})[0];
        float f = Lib_Convert.getFloatValue((CallRuntime)cr, (I_Object)arg);
        Lib_Error.ifNotBetween((CallRuntime)cr, (double)0.1, (double)20.0, (double)f, (String)"thickness");
        this.defaultLineThickness = Float.valueOf(f);
        return this;
    }

    private JMo_IText_Page mSetFormat(CallRuntime cr) {
        JMo_IText_PageSize format = (JMo_IText_PageSize)cr.args((I_Object)this, new Class[]{JMo_IText_PageSize.class})[0];
        this.format = format.getRectangle();
        return this;
    }

    private JMo_IText_Page mSetOrientation(CallRuntime cr) {
        boolean value;
        I_Object arg = cr.args((I_Object)this, new Class[]{Bool.class})[0];
        this.isLandscape = value = Lib_Convert.getBoolValue((CallRuntime)cr, (I_Object)arg);
        return this;
    }

    private JMo_Dec mWidth(CallRuntime cr) {
        cr.argsNone();
        float f = this.getWidth();
        f = this.calc.width(f);
        return JMo_Dec.valueOf((CallRuntime)cr, (double)f);
    }
}

