/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.pdf.create;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.error.Err;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.ext.pdf.create.IText_Calculator;
import org.jaymo_lang.ext.pdf.create.I_IText_BaseItem;
import org.jaymo_lang.ext.pdf.create.page.JMo_IText_Page;
import org.jaymo_lang.ext.pdf.create.text.I_IText_TextItem;
import org.jaymo_lang.ext.pdf.create.text.JMo_IText_TextChunk;
import org.jaymo_lang.ext.pdf.create.text.JMo_IText_TextParagraph;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.immute.JMo_Enum;
import org.jaymo_lang.object.magic.con.MagicPosition;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_IText_Document
extends A_ObjectSimple {
    private final ArrayList<I_IText_BaseItem> items = new ArrayList();
    private final IText_Calculator calc = new IText_Calculator();

    public A_Immutable getConstant(CallRuntime cr, String name) {
        switch (name) {
            case "ZOLL": {
                return new JMo_Enum(this.getTypeName(), name);
            }
            case "ORIGINAL": {
                return new JMo_Enum(this.getTypeName(), name);
            }
            case "CM": {
                return new JMo_Enum(this.getTypeName(), name);
            }
            case "MM": {
                return new JMo_Enum(this.getTypeName(), name);
            }
        }
        return null;
    }

    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "newPage": {
                return this.mNewPage(cr);
            }
            case "newParagraph": {
                return this.mNewParagraph(cr);
            }
            case "newTextChunk": 
            case "newText": {
                return this.mNewTextChunk(cr);
            }
            case "write": {
                this.mWrite(cr);
                return this;
            }
            case "setAnchor": {
                this.mSetAnchor(cr);
                return this;
            }
            case "setMetrics": {
                this.mSetMetrics(cr);
                return this;
            }
        }
        return null;
    }

    private void iWrite(CallRuntime cr, OutputStream stream) {
        Document document = null;
        PdfWriter writer = null;
        for (I_IText_BaseItem item : this.items) {
            if (item instanceof JMo_IText_Page) {
                JMo_IText_Page page = (JMo_IText_Page)item;
                Rectangle rect = page.getFormat();
                if (page.isLandscape()) {
                    rect = rect.rotate();
                }
                try {
                    if (document == null) {
                        document = new Document(page.getFormat());
                        writer = PdfWriter.getInstance((Document)document, (OutputStream)stream);
                        writer.setPdfVersion('2');
                        document.open();
                    } else {
                        document.setPageSize(rect);
                        document.newPage();
                        writer.setPageEmpty(false);
                    }
                    document.add((Element)new Chunk(""));
                    page.draw(cr, writer.getDirectContent());
                    continue;
                }
                catch (DocumentException e) {
                    throw Err.direct((String)"PDF-Error", (Object[])new Object[]{e});
                }
            }
            ((I_IText_TextItem)item).draw(document);
        }
        document.close();
    }

    private JMo_IText_Page mNewPage(CallRuntime cr) {
        cr.argsNone();
        JMo_IText_Page result = new JMo_IText_Page(this.calc);
        this.items.add(result);
        return result;
    }

    private JMo_IText_TextParagraph mNewParagraph(CallRuntime cr) {
        I_Object arg0 = cr.args((I_Object)this, new Class[]{Str.class})[0];
        String text = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)arg0);
        JMo_IText_TextParagraph result = new JMo_IText_TextParagraph(text);
        this.items.add(result);
        return result;
    }

    private JMo_IText_TextChunk mNewTextChunk(CallRuntime cr) {
        I_Object arg0 = cr.args((I_Object)this, new Class[]{Str.class})[0];
        String text = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)arg0);
        JMo_IText_TextChunk result = new JMo_IText_TextChunk(text);
        this.items.add(result);
        return result;
    }

    private void mSetAnchor(CallRuntime cr) {
        MagicPosition arg = (MagicPosition)cr.args((I_Object)this, new Class[]{MagicPosition.class})[0];
        POSITION p = arg.get();
        if (p != POSITION.TOP_LEFT && p != POSITION.BOTTOM_LEFT) {
            throw new RuntimeError(cr, "Invalid anchor", "Anchor must be Top-Left or Bottom-Left, but got: " + p.toString());
        }
        this.calc.setAnchor(p == POSITION.TOP_LEFT);
    }

    private void mSetMetrics(CallRuntime cr) {
        JMo_Enum arg = cr.argEnum((I_Object)this);
        this.calc.setMetrics(arg);
    }

    private void mWrite(CallRuntime cr) {
        I_Object arg = cr.argsExt((I_Object)this, (Class[][])new Class[][]{{JMo_File.class, Str.class}})[0];
        if (arg instanceof Str) {
            String file = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)arg);
            try {
                FileOutputStream stream = new FileOutputStream(file);
                this.iWrite(cr, stream);
            }
            catch (FileNotFoundException e) {
                throw new ExternalError(cr, "PDF write error", "Could not write to file: " + file);
            }
        }
        JMo_File file = (JMo_File)arg;
        try {
            FileOutputStream stream = new FileOutputStream(file.getInternalFile());
            this.iWrite(cr, stream);
        }
        catch (FileNotFoundException e) {
            throw new ExternalError(cr, "PDF write error", "Could not write to file: " + file.getInternalFile().getAbsolutePath());
        }
    }
}

