/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.jci;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.jci.readers.FileResourceReader;
import org.apache.commons.jci.readers.MemoryResourceReader;
import org.apache.commons.jci.readers.ResourceReader;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_Dir;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_JCI_Source
extends A_ObjectSimple {
    private final ArrayList<String> classes = new ArrayList();
    private final ArrayList<String> sources = new ArrayList();
    private File dir = null;

    public String[] getClasses() {
        return this.classes.toArray(new String[this.classes.size()]);
    }

    public ResourceReader getReader(CallRuntime cr) {
        if (this.classes.size() == 0) {
            throw new ExternalError(cr, "Invalid source definition", "At least one class must be added.");
        }
        if (this.sources.size() > 0 && (this.classes.size() != this.sources.size() || this.dir != null)) {
            throw new ExternalError(cr, "Invalid source definition", "It' not possible to mix classes from source with classes from directory.");
        }
        if (this.dir != null) {
            return new FileResourceReader(this.dir);
        }
        MemoryResourceReader reader = new MemoryResourceReader();
        int i = 0;
        while (i < this.classes.size()) {
            reader.add(this.classes.get(i), this.sources.get(i).getBytes());
            ++i;
        }
        return reader;
    }

    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "add": {
                return this.mAdd(cr);
            }
            case "setDir": {
                return this.mSetDir(cr);
            }
        }
        return null;
    }

    private I_Object mAdd(CallRuntime cr) {
        I_Object[] args = cr.argsFlex((I_Object)this, 1, 2);
        String classpath = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)args[0]);
        this.classes.add(classpath);
        if (args.length == 2) {
            String source = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)args[1]);
            this.sources.add(source);
        }
        return this;
    }

    private I_Object mSetDir(CallRuntime cr) {
        I_Object arg = cr.argsExt((I_Object)this, (Class[][])new Class[][]{{Str.class, JMo_Dir.class}})[0];
        if (arg instanceof Str) {
            String s = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)arg);
            this.dir = new File(s);
            if (!this.dir.isDirectory()) {
                throw new ExternalError(cr, "Invalid source", "This is not an directory: " + s);
            }
            if (!this.dir.exists()) {
                throw new ExternalError(cr, "Invalid source", "Directory not exists: " + s);
            }
        } else {
            JMo_Dir dir = (JMo_Dir)arg;
            this.dir = dir.getInternalFile();
        }
        return this;
    }
}

