/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.jci;

import de.mn77.base.data.struct.SimpleList;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.stores.ResourceStoreClassLoader;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.sys.JMo_Java;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_JCI_Result
extends A_ObjectSimple {
    private final CompilationResult result;
    private final ResourceStore[] stores;

    public JMo_JCI_Result(CompilationResult result, ResourceStore[] stores) {
        this.result = result;
        this.stores = stores;
    }

    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "errors": {
                return this.mErrors(cr);
            }
            case "warnings": {
                return this.mWarnings(cr);
            }
            case "new": {
                return this.mNew(cr);
            }
        }
        return null;
    }

    private JMo_List iProblemsToList(CompilationProblem[] probs) {
        SimpleList errors = new SimpleList(probs.length);
        CompilationProblem[] compilationProblemArray = probs;
        int n = probs.length;
        int n2 = 0;
        while (n2 < n) {
            CompilationProblem problem = compilationProblemArray[n2];
            String s = String.valueOf(problem.getFileName()) + ':' + problem.getStartLine() + '[' + problem.getStartColumn() + "] " + problem.getMessage();
            errors.add((Object)new Str(s));
            ++n2;
        }
        return new JMo_List(errors);
    }

    private JMo_List mErrors(CallRuntime cr) {
        cr.argsNone();
        return this.iProblemsToList(this.result.getErrors());
    }

    private JMo_Java mNew(CallRuntime cr) {
        Str arg = (Str)cr.args((I_Object)this, new Class[]{Str.class})[0];
        String argLoad = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)arg);
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        ResourceStoreClassLoader loader = new ResourceStoreClassLoader(cl, this.stores);
        Object object = null;
        try {
            Class clazz = loader.loadClass(argLoad);
            object = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ExternalError(cr, "Class load error", e.getMessage());
        }
        return new JMo_Java(object);
    }

    private JMo_List mWarnings(CallRuntime cr) {
        cr.argsNone();
        return this.iProblemsToList(this.result.getWarnings());
    }
}

