/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.ftp;

import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.sys.Sys;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.ext.ftp.JMo_FtpRemotePath;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_Dir;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public abstract class A_AbstractFtpClient
extends A_ObjectSimple {
    private final ArgCallBuffer host;
    private final ArgCallBuffer user;
    private final ArgCallBuffer pass;
    private final ArgCallBuffer port;
    private FTPClient ftp = null;

    public A_AbstractFtpClient(Call host, Call user, Call pass) {
        this.host = new ArgCallBuffer(0, host);
        this.user = new ArgCallBuffer(1, user);
        this.pass = new ArgCallBuffer(2, pass);
        this.port = null;
    }

    public A_AbstractFtpClient(Call host, Call user, Call pass, Call port) {
        this.host = new ArgCallBuffer(0, host);
        this.user = new ArgCallBuffer(1, user);
        this.pass = new ArgCallBuffer(2, pass);
        this.port = new ArgCallBuffer(3, port);
    }

    public void init(CallRuntime cr) {
        this.host.init(cr, (I_Object)this, Str.class);
        this.user.init(cr, (I_Object)this, Str.class);
        this.pass.init(cr, (I_Object)this, Str.class);
        if (this.port != null) {
            this.port.init(cr, (I_Object)this, A_IntNumber.class);
        }
    }

    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "connect": {
                return this.mConnect(cr);
            }
            case "close": {
                return this.mClose(cr);
            }
            case "system": {
                return this.mSystem(cr);
            }
            case "dir": 
            case "current": {
                return this.mCurrent(cr);
            }
            case "list": {
                return this.mList(cr);
            }
            case "change": 
            case "changeDir": {
                return this.mChangeDir(cr);
            }
            case "make": 
            case "makeDir": {
                return this.mMakeDir(cr);
            }
            case "send": {
                return this.mSend(cr);
            }
            case "fetch": {
                return this.mFetch(cr);
            }
            case "delete": {
                return this.mDelete(cr);
            }
        }
        return null;
    }

    protected abstract FTPClient createClient();

    private void iCheckConnected(CallRuntime cr) {
        if (this.ftp == null) {
            throw new ExternalError(cr, "FTP-Connection error", "Connection not established! Please connect first.");
        }
    }

    private void iCheckDisconnected(CallRuntime cr) {
        if (this.ftp != null) {
            throw new ExternalError(cr, "FTP-Connection error", "Connection already established!");
        }
    }

    private String iToPathName(CallRuntime cr, I_Object arg) {
        if (arg instanceof Str) {
            String fileString = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)arg);
            File file = new File(fileString);
            return file.getName();
        }
        JMo_FtpRemotePath path = (JMo_FtpRemotePath)arg;
        return path.internalFile().getName();
    }

    private A_AbstractFtpClient mChangeDir(CallRuntime cr) {
        Str arg = (Str)cr.args((I_Object)this, new Class[]{Str.class})[0];
        this.iCheckConnected(cr);
        String dir = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)arg);
        try {
            this.ftp.changeWorkingDirectory(dir);
        }
        catch (IOException e) {
            throw new ExternalError(cr, "FTP-Error", e.getMessage());
        }
        return this;
    }

    private Nil mClose(CallRuntime cr) {
        cr.argsNone();
        this.iCheckConnected(cr);
        try {
            try {
                this.ftp.logout();
                this.ftp.disconnect();
            }
            catch (IOException e) {
                throw new ExternalError(cr, "FTP-Disconnect error", e.getMessage());
            }
        }
        finally {
            this.ftp = null;
        }
        return Nil.NIL;
    }

    private A_AbstractFtpClient mConnect(CallRuntime cr) {
        cr.argsNone();
        this.iCheckDisconnected(cr);
        this.ftp = this.createClient();
        String serverAddress = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)this.host.get());
        String loginUser = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)this.user.get());
        String loginPass = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)this.pass.get());
        Integer serverPort = this.port == null ? null : Integer.valueOf(Lib_Convert.getIntValue((CallRuntime)cr, (I_Object)this.port.get()));
        try {
            if (this.port != null) {
                this.ftp.connect(serverAddress, serverPort.intValue());
            } else {
                this.ftp.connect(serverAddress);
            }
            if (!this.ftp.login(loginUser, loginPass)) {
                this.ftp.logout();
                this.ftp.disconnect();
                this.ftp = null;
                throw new ExternalError(cr, "FTP-Connect error", "Login failed!");
            }
            int reply = this.ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftp.disconnect();
                this.ftp = null;
                throw new ExternalError(cr, "FTP-Connect error", "Connection failed!");
            }
            this.ftp.enterLocalPassiveMode();
        }
        catch (IOException e) {
            this.ftp = null;
            throw new ExternalError(cr, "FTP-Connect error", e.getMessage());
        }
        return this;
    }

    private Str mCurrent(CallRuntime cr) {
        cr.argsNone();
        this.iCheckConnected(cr);
        try {
            return new Str(this.ftp.printWorkingDirectory());
        }
        catch (IOException e) {
            throw new ExternalError(cr, "FTP-Error", e.getMessage());
        }
    }

    private A_AbstractFtpClient mDelete(CallRuntime cr) {
        I_Object arg = cr.argsExt((I_Object)this, (Class[][])new Class[][]{{Str.class, JMo_FtpRemotePath.class}})[0];
        this.iCheckConnected(cr);
        try {
            String pathName = this.iToPathName(cr, arg);
            boolean ok = this.ftp.deleteFile(pathName);
            if (!ok) {
                throw new ExternalError(cr, "FTP-Error", "File delete error: " + pathName);
            }
        }
        catch (IOException e) {
            throw new ExternalError(cr, "FTP-Error", e.getMessage());
        }
        return this;
    }

    private JMo_File mFetch(CallRuntime cr) {
        I_Object[] args = cr.argsFlex((I_Object)this, 1, 2);
        this.iCheckConnected(cr);
        try {
            String fileName;
            I_Object arg0 = cr.argTypeExt(args[0], new Class[]{Str.class, JMo_FtpRemotePath.class});
            String outFilePath = fileName = this.iToPathName(cr, arg0);
            if (args.length == 2) {
                JMo_Dir dir = (JMo_Dir)cr.argType(args[1], JMo_Dir.class);
                outFilePath = String.valueOf(dir.getInternalFile().getAbsolutePath()) + Sys.getSeperatorDir() + fileName;
            }
            File outFile = new File(outFilePath);
            outFile.createNewFile();
            FileOutputStream output = new FileOutputStream(outFile);
            boolean ok = this.ftp.retrieveFile(fileName, (OutputStream)output);
            if (!ok) {
                throw new ExternalError(cr, "FTP-Error", "File fetch error: " + fileName);
            }
            ((OutputStream)output).close();
            return new JMo_File(outFile);
        }
        catch (IOException e) {
            throw new ExternalError(cr, "FTP-Error", e.getMessage());
        }
    }

    private JMo_List mList(CallRuntime cr) {
        cr.argsNone();
        this.iCheckConnected(cr);
        try {
            FTPFile[] ftpFiles = this.ftp.listFiles();
            if (ftpFiles == null) {
                return new JMo_List();
            }
            SimpleList list = new SimpleList(ftpFiles.length);
            FTPFile[] fTPFileArray = ftpFiles;
            int n = ftpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile file = fTPFileArray[n2];
                list.add((Object)new JMo_FtpRemotePath(file));
                ++n2;
            }
            return new JMo_List(list);
        }
        catch (IOException e) {
            throw new ExternalError(cr, "FTP-Error", e.getMessage());
        }
    }

    private A_AbstractFtpClient mMakeDir(CallRuntime cr) {
        Str arg = (Str)cr.args((I_Object)this, new Class[]{Str.class})[0];
        this.iCheckConnected(cr);
        String dir = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)arg);
        try {
            boolean ok = this.ftp.makeDirectory(dir);
            if (!ok) {
                throw new ExternalError(cr, "FTP-Error", "Directory could not be created: " + dir);
            }
        }
        catch (IOException e) {
            throw new ExternalError(cr, "FTP-Error", e.getMessage());
        }
        return this;
    }

    private A_AbstractFtpClient mSend(CallRuntime cr) {
        I_Object[] args = cr.argsVar((I_Object)this, 1, 0);
        this.iCheckConnected(cr);
        try {
            I_Object[] i_ObjectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                I_Object arg = i_ObjectArray[n2];
                arg = cr.argTypeExt(arg, new Class[]{Str.class, JMo_File.class});
                File file = null;
                if (arg instanceof Str) {
                    String fileString = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)arg);
                    file = new File(fileString);
                } else {
                    file = ((JMo_File)arg).getInternalFile();
                }
                FileInputStream input = new FileInputStream(file);
                boolean ok = this.ftp.storeFile(file.getName(), (InputStream)input);
                if (!ok) {
                    throw new ExternalError(cr, "FTP-Error", "File send error: " + file.getAbsolutePath());
                }
                input.close();
                ++n2;
            }
        }
        catch (IOException e) {
            throw new ExternalError(cr, "FTP-Error", e.getMessage());
        }
        return this;
    }

    private Str mSystem(CallRuntime cr) {
        cr.argsNone();
        this.iCheckConnected(cr);
        try {
            return new Str(this.ftp.getSystemType());
        }
        catch (IOException e) {
            throw new ExternalError(cr, "FTP-Error", e.getMessage());
        }
    }
}

