/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.ext.pdf.fill;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import de.mn77.base.data.struct.I_Iterable;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.I_File;
import de.mn77.ext.pdf.fill.PDF_FillInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Function;

public class PDF_Filler {
    private final Object source;
    private boolean debug = false;

    public PDF_Filler(Function<?, InputStream> source_pdf) {
        this.source = source_pdf;
    }

    public PDF_Filler(InputStream source_pdf) {
        this.source = source_pdf;
    }

    public PDF_Filler(String source_pdf) {
        this.source = source_pdf;
    }

    public void fill(FileOutputStream target, Map<String, String> data) throws DocumentException, Err_FileSys {
        this.iFillSinglePage(target, data, false);
    }

    public void fill(FileOutputStream target, String tmpFile, I_Iterable<Map<String, String>> pages, PDF_FillInfo info) throws DocumentException, Err_FileSys {
        if (!(this.source instanceof Function) && !(this.source instanceof String)) {
            Err.forbidden((Object[])new Object[]{"F\u00fcr mehrere Seiten werden mehrere Streams auf das Template ben\u00f6tigt!"});
        }
        try {
            PdfReader reader = this.iReader();
            Document document = new Document(reader.getPageSizeWithRotation(1));
            PdfCopy pdfcopy = new PdfCopy(document, (OutputStream)target);
            if (info.PDF_VERSION.get() != null) {
                pdfcopy.setPdfVersion((PdfName)info.PDF_VERSION.get());
            }
            if (info.PDF_FORMAT.get() != null) {
                pdfcopy.setPDFXConformance(((Integer)info.PDF_FORMAT.get()).intValue());
            }
            if (((Boolean)info.COMPRESS.get()).booleanValue()) {
                pdfcopy.setFullCompression();
            }
            document.open();
            if (info.AUTHOR.get() != null) {
                document.addAuthor((String)info.AUTHOR.get());
            }
            if (info.BETREFF.get() != null) {
                document.addSubject((String)info.BETREFF.get());
            }
            document.addCreationDate();
            if (info.ERSTELLER.get() != null) {
                document.addCreator((String)info.ERSTELLER.get());
            }
            if (info.TITEL.get() != null) {
                document.addTitle((String)info.TITEL.get());
            }
            if (info.PDF_FORMAT.get() != null) {
                pdfcopy.createXmpMetadata();
            }
            for (Map page : pages) {
                PdfStamper stamp = this.iFillSinglePage(new FileOutputStream(tmpFile), page, true);
                PdfReader newPageReader = new PdfReader(tmpFile);
                pdfcopy.addPage(stamp.getImportedPage(newPageReader, 1));
                new File(tmpFile).delete();
            }
            document.close();
            pdfcopy.close();
            reader.close();
        }
        catch (IOException e) {
            throw Err.wrap((IOException)e, (Object[])new Object[]{"Dateifehler"});
        }
    }

    public void fill(I_File target, Map<String, String> data) throws DocumentException, Err_FileSys {
        this.fill(target.write(), data);
    }

    public void fill(I_File target, String tmp_file, I_Iterable<Map<String, String>> data, PDF_FillInfo info) throws DocumentException, Err_FileSys {
        this.fill(target.write(), tmp_file, data, info);
    }

    public void fill(String target, Map<String, String> data) throws DocumentException, Err_FileSys {
        try {
            this.fill(new FileOutputStream(target), data);
        }
        catch (FileNotFoundException e) {
            Err.wrap((IOException)e, (Object[])new Object[]{"Datei existiert nicht!"});
        }
    }

    public void fill(String target, String tmp_file, I_Iterable<Map<String, String>> data, PDF_FillInfo info) throws DocumentException, Err_FileSys {
        try {
            this.fill(new FileOutputStream(target), tmp_file, data, info);
        }
        catch (FileNotFoundException e) {
            Err.wrap((IOException)e, (Object[])new Object[]{"Datei existiert nicht!"});
        }
    }

    public I_Iterable<String> getFieldNames() throws IOException {
        SimpleList result = new SimpleList();
        Err.ifNull((Object)this.iReader());
        PdfReader reader = this.iReader();
        if (reader.getAcroForm() == null) {
            return result;
        }
        for (PRAcroForm.FieldInformation field : reader.getAcroForm().getFields()) {
            result.add((Object)field.getName());
        }
        return result;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    private PdfStamper iFillSinglePage(FileOutputStream dest_pdf, Map<String, String> data, boolean flattening) throws DocumentException, Err_FileSys {
        try {
            PdfReader reader = this.iReader();
            PdfStamper stamp = new PdfStamper(reader, (OutputStream)dest_pdf);
            stamp.setFullCompression();
            if (flattening) {
                stamp.setFormFlattening(true);
            }
            AcroFields form = stamp.getAcroFields();
            for (PRAcroForm.FieldInformation field : reader.getAcroForm().getFields()) {
                String feldname = field.getName();
                if (data.keySet().contains(feldname)) {
                    form.setField(feldname, data.get(feldname));
                    continue;
                }
                if (!this.debug) continue;
                MOut.dev((Object[])new Object[]{"Kein Text f\u00fcr Feld gefunden: " + feldname});
            }
            stamp.close();
            return stamp;
        }
        catch (IOException e) {
            throw Err.wrap((IOException)e, (Object[])new Object[]{"Dateifehler"});
        }
    }

    private PdfReader iReader() throws IOException {
        if (this.source instanceof String) {
            return new PdfReader((String)this.source);
        }
        if (this.source instanceof InputStream) {
            return new PdfReader((InputStream)this.source);
        }
        if (this.source instanceof Function) {
            return new PdfReader((InputStream)((Function)this.source).apply(null));
        }
        throw Err.impossible((Object[])new Object[0]);
    }
}

