/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.ext.pdf.create.page.item;

import com.lowagie.text.pdf.PdfContentByte;
import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.error.Err;
import de.mn77.ext.pdf.create.constant.PDF_FONT;
import de.mn77.ext.pdf.create.page.PDF_Page;
import de.mn77.ext.pdf.create.page.item.I_PDF_Item;
import java.awt.Color;

public class PDF_ItemText
implements I_PDF_Item {
    private final String text;
    private final float x;
    private final float y;
    private int[] rgb;
    private PDF_FONT font;
    private int fontsize;
    private boolean bold;
    private boolean italic;
    private POSITION_H alignment;

    public PDF_ItemText(float x, float y, String text) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.rgb = new int[3];
        this.font = PDF_FONT.HELVETICA;
        this.fontsize = 12;
        this.bold = false;
        this.italic = false;
        this.alignment = POSITION_H.LEFT;
    }

    @Override
    public void draw(PDF_Page page, PdfContentByte cb) {
        cb.setColorFill(new Color(this.rgb[0], this.rgb[1], this.rgb[2]));
        cb.beginText();
        cb.setFontAndSize(this.font.getBaseFont(this.bold, this.italic), (float)this.fontsize);
        int align = 0;
        if (this.alignment == POSITION.RIGHT) {
            align = 2;
        }
        if (this.alignment == POSITION.CENTER) {
            align = 1;
        }
        cb.showTextAligned(align, this.text, this.x, page.getHeight() - this.y, 0.0f);
        cb.endText();
    }

    public PDF_ItemText setAlignment(POSITION_H a) {
        this.alignment = a;
        return this;
    }

    public PDF_ItemText setAlignRight() {
        this.alignment = POSITION_H.RIGHT;
        return this;
    }

    public PDF_ItemText setBold() {
        this.bold = true;
        return this;
    }

    public PDF_ItemText setColor(int ... rgb) {
        Err.ifNot((Object)3, (Object)rgb.length);
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rgb[0]});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rgb[1]});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rgb[2]});
        this.rgb = rgb;
        return this;
    }

    public PDF_ItemText setFont(PDF_FONT font) {
        Err.ifNull((Object)((Object)font));
        this.font = font;
        return this;
    }

    public PDF_ItemText setFontsize(int fontsize) {
        Err.ifOutOfBounds((int)4, (int)150, (int[])new int[]{fontsize});
        this.fontsize = fontsize;
        return this;
    }

    public PDF_ItemText setItalic() {
        this.italic = true;
        return this;
    }
}

