/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.ext.pdf.create.constant;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import de.mn77.base.error.Err;
import java.io.IOException;

public enum PDF_FONT {
    HELVETICA("Helvetica", "Helvetica-Bold", "Helvetica-Oblique", "Helvetica-BoldOblique"),
    COURIER("Courier", "Courier-Bold", "Courier-Oblique", "Courier-BoldOblique"),
    TIMES("Times", "Times-Bold", "Times-Italic", "Times-BoldItalic");

    private final String regular;
    private final String bold;
    private final String italic;
    private final String boldItalic;

    private PDF_FONT(String regular, String fett, String kursiv, String boldItalic) {
        this.regular = regular;
        this.bold = fett;
        this.italic = kursiv;
        this.boldItalic = boldItalic;
    }

    public BaseFont getBaseFont(boolean bold, boolean italic) {
        BaseFont result = null;
        try {
            result = BaseFont.createFont((String)this.getName(bold, italic), (String)"Cp1252", (boolean)false);
        }
        catch (DocumentException e) {
            throw Err.newRuntime((String)"PDF-Error", (Object[])new Object[]{e});
        }
        catch (IOException e) {
            throw Err.newRuntime((String)"Font not available!", (Object[])new Object[]{e, this.getName(bold, italic)});
        }
        Err.ifNull((Object)result);
        return result;
    }

    public String getName(boolean bold, boolean italic) {
        if (!bold && !italic) {
            return this.regular;
        }
        if (bold && !italic) {
            return this.bold;
        }
        if (!bold && italic) {
            return this.italic;
        }
        return this.boldItalic;
    }
}

