/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.it.preprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import marytts.datatypes.MaryXML;
import marytts.language.it.preprocess.ExpansionPattern;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NumberEP
extends ExpansionPattern {
    private final String[] _knownTypes = new String[]{"number", "number:float", "number:integer", "number:ordinal", "number:roman", "number:digits", "number:cardinal"};
    private final List knownTypes = Arrays.asList(this._knownTypes);
    protected static final String sFloat = "(?:-?(?:[1-9][0-9]*|0)?(?:\\.|,)[0-9]+)";
    protected static final String sInteger = "(?:-?[1-9][0-9]{0,11}|0)";
    protected static final String sOrdinal = "(?:(?:-?[1-9][0-9]{0,11}|0)[\u00b0.])";
    protected static final String sRoman = "(?:[MDCLXVI]+\\.?)";
    protected static final String sDigits = "(?:[0-9.,]*[0-9][.,]?)";
    protected static final String sCardinal = "(?:-?(?:[1-9][0-9]*|0)?(?:\\.|,)[0-9]+)|(?:-?[1-9][0-9]{0,11}|0)";
    protected final Pattern reFloat = Pattern.compile("(?:-?(?:[1-9][0-9]*|0)?(?:\\.|,)[0-9]+)");
    protected final Pattern reInteger = Pattern.compile("(?:-?[1-9][0-9]{0,11}|0)");
    protected final Pattern reOrdinal = Pattern.compile("(?:(?:-?[1-9][0-9]{0,11}|0)[\u00b0.])");
    protected final Pattern reRoman = Pattern.compile("(?:[MDCLXVI]+\\.?)");
    protected final Pattern reDigits = Pattern.compile("(?:[0-9.,]*[0-9][.,]?)");
    private final Pattern reMatchingChars = null;
    private Logger logger = MaryUtils.getLogger((String)"NumberEP");

    @Override
    public List knownTypes() {
        return this.knownTypes;
    }

    @Override
    public Pattern reMatchingChars() {
        return this.reMatchingChars;
    }

    @Override
    protected boolean allowMultipleTokens() {
        return false;
    }

    @Override
    protected boolean isCandidate(Element t) {
        String s = MaryDomUtils.tokenText((Element)t);
        return this.reFloat.matcher(s).matches() || this.reInteger.matcher(s).matches() || this.reOrdinal.matcher(s).matches() || this.reRoman.matcher(s).matches() || this.reDigits.matcher(s).matches();
    }

    @Override
    protected int match(String s, int type) {
        switch (type) {
            case 0: {
                if (this.matchFloat(s)) {
                    return 1;
                }
                if (this.matchInteger(s)) {
                    return 2;
                }
                if (this.matchOrdinal(s)) {
                    return 3;
                }
                if (!this.matchDigits(s)) break;
                return 5;
            }
            case 1: {
                if (!this.matchFloat(s)) break;
                return 1;
            }
            case 2: {
                if (!this.matchInteger(s)) break;
                return 2;
            }
            case 3: {
                if (!this.matchOrdinal(s)) break;
                return 3;
            }
            case 4: {
                if (!this.matchRoman(s)) break;
                return 4;
            }
            case 5: {
                if (!this.matchDigits(s)) break;
                return 5;
            }
            case 6: {
                if (this.matchInteger(s)) {
                    return 2;
                }
                if (!this.matchFloat(s)) break;
                return 1;
            }
        }
        return -1;
    }

    @Override
    protected int canDealWith(String input, int typeCode) {
        switch (typeCode) {
            case 0: {
                if (this.matchFloat(input)) {
                    return 1;
                }
                if (this.matchInteger(input)) {
                    return 2;
                }
                if (this.matchOrdinal(input)) {
                    return 3;
                }
                if (this.matchRoman(input)) {
                    return 4;
                }
                if (!this.matchDigits(input)) break;
                return 5;
            }
            case 1: {
                if (!this.matchFloat(input)) break;
                return 1;
            }
            case 2: {
                if (!this.matchInteger(input) && !this.matchRoman(input)) break;
                return 2;
            }
            case 3: {
                if (!this.matchOrdinal(input) && !this.matchInteger(input) && !this.matchRoman(input)) break;
                return 3;
            }
            case 4: {
                if (!this.matchRoman(input)) break;
                return 4;
            }
            case 5: {
                if (!this.matchDigits(input)) break;
                return 5;
            }
            case 6: {
                if (this.matchInteger(input)) {
                    return 2;
                }
                if (!this.matchFloat(input)) break;
                return 1;
            }
        }
        return -1;
    }

    @Override
    protected List expand(List tokens, String s, int type) {
        if (tokens == null) {
            throw new NullPointerException("Received null argument");
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Received empty list");
        }
        Document doc = ((Element)tokens.get(0)).getOwnerDocument();
        List expanded = null;
        switch (type) {
            case 1: {
                expanded = this.expandFloat(doc, s, true);
                break;
            }
            case 2: {
                expanded = this.expandInteger(doc, s, true);
                break;
            }
            case 3: {
                expanded = this.expandOrdinal(doc, s, true);
                break;
            }
            case 4: {
                expanded = this.expandRoman(doc, s, true);
                break;
            }
            case 5: {
                expanded = this.expandDigits(doc, s, true);
            }
        }
        this.replaceTokens(tokens, expanded);
        return expanded;
    }

    protected boolean matchFloat(String s) {
        return this.reFloat.matcher(s).matches();
    }

    protected boolean matchInteger(String s) {
        return this.reInteger.matcher(s).matches();
    }

    protected boolean matchOrdinal(String s) {
        return this.reOrdinal.matcher(s).matches();
    }

    protected boolean matchRoman(String s) {
        return this.reRoman.matcher(s).matches();
    }

    protected boolean matchDigits(String s) {
        return this.reDigits.matcher(s).matches();
    }

    /*
     * Exception decompiling
     */
    protected List expandInteger(Document doc, String s, boolean createMtu) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected List expandInteger(Document doc, long value, boolean createMtu, String orig) {
        String expString = this.expandInteger(value);
        return this.makeNewTokens(doc, expString, createMtu, orig);
    }

    protected String expandInteger(String s) {
        long value;
        try {
            while (s.length() > 1 && s.startsWith("0")) {
                s = s.substring(1);
            }
            value = Long.decode(s);
        }
        catch (NumberFormatException e) {
            this.logger.info((Object)("Cannot convert string \"" + s + "\" to long."));
            throw e;
        }
        return this.expandInteger(value);
    }

    protected String expandInteger(long value) {
        StringBuilder buf = new StringBuilder();
        if (value == 0L) {
            return new String("null");
        }
        if (value < 0L) {
            buf.append("meno ");
        }
        long milliards = value / 1000000000L;
        long rest = value % 1000000000L;
        if (milliards > 1L) {
            buf.append(this.expandInteger(milliards));
            buf.append(" ");
            if (milliards % 1000000L == 0L) {
                buf.append("di ");
            }
            buf.append("miliardi ");
        } else if (milliards == 1L) {
            buf.append("un miliardo ");
        }
        long millions = rest / 1000000L;
        rest = value % 1000000L;
        if (millions > 1L) {
            buf.append(this.expandInteger(millions));
            buf.append(" ");
            buf.append("milioni ");
        } else if (millions == 1L) {
            buf.append("un milione ");
        }
        long thousands = rest / 1000L;
        rest %= 1000L;
        if (thousands > 1L) {
            buf.append(this.expandInteger(thousands));
            buf.append(" ");
            buf.append("mila ");
        } else if (thousands == 1L) {
            buf.append("mille ");
        }
        int hundreds = (int)rest / 100;
        rest %= 100L;
        if (hundreds > 1) {
            buf.append(this.expandInteger(hundreds));
            buf.append(" ");
            buf.append("cento ");
        } else if (hundreds == 1) {
            buf.append("cento ");
        }
        if (rest >= 20L) {
            int tens = (int)rest / 10;
            if ((rest %= 10L) == 1L || rest == 8L) {
                switch (tens) {
                    case 2: {
                        buf.append("vent");
                        break;
                    }
                    case 3: {
                        buf.append("trent");
                        break;
                    }
                    case 4: {
                        buf.append("quarant");
                        break;
                    }
                    case 5: {
                        buf.append("cinquant");
                        break;
                    }
                    case 6: {
                        buf.append("sessant");
                        break;
                    }
                    case 7: {
                        buf.append("settant");
                        break;
                    }
                    case 8: {
                        buf.append("ottant");
                        break;
                    }
                    case 9: {
                        buf.append("novant");
                    }
                }
            } else {
                switch (tens) {
                    case 2: {
                        buf.append("venti ");
                        break;
                    }
                    case 3: {
                        buf.append("trenta ");
                        break;
                    }
                    case 4: {
                        buf.append("quaranta ");
                        break;
                    }
                    case 5: {
                        buf.append("cinquanta ");
                        break;
                    }
                    case 6: {
                        buf.append("sessanta ");
                        break;
                    }
                    case 7: {
                        buf.append("settanta ");
                        break;
                    }
                    case 8: {
                        buf.append("ottanta ");
                        break;
                    }
                    case 9: {
                        buf.append("novanta ");
                    }
                }
            }
            switch ((int)rest) {
                case 1: {
                    buf.append("uno ");
                    break;
                }
                case 2: {
                    buf.append("due ");
                    break;
                }
                case 3: {
                    buf.append("tre ");
                    break;
                }
                case 4: {
                    buf.append("quattro ");
                    break;
                }
                case 5: {
                    buf.append("cinque ");
                    break;
                }
                case 6: {
                    buf.append("sei ");
                    break;
                }
                case 7: {
                    buf.append("sette ");
                    break;
                }
                case 8: {
                    buf.append("otto ");
                    break;
                }
                case 9: {
                    buf.append("nove ");
                }
            }
        } else {
            switch ((int)rest) {
                case 1: {
                    buf.append("uno ");
                    break;
                }
                case 2: {
                    buf.append("due ");
                    break;
                }
                case 3: {
                    buf.append("tre ");
                    break;
                }
                case 4: {
                    buf.append("quattro ");
                    break;
                }
                case 5: {
                    buf.append("cinque ");
                    break;
                }
                case 6: {
                    buf.append("sei ");
                    break;
                }
                case 7: {
                    buf.append("sette ");
                    break;
                }
                case 8: {
                    buf.append("otto ");
                    break;
                }
                case 9: {
                    buf.append("nove ");
                    break;
                }
                case 10: {
                    buf.append("dieci ");
                    break;
                }
                case 11: {
                    buf.append("undici ");
                    break;
                }
                case 12: {
                    buf.append("dodici ");
                    break;
                }
                case 13: {
                    buf.append("tredici ");
                    break;
                }
                case 14: {
                    buf.append("quattordici ");
                    break;
                }
                case 15: {
                    buf.append("quindici ");
                    break;
                }
                case 16: {
                    buf.append("sedici ");
                    break;
                }
                case 17: {
                    buf.append("diciassette ");
                    break;
                }
                case 18: {
                    buf.append("diciotto ");
                    break;
                }
                case 19: {
                    buf.append("diciannove ");
                }
            }
        }
        return buf.toString().trim();
    }

    protected List expandFloat(Document doc, String s, boolean createMtu) {
        String expString = this.expandFloat(s);
        return this.makeNewTokens(doc, expString, createMtu, s);
    }

    protected String expandFloat(String number) {
        long whole = 0L;
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < number.length() && Character.isDigit(number.charAt(i))) {
            whole *= 10L;
            whole += (long)(number.charAt(i) - 48);
            ++i;
        }
        buf.append(this.expandInteger(whole));
        buf.append(" ");
        if (i < number.length()) {
            buf.append(this.expandDigits(number.substring(i)));
        }
        return buf.toString().trim();
    }

    protected List expandDigits(Document doc, String s, boolean createMtu) {
        String expString = this.expandDigits(s);
        return this.makeNewTokens(doc, expString, createMtu, s);
    }

    protected String expandDigits(String digits) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < digits.length()) {
            switch (digits.charAt(i)) {
                case ',': {
                    buf.append("virgola ");
                    break;
                }
                case '.': {
                    buf.append("punto ");
                    break;
                }
                case '0': {
                    buf.append("zero ");
                    break;
                }
                case '1': {
                    buf.append("uno ");
                    break;
                }
                case '2': {
                    buf.append("due ");
                    break;
                }
                case '3': {
                    buf.append("tre ");
                    break;
                }
                case '4': {
                    buf.append("quattro ");
                    break;
                }
                case '5': {
                    buf.append("cinque ");
                    break;
                }
                case '6': {
                    buf.append("sei ");
                    break;
                }
                case '7': {
                    buf.append("sette ");
                    break;
                }
                case '8': {
                    buf.append("otto ");
                    break;
                }
                case '9': {
                    buf.append("nove ");
                    break;
                }
                default: {
                    buf.append(digits.charAt(i));
                    buf.append(' ');
                }
            }
            ++i;
        }
        return buf.toString().trim();
    }

    protected List expandOrdinal(Document doc, String s, boolean createMtu) {
        long value;
        if (this.matchRoman(s)) {
            return this.expandRoman(doc, s, createMtu, true);
        }
        String intString = this.matchInteger(s) ? s : s.substring(0, s.length() - 1);
        try {
            while (intString.length() > 1 && intString.startsWith("0")) {
                intString = intString.substring(1);
            }
            value = Long.decode(intString);
        }
        catch (NumberFormatException e) {
            this.logger.info((Object)("Cannot convert string \"" + intString + "\" to long."));
            throw e;
        }
        return this.expandOrdinal(doc, value, createMtu, s);
    }

    protected List expandOrdinal(Document doc, long value, boolean createMtu, String orig) {
        StringBuilder exp = new StringBuilder();
        block0 : switch ((int)Math.abs(value)) {
            case 1: {
                exp.append("primo");
                break;
            }
            case 2: {
                exp.append("secondo");
                break;
            }
            case 3: {
                exp.append("terzo");
                break;
            }
            case 4: {
                exp.append("quarto");
                break;
            }
            case 5: {
                exp.append("quinto");
                break;
            }
            case 6: {
                exp.append("sesto");
                break;
            }
            case 7: {
                exp.append("settimo");
                break;
            }
            case 8: {
                exp.append("ottavo");
                break;
            }
            case 9: {
                exp.append("nono");
                break;
            }
            case 10: {
                exp.append("decimo");
                break;
            }
            default: {
                exp.append(this.expandInteger(Math.abs(value)));
                switch (exp.charAt(exp.length() - 1)) {
                    case 'e': {
                        if (exp.charAt(exp.length() - 2) == 'r') {
                            exp.append("esimo");
                            break block0;
                        }
                        exp.append("simo");
                        break block0;
                    }
                    case 'o': {
                        exp.replace(exp.length() - 1, exp.length(), "esimo");
                        break block0;
                    }
                    case 'i': {
                        exp.replace(exp.length() - 1, exp.length(), "esimo");
                    }
                }
            }
        }
        Element t = MaryXML.createElement((Document)doc, (String)"t");
        MaryDomUtils.setTokenText((Element)t, (String)orig);
        t.setAttribute("sounds_like", exp.toString());
        t.setAttribute("ending", "ordinal");
        t.setAttribute("pos", "ADJA");
        ArrayList<Element> result = new ArrayList<Element>();
        if (createMtu) {
            Element mtu = MaryXML.createElement((Document)doc, (String)"mtu");
            mtu.setAttribute("orig", orig);
            mtu.appendChild(t);
            result.add(mtu);
        } else {
            result.add(t);
        }
        return result;
    }

    protected List expandRoman(Document doc, String number, boolean createMtu) {
        boolean isOrdinal = false;
        if (number.charAt(number.length() - 1) == '.') {
            isOrdinal = true;
            number = number.substring(0, number.length() - 1);
        }
        return this.expandRoman(doc, number, createMtu, isOrdinal);
    }

    protected List expandRoman(Document doc, String number, boolean createMtu, boolean isOrdinal) {
        if (number.charAt(number.length() - 1) == '.') {
            number = number.substring(0, number.length() - 1);
        }
        int value = MaryUtils.romanToInt((String)number);
        if (isOrdinal) {
            return this.expandOrdinal(doc, value, createMtu, number);
        }
        return this.expandInteger(doc, value, createMtu, number);
    }
}

