/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.runtime;

import de.mn77.base.data.group.Group2;
import de.mn77.base.data.group.Group4;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.FunctionPar;
import org.jaymo_lang.model.MultiCallItems;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.ConstEnv;
import org.jaymo_lang.runtime.VarEnv;

public class VarConstEnv {
    private static int counter = 0;
    private final int id;
    public final VarEnv vars;
    public final ConstEnv cons;
    private final VarConstEnv parent;
    private MultiCallItems multicall = null;
    private LoopHandle loop = null;
    private Group4<Block, CallRuntime, CallRuntime, FunctionPar[]> funcInitData = null;
    private Group2<CallRuntime, CallRuntime> initType = null;
    private LoopHandle childLoop = null;

    public VarConstEnv(VarConstEnv parent) {
        this.parent = parent;
        VarEnv parentVars = parent == null ? null : parent.vars;
        ConstEnv parentCons = parent == null ? null : parent.cons;
        this.vars = new VarEnv(parentVars);
        this.cons = new ConstEnv(parentCons);
        this.id = ++counter;
        if (parent != null && parent.childLoop != null) {
            this.loop = parent.childLoop;
        }
    }

    public VarConstEnv(VarEnv vars, ConstEnv cons, VarConstEnv parent) {
        this.parent = parent;
        this.vars = vars;
        this.cons = cons;
        this.id = ++counter;
        if (parent != null && parent.childLoop != null) {
            this.loop = parent.childLoop;
        }
    }

    public VarConstEnv copyConst(DebugInfo debug) {
        VarEnv v = new VarEnv(null);
        return new VarConstEnv(v, this.cons, null);
    }

    public Group4<Block, CallRuntime, CallRuntime, FunctionPar[]> getFuncInit(CallRuntime cr) {
        if (this.funcInitData != null) {
            return this.funcInitData;
        }
        if (this.parent != null) {
            return this.parent.getFuncInit(cr);
        }
        throw Err.invalid("There's no data to initialize!");
    }

    public int getID() {
        return this.id;
    }

    public VarConstEnv getParent() {
        return this.parent;
    }

    public Group2<CallRuntime, CallRuntime> initTypeGet() {
        VarConstEnv cur = this;
        while (cur.initType == null && cur.parent != null) {
            cur = cur.parent;
        }
        return cur.initType;
    }

    public void initTypeSet(CallRuntime crOld, CallRuntime cpNew2) {
        this.initType = new Group2<CallRuntime, CallRuntime>(crOld, cpNew2);
    }

    public LoopHandle loopGet(CallRuntime cr) {
        if (this.loop != null) {
            return this.loop;
        }
        if (this.parent != null) {
            return this.parent.loopGet(cr);
        }
        throw new CodeError(cr, "Unknown loop!", "There's no loop known, in this and the parent blocks");
    }

    public void loopSet(LoopHandle handle) {
        if (this.loop != null) {
            Err.invalid("Loop is already set!");
        }
        this.loop = handle;
    }

    public void setChildLoop(LoopHandle handle) {
        this.childLoop = handle;
    }

    public void setFuncInit(Block block, CallRuntime cpOutside, CallRuntime crNew, FunctionPar[] vars) {
        this.funcInitData = new Group4<Block, CallRuntime, CallRuntime, FunctionPar[]>(block, cpOutside, crNew, vars);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VCE: ");
        sb.append(this.id);
        VarConstEnv parent = this.parent;
        while (parent != null) {
            sb.append(" -> ");
            sb.append(parent.id);
            parent = parent.parent;
        }
        return sb.toString();
    }

    public MultiCallItems useMultiCall() {
        if (this.multicall == null && this.parent != null) {
            this.multicall = this.parent.useMultiCall();
        }
        if (this.multicall == null) {
            this.multicall = new MultiCallItems();
        }
        return this.multicall;
    }
}

