/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser;

import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.debug.DEBUG_MODE;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.MFile;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.model.App;
import org.jaymo_lang.parser.PARSER_LEVEL;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.util.ClassFinder;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Parser;
import org.jaymo_lang.util.Lib_Prefix;
import org.jaymo_lang.util.Lib_StringParser;

public class ParseTimeSwitches {
    public void parse(Parser_Script parser, String s, DebugInfo debug) {
        App app = parser.app;
        s = s.substring(1).trim();
        app.strict.checkSandbox(debug, "> " + s);
        char c0 = s.charAt(0);
        switch (c0) {
            case '*': {
                app.strict.checkShortImports(debug);
                String jclass = this.iIncludeFree(s, "java-package", debug);
                ClassFinder.getInstance().addJavaImportPackage(jclass, debug);
                return;
            }
            case '?': {
                app.strict.checkShortImports(debug);
                String jpack = this.iIncludeFree(s, "java-class", debug);
                ClassFinder.getInstance().addJavaImportClass(jpack, debug);
                return;
            }
            case '>': {
                app.strict.checkShortImports(debug);
                String include = this.iIncludeFree(s, "file", debug);
                app.importsAdd(parser.getFileBase(), include);
                return;
            }
        }
        Group2<String, String[]> g = this.iSplitLine(s, parser);
        switch ((String)g.o1) {
            case "include": {
                String[] stringArray = (String[])g.o2;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String si = stringArray[n2];
                    si = this.iCheckParseArgument(si, "include", debug);
                    app.importsAdd(parser.getFileBase(), si);
                    ++n2;
                }
                return;
            }
            case "class": {
                String[] stringArray = (String[])g.o2;
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String si = stringArray[n3];
                    si = this.iCheckParseArgument(si, "java-class", debug);
                    ClassFinder.getInstance().addJavaImportClass(si, debug);
                    ++n3;
                }
                return;
            }
            case "package": {
                String[] stringArray = (String[])g.o2;
                int n = stringArray.length;
                int n4 = 0;
                while (n4 < n) {
                    String si = stringArray[n4];
                    si = this.iCheckParseArgument(si, "java-package", debug);
                    ClassFinder.getInstance().addJavaImportPackage(si, debug);
                    ++n4;
                }
                return;
            }
            case "prefix": {
                String si;
                this.argCheckCount(0, 1, (String[])g.o2, debug);
                String string = si = ((String[])g.o2).length == 0 ? null : ((String[])g.o2)[0];
                if (si != null) {
                    si = this.iCheckParseArgument(si, "prefix", debug);
                    Lib_Prefix.checkPrefix(si, debug);
                }
                parser.setCurrentPrefix(si);
                return;
            }
        }
        app.strict.checkParseTimeSwitch((String)g.o1, debug);
        switch ((String)g.o1) {
            case "debug": {
                app.setDebug();
                MOut.setDebug(DEBUG_MODE.MINIMAL);
                MOut.setJavaErrors(true);
                return;
            }
            case "setOutputFile": {
                this.argCheckCount(0, 1, (String[])g.o2, debug);
                String opf = ((String[])g.o2).length == 0 ? null : this.parString(((String[])g.o2)[0], debug);
                MFile opf2 = opf == null ? null : new MFile(opf);
                app.setOutputFile(opf2);
                return;
            }
            case "sandBox": 
            case "sandbox": {
                this.argCheckNone((String[])g.o2, debug);
                app.strict.setSandbox();
                return;
            }
            case "noJava": 
            case "nojava": {
                this.argCheckNone((String[])g.o2, debug);
                app.strict.setNoJava();
                return;
            }
            case "strictWebstart": {
                this.argCheckNone((String[])g.o2, debug);
                app.strict.setWebstart();
                return;
            }
            case "lazyErrors": 
            case "errorsLazy": {
                this.argCheckNone((String[])g.o2, debug);
                app.strict.setLazyErrors();
                return;
            }
            case "noWarnings": {
                this.argCheckNone((String[])g.o2, debug);
                app.strict.setNoWarnings();
                return;
            }
            case "unsafeHotCode": {
                this.argCheckNone((String[])g.o2, debug);
                app.strict.setUnsafeHotCode();
                return;
            }
            case "cleanFlow": {
                this.argCheckNone((String[])g.o2, debug);
                app.strict.setClearFlow();
                return;
            }
            case "open": {
                this.argCheckNone((String[])g.o2, debug);
                return;
            }
            case "low": {
                this.argCheckNone((String[])g.o2, debug);
                app.strict.set(PARSER_LEVEL.LOW, debug);
                return;
            }
            case "medium": 
            case "strict": {
                this.argCheckNone((String[])g.o2, debug);
                app.strict.set(PARSER_LEVEL.MEDIUM, debug);
                return;
            }
            case "high": {
                this.argCheckNone((String[])g.o2, debug);
                app.strict.set(PARSER_LEVEL.HIGH, debug);
                return;
            }
            case "insane": {
                this.argCheckNone((String[])g.o2, debug);
                app.strict.set(PARSER_LEVEL.INSANE, debug);
                return;
            }
        }
        throw new CodeError("Unknown Parsetime-Command", s, debug);
    }

    private void argCheckCount(int min, int max, String[] pa, DebugInfo debug) {
        Lib_Error.ifNotBetween(min, max, pa.length, "arguments", debug);
    }

    private void argCheckNone(String[] pa, DebugInfo debug) {
        Lib_Error.ifNotBetween(0, 0, pa.length, "arguments", debug);
    }

    private String iCheckParseArgument(String s, String info, DebugInfo debug) {
        Group2<String, Integer> sg = Lib_Parser.stringGet(s = s.trim(), debug);
        if (sg == null || (Integer)sg.o2 != s.length() - 1) {
            throw new CodeError("Invalid argument for " + info + "!", s, debug);
        }
        return (String)sg.o1;
    }

    private String iIncludeFree(String s, String title, DebugInfo debug) {
        String s2 = s.substring(1).trim();
        if (s2.length() == 0) {
            throw new CodeError("Invalid include!", "Which " + title + " should I include?", debug);
        }
        if (s2.charAt(0) == '\"') {
            Group2<String, Integer> g = Lib_Parser.stringGet(s2, debug);
            if ((Integer)g.o2 != s2.length() - 1) {
                throw new CodeError("Invalid argument for include!", s, debug);
            }
            return (String)g.o1;
        }
        return s2;
    }

    private Group2<String, String> iSplitCommand(String s, Parser_Script parser) {
        int i = 0;
        while (i < s.length()) {
            switch (s.charAt(i)) {
                case '(': {
                    String command = s.substring(0, i).trim();
                    String rem = s.substring(i).trim();
                    if (rem.charAt(rem.length() - 1) != ')') {
                        throw new CodeError("Closing bracket is missing!", s, parser.getDebugInfo());
                    }
                    rem = rem.substring(1, rem.length() - 1);
                    return new Group2<String, String>(command, rem);
                }
                case ' ': 
                case '=': {
                    String command2 = s.substring(0, i).trim();
                    String rem2 = s.substring(i).trim();
                    if (rem2.startsWith("=")) {
                        if (!parser.app.strict.isValid_AutoProperty()) {
                            throw new CodeError("Strict! Auto-Property is forbidden!", "Please use brackets for arguments.", parser.getDebugInfo());
                        }
                        rem2 = rem2.substring(1).trim();
                    } else {
                        parser.app.strict.checkOpenArg(parser.getDebugInfo());
                    }
                    return new Group2<String, String>(command2, rem2);
                }
            }
            ++i;
        }
        return new Group2<String, Object>(s, null);
    }

    private Group2<String, String[]> iSplitLine(String s, Parser_Script parser) {
        Group2<String, String> command_args = this.iSplitCommand(s, parser);
        String command = (String)command_args.o1;
        String rem = (String)command_args.o2;
        if (rem == null) {
            return new Group2<String, String[]>(command, new String[0]);
        }
        SimpleList<String> pa = new SimpleList<String>();
        while (rem.length() > 0) {
            Group2<String, String> result = Lib_StringParser.getNextPar(rem, parser.getDebugInfo());
            pa.add((String)result.o1);
            if (((String)result.o2).equals(rem)) {
                throw new CodeError("Invalid ParseTime-Command!", s, parser.getDebugInfo());
            }
            rem = (String)result.o2;
        }
        String[] sa = pa.toArray((T[])new String[pa.size()]);
        return new Group2<String, String[]>(command, sa);
    }

    private String parString(String s, DebugInfo debug) {
        if ((s = s.trim()).charAt(0) != '\"' || s.charAt(s.length() - 1) != '\"') {
            throw new CodeError("Invalid string!", s, debug);
        }
        return s.substring(1, s.length() - 1);
    }
}

