/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.sys;

import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.sys.cmd.SYSCMD_IO;
import de.mn77.base.sys.cmd.SysCmd;
import de.mn77.base.sys.cmd.SysCmdData;
import de.mn77.base.sys.cmd.SysCmdResult;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.struct.JMo_FunctionMap;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Output;

public class JMo_Cmd
extends A_Object {
    private final ArgCallBuffer cmd;

    public JMo_Cmd(Call c) {
        this.cmd = new ArgCallBuffer(0, c);
    }

    @Override
    public void init(CallRuntime cr) {
        cr.getApp().strict.checkSandbox(cr, "Cmd");
        this.cmd.init(cr, this, Str.class);
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        return "Cmd(" + this.cmd.toString(cr, STYPE.IDENT) + ")";
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "exec": 
            case "live": {
                return A_Object.stdResult(this.mLive(cr));
            }
            case "buffer": {
                return A_Object.stdResult(this.mBuffer(cr, true));
            }
            case "error": {
                return A_Object.stdResult(this.mError(cr, true));
            }
            case "forget": {
                return A_Object.stdResult(this.mForget(cr));
            }
            case "output": {
                return A_Object.stdResult(this.mOutput(cr));
            }
            case "wait": {
                return A_Object.stdResult(this.mWait(cr));
            }
        }
        return null;
    }

    private JMo_FunctionMap mBuffer(CallRuntime cr, boolean quiet) {
        cr.argsNone();
        SysCmdResult res = this.run(cr, true, INOUT.BUFFER);
        String output = FilterString.removeNewlineEnd(res.output);
        String errors = FilterString.removeNewlineEnd(res.error);
        SimpleList<String> names = new SimpleList<String>();
        SimpleList<I_Object> objects = new SimpleList<I_Object>();
        names.add("result");
        objects.add(new Int(res.result));
        names.add("output");
        objects.add(new Str(output));
        names.add("errors");
        objects.add(new Str(errors));
        JMo_FunctionMap with = new JMo_FunctionMap(cr, names, objects);
        if (!quiet) {
            Lib_Output.out(cr.getApp(), output, true);
        }
        return with;
    }

    private Str mError(CallRuntime cr, boolean quiet) {
        cr.argsNone();
        SysCmdResult res = this.run(cr, true, INOUT.BUFFER);
        String output = FilterString.removeNewlineEnd(res.output);
        String errors = FilterString.removeNewlineEnd(res.error);
        if (!quiet) {
            Lib_Output.out(cr.getApp(), output, true);
        }
        return new Str(errors);
    }

    private Nil mForget(CallRuntime cr) {
        cr.argsNone();
        this.run(cr, false, INOUT.NONE);
        return Nil.NIL;
    }

    private I_Object mLive(CallRuntime cr) {
        cr.argsNone();
        SysCmdResult res = this.run(cr, true, INOUT.LIVE);
        return new Int(res.result);
    }

    private I_Object mOutput(CallRuntime cr) {
        cr.argsNone();
        SysCmdResult res = this.run(cr, true, INOUT.BUFFER);
        String output = FilterString.removeNewlineEnd(res.output);
        String errors = FilterString.removeNewlineEnd(res.error);
        if (errors != null && errors.length() > 0) {
            Lib_Output.out(cr.getApp(), errors, true);
        }
        return new Str(output);
    }

    private I_Object mWait(CallRuntime cr) {
        cr.argsNone();
        SysCmdResult res = this.run(cr, true, INOUT.NONE);
        return new Int(res.result);
    }

    private SysCmdResult run(CallRuntime cr, boolean wait, INOUT io) {
        String commandString = ((Str)this.cmd.get()).getValue();
        SYSCMD_IO dataIO = io == INOUT.LIVE ? SYSCMD_IO.LIVE : (io == INOUT.BUFFER ? SYSCMD_IO.BUFFER : SYSCMD_IO.DISCARD);
        SysCmdData data = new SysCmdData(true, wait, dataIO, commandString, null);
        try {
            SysCmd cmd = new SysCmd();
            return cmd.exec(data);
        }
        catch (Exception f) {
            throw new ExternalError(cr, "Command execution error: " + f.getClass().getSimpleName(), f.getMessage());
        }
    }

    private static enum INOUT {
        NONE,
        BUFFER,
        LIVE;

    }
}

