/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.immute.datetime;

import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_Time;
import org.jaymo_lang.model.COMPARE;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.immute.datetime.Lib_DateTime_Format;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public abstract class A_DateTimeBase
extends A_Immutable {
    @Override
    public abstract boolean equals(Object var1);

    @Override
    protected final ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "+": 
            case "add": {
                return A_Object.stdResult(this.mAddSub(cr, true));
            }
            case "-": 
            case "sub": {
                return A_Object.stdResult(this.mAddSub(cr, false));
            }
            case "toMilliSec": 
            case "toMSec": 
            case "toMilliSeconds": {
                return A_Object.stdResult(this.mToMilliSeconds(cr));
            }
            case "style": {
                return A_Object.stdResult(this.mStyle(cr));
            }
            case "styleDE": 
            case "toStrDE": {
                return A_Object.stdResult(this.mStyle(cr, COUNTRY.DE));
            }
            case "styleEN": 
            case "toStrEN": {
                return A_Object.stdResult(this.mStyle(cr, COUNTRY.EN));
            }
            case "styleUS": 
            case "toStrUS": {
                return A_Object.stdResult(this.mStyle(cr, COUNTRY.US));
            }
            case "toStrFull": {
                return A_Object.stdResult(this.mToStrFull(cr));
            }
            case "++": 
            case "inc": {
                return A_Object.stdResult(this.mIncDec(cr, true));
            }
            case "--": 
            case "dec": {
                return A_Object.stdResult(this.mIncDec(cr, false));
            }
            case "limit": {
                return A_Object.stdResult(this.mLimit(cr));
            }
            case "isLess": 
            case "<": {
                return A_Object.stdResult(this.mCompare(cr, COMPARE.L));
            }
            case "isGreater": 
            case ">": {
                return A_Object.stdResult(this.mCompare(cr, COMPARE.G));
            }
            case "<=": 
            case "isLessOrEqual": {
                return A_Object.stdResult(this.mCompare(cr, COMPARE.LE));
            }
            case "isGreaterOrEqual": 
            case ">=": {
                return A_Object.stdResult(this.mCompare(cr, COMPARE.GE));
            }
        }
        return this.call3(cr, method);
    }

    protected abstract ObjectCallResult call3(CallRuntime var1, String var2);

    protected abstract I_Date getInternalDate();

    protected abstract I_Time getInternalTime();

    protected abstract A_DateTimeBase incdec2(boolean var1, int var2);

    protected final I_Object mAddSub(CallRuntime cr, boolean add) {
        A_Number num = (A_Number)cr.args(this, A_Number.class)[0];
        return this.pAddSub(cr, num, add);
    }

    protected abstract boolean[] mCompare2(CallRuntime var1);

    protected abstract A_DateTimeBase mLimit(CallRuntime var1);

    protected abstract I_Object mStyle(CallRuntime var1, COUNTRY var2);

    protected abstract I_Object pAddSub(CallRuntime var1, A_Number var2, boolean var3);

    protected abstract JMo_Long pToMilliSeconds();

    protected abstract String toStringFull();

    private Bool mCompare(CallRuntime cr, COMPARE co) {
        boolean[] equal_greater = this.mCompare2(cr);
        boolean isEqual = equal_greater[0];
        boolean isGreater = equal_greater[1];
        boolean result = false;
        switch (co) {
            case L: {
                result = !isEqual && !isGreater;
                break;
            }
            case LE: {
                result = isEqual || !isGreater;
                break;
            }
            case G: {
                result = isGreater;
                break;
            }
            case GE: {
                result = isEqual || isGreater;
            }
        }
        return Bool.getObject(result);
    }

    private A_DateTimeBase mIncDec(CallRuntime cr, boolean inc) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        int amount = 1;
        if (args.length == 1) {
            amount = Lib_Convert.getIntValue(cr, cr.argType(args[0], A_IntNumber.class));
        }
        return this.incdec2(inc, amount);
    }

    private Str mStyle(CallRuntime cr) {
        String s = ((Str)cr.args(this, Str.class)[0]).getValue();
        return Lib_DateTime_Format.format(cr, s, this.getInternalDate(), this.getInternalTime());
    }

    private JMo_Long mToMilliSeconds(CallRuntime cr) {
        cr.argsNone();
        return this.pToMilliSeconds();
    }

    private I_Object mToStrFull(CallRuntime cr) {
        cr.argsNone();
        return new Str(this.toStringFull());
    }

    public static enum COUNTRY {
        DE,
        EN,
        US;

    }
}

