/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.error.Err_Runtime;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Dec
extends Number {
    private static final long serialVersionUID = 1416433428694095730L;
    public static final long BASE = 1000000000L;
    public static final Dec MAX_VALUE = new Dec(Long.MAX_VALUE);
    public static final Dec MIN_VALUE = new Dec(Long.MIN_VALUE);
    public static final Dec ZERO = new Dec(0L);
    public static final Dec ONE = new Dec(1000000000L);
    public static final Dec NEGATIVE_ONE = new Dec(-1000000000L);
    private long value = 0L;

    public static Dec parseDec(String s) {
        double d = Double.parseDouble(s);
        return Dec.valueOf(d);
    }

    public static Dec valueOf(byte b) {
        return new Dec((long)b * 1000000000L);
    }

    public static Dec valueOf(double d) {
        if (!Double.isFinite(d)) {
            if (Double.isNaN(d)) {
                return ZERO;
            }
            String inf = d == Double.POSITIVE_INFINITY ? "infinity" : "-infinity";
            throw new Err_Runtime("Invalid value", "Got: " + inf);
        }
        double mul = d * 1.0E9;
        if (mul > 9.223372036854776E18 || mul < -9.223372036854776E18) {
            throw new Err_Runtime("Value out of bounds", "Got: " + d);
        }
        return new Dec(Math.round(mul));
    }

    public static Dec valueOf(float f) {
        return Dec.valueOf((double)f);
    }

    public static Dec valueOf(int i) {
        return new Dec((long)i * 1000000000L);
    }

    public static Dec valueOf(long l) {
        return new Dec(l * 1000000000L);
    }

    public static Dec valueOf(short s) {
        return new Dec((long)s * 1000000000L);
    }

    private Dec(long l) {
        this.value = l;
    }

    public Dec abs() {
        return this.value < 0L ? Dec.valueOf(Math.abs(this.doubleValue())) : this;
    }

    public Dec add(Dec arg) {
        return new Dec(this.value + arg.value);
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.toString());
    }

    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    @Override
    public byte byteValue() {
        return (byte)(this.value / 1000000000L);
    }

    public Dec dec() {
        return new Dec(this.value - 1000000000L);
    }

    public Dec div(Dec arg) {
        double d = this.doubleValue() / arg.doubleValue();
        return this.iCheckResult(d);
    }

    @Override
    public double doubleValue() {
        return (double)this.value / 1.0E9;
    }

    public boolean equals(Object other) {
        if (other instanceof Dec) {
            return this.value == ((Dec)other).value;
        }
        return false;
    }

    public Dec exp() {
        return Dec.valueOf(Math.exp(this.doubleValue()));
    }

    @Override
    public float floatValue() {
        return (float)((double)this.value / 1.0E9);
    }

    public Dec inc() {
        return new Dec(this.value + 1000000000L);
    }

    @Override
    public int intValue() {
        return (int)(this.value / 1000000000L);
    }

    public boolean is0() {
        return this.value == 0L;
    }

    public boolean isEqual(Dec other) {
        return this.value == other.value;
    }

    public boolean isGreater(Dec other) {
        return this.value > other.value;
    }

    public boolean isGreaterOrEqual(Dec other) {
        return this.value >= other.value;
    }

    public boolean isGreaterZero() {
        return this.value > 0L;
    }

    public boolean isLess(Dec other) {
        return this.value < other.value;
    }

    public boolean isLessOrEqual(Dec other) {
        return this.value <= other.value;
    }

    public boolean isLessZero() {
        return this.value < 0L;
    }

    public Dec log(Dec arg) {
        double d = Math.log(this.doubleValue()) / Math.log(arg.doubleValue());
        return this.iCheckResult(d);
    }

    public Dec log10() {
        return Dec.valueOf(Math.log10(this.doubleValue()));
    }

    public Dec logN() {
        return Dec.valueOf(Math.log(this.doubleValue()));
    }

    @Override
    public long longValue() {
        return this.value / 1000000000L;
    }

    public Dec mod(Dec arg) {
        return new Dec(this.value % arg.value);
    }

    public Dec mul(Dec arg) {
        double d = this.doubleValue() * arg.doubleValue();
        return this.iCheckResult(d);
    }

    public Dec neg() {
        return new Dec(-this.value);
    }

    public Dec pow() {
        return Dec.valueOf(this.doubleValue() * this.doubleValue());
    }

    public Dec pow(Dec arg) {
        double d = Math.pow(this.doubleValue(), arg.doubleValue());
        return this.iCheckResult(d);
    }

    public Dec root() {
        return Dec.valueOf(Math.sqrt(this.doubleValue()));
    }

    public Dec root(Dec arg) {
        double d = Math.exp(Math.log(this.doubleValue()) / arg.doubleValue());
        return this.iCheckResult(d);
    }

    @Override
    public short shortValue() {
        return (short)(this.value / 1000000000L);
    }

    public Dec sub(Dec arg) {
        return new Dec(this.value - arg.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String s = "" + this.value;
        if (this.value < 0L) {
            s = s.substring(1);
            sb.append('-');
        }
        if (s.length() < 10) {
            sb.append('0');
        } else {
            sb.append(s.substring(0, s.length() - 9));
        }
        sb.append('.');
        if (s.length() < 9) {
            int i = 0;
            while (i < 9 - s.length()) {
                sb.append('0');
                ++i;
            }
            sb.append(s);
        } else {
            sb.append(s.substring(s.length() - 9, s.length()));
        }
        while (sb.charAt(sb.length() - 1) == '0') {
            sb.setLength(sb.length() - 1);
        }
        if (sb.charAt(sb.length() - 1) == '.') {
            sb.append('0');
        }
        return sb.toString();
    }

    private Dec iCheckResult(double d) {
        if (Double.isFinite(d)) {
            return Dec.valueOf(d);
        }
        if (Double.isNaN(d)) {
            return ZERO;
        }
        throw new Err_Runtime("Result out of bounds", "Got: " + (d == Double.POSITIVE_INFINITY ? "infinity" : "-infinity"));
    }
}

