/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object;

import de.mn77.base.data.util.Lib_String;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.runtime.CallRuntime;

public class JMo_Charset
extends A_Immutable {
    private final ArgCallBuffer arg0;
    private Charset charset = null;

    public JMo_Charset() {
        this.arg0 = null;
        this.charset = Charset.defaultCharset();
    }

    public JMo_Charset(Call c) {
        this.arg0 = new ArgCallBuffer(0, c);
    }

    public JMo_Charset(Charset cs) {
        this.arg0 = null;
        this.charset = cs;
    }

    public JMo_Charset(String cs) {
        this.arg0 = null;
        this.charset = Charset.forName(cs);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof JMo_Charset) {
            return this.getCharset().equals(((JMo_Charset)other).getCharset());
        }
        return false;
    }

    @Override
    public boolean equalsLazy(Object other) {
        return this.equals(other);
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public final A_Immutable getConstant(CallRuntime cr, String name) {
        return new JMo_Charset(this.iMapping(cr, name));
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.arg0 != null) {
            Str o = (Str)cr.argType(this.arg0.get(), Str.class);
            this.charset = this.iMapping(cr, o.getValue());
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        return null;
    }

    private Charset iMapping(CallRuntime cr, String name) {
        switch (name = Lib_String.replace(name, '-', '_').toUpperCase()) {
            case "ASCII": 
            case "US_ASCII": {
                return StandardCharsets.US_ASCII;
            }
            case "UTF8": 
            case "UTF_8": {
                return StandardCharsets.UTF_8;
            }
            case "UTF_16": 
            case "UTF16": {
                return StandardCharsets.UTF_16;
            }
            case "UTF16LE": 
            case "UTF_16LE": {
                return StandardCharsets.UTF_16LE;
            }
            case "UTF16BE": 
            case "UTF_16BE": {
                return StandardCharsets.UTF_16BE;
            }
            case "ISO8859_1": 
            case "ISO_8859_1": {
                return StandardCharsets.ISO_8859_1;
            }
            case "ISO8859_15": 
            case "ISO_8859_15": {
                return Charset.forName("ISO8859-15");
            }
            case "CP850": 
            case "CP_850": {
                return Charset.forName("Cp850");
            }
            case "CP_1252": 
            case "CP1252": {
                return Charset.forName("Cp1252");
            }
        }
        throw new RuntimeError(cr, "Unknown charset definition", "Got: " + name);
    }
}

