/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import java.util.HashMap;
import java.util.Map;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.model.Function;
import org.jaymo_lang.object.A_ObjectToString;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Output;

public class FuncManager
extends A_ObjectToString {
    private HashMap<String, Function> func;

    public void add(String name, Function f) {
        if (this.func == null) {
            this.func = new HashMap();
        }
        this.func.put(name, f);
    }

    public Function get(CallRuntime cr, String method) {
        char c0;
        if (this.func == null) {
            throw new CodeError(cr, "Unknown Function", "this." + method);
        }
        Function f = this.func.getOrDefault(method, null);
        if (f == null && cr.getStrict().isValid_AutoProperty() && (c0 = method.charAt(0)) >= 'a' && c0 <= 'z') {
            if (cr.argCount() == 0) {
                String methodGet = "get" + Character.toUpperCase(c0) + method.substring(1);
                f = this.func.getOrDefault(methodGet, null);
            } else {
                String methodSet = "set" + Character.toUpperCase(c0) + method.substring(1);
                f = this.func.getOrDefault(methodSet, null);
            }
        }
        if (f == null) {
            throw new CodeError(cr, "Unknown Function", String.valueOf(cr.getType().toString()) + "." + method);
        }
        return f;
    }

    public boolean knows(String name) {
        if (this.func == null) {
            return false;
        }
        String nameLow = name.toLowerCase();
        for (String key : this.func.keySet()) {
            if (!name.equals(key) && !nameLow.equals(key.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        StringBuilder sb = new StringBuilder();
        if (this.func != null) {
            for (Map.Entry<String, Function> g : this.func.entrySet()) {
                String sv = g.getValue().toString(cr, STYPE.DESCRIBE);
                sb.append(sv);
                sb.append('\n');
            }
        }
        Lib_Output.removeEnd(sb, '\n');
        return sb.toString();
    }
}

