/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.type;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.model.VarArgsCallBuffer;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;

public class JMo_Uri
extends A_Immutable {
    private final VarArgsCallBuffer args;
    private URI uri;

    public JMo_Uri(Call ... ca) {
        this.args = new VarArgsCallBuffer(ca);
    }

    public JMo_Uri(URI newURI) {
        this.uri = newURI;
        this.args = null;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JMo_Uri ? ((JMo_Uri)other).uri.equals(this.uri) : false;
    }

    @Override
    public boolean equalsLazy(Object other) {
        return this.equals(other);
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.args != null) {
            try {
                I_Object[] oa = this.args.init(cr, this);
                switch (oa.length) {
                    case 1: {
                        String s1 = ((Str)cr.argType(oa[0], Str.class)).getValue();
                        this.uri = new URI(s1);
                        break;
                    }
                    case 4: {
                        String s4a = ((Str)cr.argType(oa[0], Str.class)).getValue();
                        String s4b = ((Str)cr.argType(oa[1], Str.class)).getValue();
                        String s4c = ((Str)cr.argType(oa[2], Str.class)).getValue();
                        String s4d = ((Str)cr.argType(oa[3], Str.class)).getValue();
                        this.uri = new URI(s4a, s4b, s4c, s4d);
                        break;
                    }
                    case 5: {
                        String s5a = ((Str)cr.argType(oa[0], Str.class)).getValue();
                        String s5b = ((Str)cr.argType(oa[1], Str.class)).getValue();
                        String s5c = ((Str)cr.argType(oa[2], Str.class)).getValue();
                        String s5d = ((Str)cr.argType(oa[3], Str.class)).getValue();
                        String s5e = ((Str)cr.argType(oa[4], Str.class)).getValue();
                        this.uri = new URI(s5a, s5b, s5c, s5d, s5e);
                        break;
                    }
                    case 7: {
                        String s7a = ((Str)cr.argType(oa[0], Str.class)).getValue();
                        String s7b = ((Str)cr.argType(oa[1], Str.class)).getValue();
                        String s7c = ((Str)cr.argType(oa[2], Str.class)).getValue();
                        int s7d = Lib_Convert.getIntValue(cr, cr.argType(oa[3], A_IntNumber.class));
                        String s7e = ((Str)cr.argType(oa[4], Str.class)).getValue();
                        String s7f = ((Str)cr.argType(oa[5], Str.class)).getValue();
                        String s7g = ((Str)cr.argType(oa[6], Str.class)).getValue();
                        this.uri = new URI(s7a, s7b, s7c, s7d, s7e, s7f, s7g);
                        break;
                    }
                    default: {
                        throw new CodeError(cr, "Invalid amount of arguments for 'Uri'", "Got " + oa.length + ", allowed are 1,4,5,7");
                    }
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeError(cr, "Invalid URI", e.getMessage());
            }
        }
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        StringBuilder sb = new StringBuilder();
        sb.append("Uri");
        switch (type) {
            case REGULAR: 
            case DESCRIBE: {
                sb.append("(\"");
                sb.append(this.uri.toString());
                sb.append("\")");
            }
        }
        return sb.toString();
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "toFile": {
                return A_Object.stdResult(this.mToFile(cr));
            }
            case "getScheme": {
                return this.mGetStr(cr, this.uri.getScheme());
            }
            case "getAuthority": {
                return this.mGetStr(cr, this.uri.getAuthority());
            }
            case "getPath": {
                return this.mGetStr(cr, this.uri.getPath());
            }
            case "getQuery": {
                return this.mGetStr(cr, this.uri.getQuery());
            }
            case "getFragment": {
                return this.mGetStr(cr, this.uri.getFragment());
            }
            case "getHost": {
                return this.mGetStr(cr, this.uri.getHost());
            }
            case "getPort": {
                return this.mGetInt(cr, this.uri.getPort());
            }
            case "getUserInfo": {
                return this.mGetStr(cr, this.uri.getUserInfo());
            }
            case "setScheme": {
                return A_Object.stdResult(this.mSetScheme(cr));
            }
            case "setAuthority": {
                return A_Object.stdResult(this.mSetAuthority(cr));
            }
            case "setPath": {
                return A_Object.stdResult(this.mSetPath(cr));
            }
            case "setQuery": {
                return A_Object.stdResult(this.mSetQuery(cr));
            }
            case "setFragment": {
                return A_Object.stdResult(this.mSetFragment(cr));
            }
            case "setHost": {
                return A_Object.stdResult(this.mSetHost(cr));
            }
            case "setPort": {
                return A_Object.stdResult(this.mSetPort(cr));
            }
            case "setUserInfo": {
                return A_Object.stdResult(this.mSetUserInfo(cr));
            }
        }
        return null;
    }

    private ObjectCallResult mGetInt(CallRuntime cr, int i) {
        cr.argsNone();
        A_Immutable result = i < 0 ? Nil.NIL : new Int(i);
        return A_Object.stdResult(result);
    }

    private ObjectCallResult mGetStr(CallRuntime cr, String s) {
        cr.argsNone();
        A_Immutable result = s == null ? Nil.NIL : new Str(s);
        return A_Object.stdResult(result);
    }

    private I_Object mSetAuthority(CallRuntime cr) {
        Str arg = (Str)cr.args(this, Str.class)[0];
        try {
            URI newURI = new URI(this.uri.getScheme(), arg.getValue(), this.uri.getRawPath(), this.uri.getRawQuery(), this.uri.getRawFragment());
            return new JMo_Uri(newURI);
        }
        catch (URISyntaxException e) {
            throw new RuntimeError(cr, "Invalid URI syntax", e.getMessage());
        }
    }

    private I_Object mSetFragment(CallRuntime cr) {
        Str arg = (Str)cr.args(this, Str.class)[0];
        try {
            URI newURI = new URI(this.uri.getScheme(), this.uri.getRawUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getRawPath(), this.uri.getRawQuery(), arg.getValue());
            return new JMo_Uri(newURI);
        }
        catch (URISyntaxException e) {
            throw new RuntimeError(cr, "Invalid URI syntax", e.getMessage());
        }
    }

    private I_Object mSetHost(CallRuntime cr) {
        Str arg = (Str)cr.args(this, Str.class)[0];
        try {
            URI newURI = new URI(this.uri.getScheme(), this.uri.getRawUserInfo(), arg.getValue(), this.uri.getPort(), this.uri.getRawPath(), this.uri.getRawQuery(), this.uri.getRawFragment());
            return new JMo_Uri(newURI);
        }
        catch (URISyntaxException e) {
            throw new RuntimeError(cr, "Invalid URI syntax", e.getMessage());
        }
    }

    private I_Object mSetPath(CallRuntime cr) {
        Str arg = (Str)cr.args(this, Str.class)[0];
        try {
            URI newURI = new URI(this.uri.getScheme(), this.uri.getRawUserInfo(), this.uri.getHost(), this.uri.getPort(), arg.getValue(), this.uri.getRawQuery(), this.uri.getRawFragment());
            return new JMo_Uri(newURI);
        }
        catch (URISyntaxException e) {
            throw new RuntimeError(cr, "Invalid URI syntax", e.getMessage());
        }
    }

    private I_Object mSetPort(CallRuntime cr) {
        A_IntNumber arg = (A_IntNumber)cr.args(this, A_IntNumber.class)[0];
        int port = Lib_Convert.getIntValue(cr, arg);
        Lib_Error.ifNotBetween(cr, 0, 65535, port, "Port");
        try {
            URI newURI = new URI(this.uri.getScheme(), this.uri.getRawUserInfo(), this.uri.getHost(), port, this.uri.getRawPath(), this.uri.getRawQuery(), this.uri.getRawFragment());
            return new JMo_Uri(newURI);
        }
        catch (URISyntaxException e) {
            throw new RuntimeError(cr, "Invalid URI syntax", e.getMessage());
        }
    }

    private I_Object mSetQuery(CallRuntime cr) {
        Str arg = (Str)cr.args(this, Str.class)[0];
        try {
            URI newURI = new URI(this.uri.getScheme(), this.uri.getRawUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getRawPath(), arg.getValue(), this.uri.getRawFragment());
            return new JMo_Uri(newURI);
        }
        catch (URISyntaxException e) {
            throw new RuntimeError(cr, "Invalid URI syntax", e.getMessage());
        }
    }

    private JMo_Uri mSetScheme(CallRuntime cr) {
        Str arg = (Str)cr.args(this, Str.class)[0];
        try {
            URI newURI = new URI(arg.getValue(), this.uri.getRawUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getRawPath(), this.uri.getRawQuery(), this.uri.getRawFragment());
            return new JMo_Uri(newURI);
        }
        catch (URISyntaxException e) {
            throw new RuntimeError(cr, "Invalid URI syntax", e.getMessage());
        }
    }

    private I_Object mSetUserInfo(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        String arg = args.length == 1 ? ((Str)cr.argType(args[0], Str.class)).getValue() : String.valueOf(((Str)cr.argType(args[0], Str.class)).getValue()) + ':' + ((Str)cr.argType(args[1], Str.class)).getValue();
        try {
            URI newURI = new URI(this.uri.getScheme(), arg, this.uri.getHost(), this.uri.getPort(), this.uri.getRawPath(), this.uri.getRawQuery(), this.uri.getRawFragment());
            return new JMo_Uri(newURI);
        }
        catch (URISyntaxException e) {
            throw new RuntimeError(cr, "Invalid URI syntax", e.getMessage());
        }
    }

    private I_Object mToFile(CallRuntime cr) {
        cr.argsNone();
        try {
            File f = new File(this.uri);
            return new JMo_File(f);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeError(cr, "Illegal convertion from URI to File", e.getMessage());
        }
    }
}

