/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.tcp;

import de.mn77.lib.tcp.TCP_Connection;
import java.io.IOException;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_EventObject;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.pseudo.JMo_Error;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_TcpConnection
extends A_EventObject
implements I_Object {
    private final TCP_Connection connection;

    public JMo_TcpConnection(TCP_Connection con) {
        this.connection = con;
    }

    @Override
    public ObjectCallResult callEvent(CallRuntime cr, String event) {
        return null;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    public boolean validateEvent(CallRuntime cr, String event) {
        switch (event) {
            case "@timeout": 
            case "@error": {
                return true;
            }
        }
        return false;
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime cr, String method) {
        switch (method) {
            case "send": {
                return this.send(cr);
            }
            case "recieveStr": {
                return this.mRecieveStr(cr);
            }
            case "recieveInt": {
                return this.mRecieveInt(cr);
            }
            case "close": {
                return this.close(cr);
            }
        }
        return null;
    }

    private ObjectCallResult close(CallRuntime cr) {
        cr.argsNone();
        this.connection.close();
        return A_Object.stdResult(Nil.NIL);
    }

    private ObjectCallResult mRecieveInt(CallRuntime cr) {
        cr.argsNone();
        try {
            int i = this.connection.recieveInt();
            return A_Object.stdResult(new Int(i));
        }
        catch (IOException e) {
            this.eventRun(cr, "@error", new JMo_Error(e));
            return A_Object.stdResult(Nil.NIL);
        }
    }

    private ObjectCallResult mRecieveStr(CallRuntime cr) {
        cr.argsNone();
        try {
            String s = this.connection.recieveString();
            return A_Object.stdResult(new Str(s));
        }
        catch (IOException e) {
            this.eventRun(cr, "@error", new JMo_Error(e));
            return A_Object.stdResult(Nil.NIL);
        }
    }

    private ObjectCallResult send(CallRuntime cr) {
        I_Object oa = cr.args(this, I_Atomic.class)[0];
        try {
            if (oa instanceof I_Integer && !(oa instanceof JMo_Long)) {
                int value = Lib_Convert.getIntValue(cr, oa);
                this.connection.send(value);
            } else {
                String value = Lib_Convert.getStringValue(cr, oa);
                this.connection.send(value);
            }
        }
        catch (IOException e) {
            this.eventRun(cr, "@error", new JMo_Error(e));
        }
        return A_Object.stdResult(this);
    }
}

