/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.ntp;

import de.mn77.base.error.Err_Network;
import de.mn77.lib.ntp.SNTP_Client;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.datetime.JMo_Date;
import org.jaymo_lang.object.immute.datetime.JMo_DateTime;
import org.jaymo_lang.object.immute.datetime.JMo_Time;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_SntpClient
extends A_ObjectSimple {
    private static final String DEFAULT = "pool.ntp.org";
    private final ArgCallBuffer arg;
    private SNTP_Client client;

    public JMo_SntpClient() {
        this.arg = null;
    }

    public JMo_SntpClient(Call server) {
        this.arg = new ArgCallBuffer(0, server);
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.arg != null) {
            Str argStr = this.arg.init(cr, this, Str.class);
            String address = Lib_Convert.getStringValue(cr, argStr);
            this.client = new SNTP_Client(address);
        } else {
            this.client = new SNTP_Client(DEFAULT);
        }
    }

    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "update": {
                cr.argsNone();
                try {
                    this.client.update();
                }
                catch (Err_Network e) {
                    throw new ExternalError(cr, "NTP-Error", e.getMessage());
                }
                return this;
            }
            case "time": {
                cr.argsNone();
                return new JMo_Time(this.client.getTime());
            }
            case "date": {
                cr.argsNone();
                return new JMo_Date(this.client.getDate());
            }
            case "dateTime": {
                cr.argsNone();
                return new JMo_DateTime(this.client.getDateTime());
            }
            case "diff": {
                cr.argsNone();
                return new JMo_Long(this.client.getDifferenceMSek());
            }
        }
        return null;
    }
}

