/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.csv;

import de.mn77.base.data.struct.table.ArrayTable;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.error.Err_Runtime;
import de.mn77.lib.csv.CsvParser;
import de.mn77.lib.csv.CsvTableFile;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.object.struct.JMo_Table;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Csv
extends A_ObjectSimple {
    private final Call call_delimiter_field;
    private final Call call_delimiter_value;
    private final Call call_delimiter_line;
    private char delimiterField = (char)34;
    private char delimiterColumn = (char)44;
    private String delimiterLine = "\n";

    public JMo_Csv() {
        this(null, null, null);
    }

    public JMo_Csv(Call delimiter_value) {
        this(null, delimiter_value, null);
    }

    public JMo_Csv(Call field_delimiter, Call value_delimiter, Call line_delimiter) {
        this.call_delimiter_field = field_delimiter;
        this.call_delimiter_value = value_delimiter;
        this.call_delimiter_line = line_delimiter;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.call_delimiter_field != null) {
            this.delimiterField = Lib_Convert.getCharValue(cr, cr.execInit(this.call_delimiter_field, this));
        }
        if (this.call_delimiter_value != null) {
            this.delimiterColumn = Lib_Convert.getCharValue(cr, cr.execInit(this.call_delimiter_value, this));
        }
        if (this.call_delimiter_line != null) {
            this.delimiterLine = Lib_Convert.getStringValue(cr, cr.execInit(this.call_delimiter_line, this));
        }
    }

    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "readHead": {
                return this.mRead(cr, READTYPE.HEAD);
            }
            case "readBody": 
            case "readData": {
                return this.mRead(cr, READTYPE.BODY);
            }
            case "read": {
                return this.mRead(cr, READTYPE.COMPLETE);
            }
            case "parseHead": {
                return this.mParse(cr, READTYPE.HEAD);
            }
            case "parseBody": 
            case "parseData": {
                return this.mParse(cr, READTYPE.BODY);
            }
            case "parse": {
                return this.mParse(cr, READTYPE.COMPLETE);
            }
            case "write": {
                return this.mWrite(cr, false, false);
            }
            case "writeFull": {
                return this.mWrite(cr, true, false);
            }
            case "append": {
                return this.mWrite(cr, false, true);
            }
        }
        return null;
    }

    private I_Object mParse(CallRuntime cr, READTYPE rt) {
        I_Object o = cr.args(this, Str.class)[0];
        String csv = Lib_Convert.getStringValue(cr, o);
        try {
            CsvParser parser = new CsvParser(this.delimiterField, this.delimiterColumn, this.delimiterLine);
            switch (rt) {
                case COMPLETE: {
                    I_Table<String> tab1 = parser.parse(csv, true, true);
                    return Lib_Convert.toJMo(tab1);
                }
                case HEAD: {
                    I_Table<String> tab2 = parser.parse(csv, true, false);
                    return Lib_Convert.toJMo(tab2.getRow(0));
                }
                case BODY: {
                    I_Table<String> tab3 = parser.parse(csv, false, true);
                    return Lib_Convert.toJMo(tab3);
                }
            }
            throw Err.impossible(new Object[0]);
        }
        catch (Err_Runtime r) {
            throw new RuntimeError(cr, "CSV-Table-Error", r.getLocalizedMessage());
        }
    }

    private I_Object mRead(CallRuntime cr, READTYPE rt) {
        I_Object o = cr.argsExt(this, new Class[][]{{Str.class, JMo_File.class}})[0];
        String file = o instanceof JMo_File ? ((JMo_File)o).getInternalFile().getAbsolutePath() : Lib_Convert.getStringValue(cr, o);
        CsvTableFile csv = new CsvTableFile(file);
        csv.setDelimiters(this.delimiterField, this.delimiterColumn, this.delimiterLine);
        try {
            switch (rt) {
                case COMPLETE: {
                    return Lib_Convert.toJMo(csv.read());
                }
                case HEAD: {
                    return Lib_Convert.toJMo(csv.readFirstLine());
                }
                case BODY: {
                    return Lib_Convert.toJMo(csv.readExceptFirstLine());
                }
            }
            throw Err.impossible(new Object[0]);
        }
        catch (Err_Runtime r) {
            throw new RuntimeError(cr, "CSV-Table-Error", r.getMessage());
        }
        catch (Err_FileSys f) {
            throw new ExternalError(cr, "File-Access-Error", f.getMessage());
        }
    }

    private I_Object mWrite(CallRuntime cr, boolean writeTitles, boolean append) {
        I_Object[] oa = cr.argsExt(this, {Str.class, JMo_File.class}, {JMo_Table.class});
        String file = oa[0] instanceof JMo_File ? ((JMo_File)oa[0]).getInternalFile().getAbsolutePath() : Lib_Convert.getStringValue(cr, oa[0]);
        CsvTableFile csvFile = new CsvTableFile(file);
        csvFile.setDelimiters(this.delimiterField, this.delimiterColumn, this.delimiterLine);
        try {
            I_Object[] jmoTitles;
            JMo_Table table = (JMo_Table)oa[1];
            ArrayTable<String> ts = Lib_Convert.toTableString(table);
            if (writeTitles && !append && (jmoTitles = table.getTitles()) != null) {
                String[] titles = Lib_Convert.toStringArray(jmoTitles);
                ts.add(0, titles);
            }
            if (append) {
                csvFile.append(ts);
            } else {
                csvFile.write(ts);
            }
        }
        catch (Err_FileSys f) {
            throw new ExternalError(cr, "File-Access-Error", f.getLocalizedMessage());
        }
        return this;
    }

    private static enum READTYPE {
        COMPLETE,
        HEAD,
        BODY;

    }
}

