/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.crypt.cipher;

import de.mn77.lib.crypt.cipher.JavaCipher;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.struct.JMo_ByteArray;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Error;

public abstract class A_Cipher
extends A_ObjectSimple {
    private byte[] key = null;

    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "setKey": {
                this.setKey(cr);
                return this;
            }
            case "encrypt": {
                byte[] encrypted = this.encrypt(cr);
                return new JMo_ByteArray(encrypted);
            }
            case "decrypt": {
                byte[] decrypted = this.decrypt(cr);
                return new JMo_ByteArray(decrypted);
            }
        }
        return null;
    }

    protected abstract JavaCipher getCipher();

    private byte[] decrypt(CallRuntime cr) {
        JMo_ByteArray dataObj = (JMo_ByteArray)cr.args(this, JMo_ByteArray.class)[0];
        return this.getCipher().decrypt(dataObj.getValue(), this.key);
    }

    private byte[] encrypt(CallRuntime cr) {
        JMo_ByteArray dataObj = (JMo_ByteArray)cr.args(this, JMo_ByteArray.class)[0];
        return this.getCipher().encrypt(dataObj.getValue(), this.key);
    }

    private void setKey(CallRuntime cr) {
        JMo_ByteArray keyObj = (JMo_ByteArray)cr.args(this, JMo_ByteArray.class)[0];
        byte[] keyBA = keyObj.getValue();
        Lib_Error.ifNotBetween(cr, this.getCipher().keyLengthMin(), this.getCipher().keyLengthMax(), keyBA.length, "key length");
        this.key = keyBA;
    }
}

