/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class UdpPush {
    private final DatagramSocket socket;

    public static void main(String[] args) {
        try {
            UdpPush up = new UdpPush(22222);
            up.push("localhost", 33333, "ABC".getBytes());
            up.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public UdpPush(int port) throws SocketException {
        this.socket = new DatagramSocket(port);
    }

    public void close() throws SocketException {
        this.socket.setSoTimeout(1);
        this.socket.disconnect();
        this.socket.close();
    }

    public void push(byte[] ip, int port, byte[] data) throws IOException {
        this.push(InetAddress.getByAddress(ip), port, data);
    }

    public void push(InetAddress address, int port, byte[] data) throws IOException {
        DatagramPacket packet = new DatagramPacket(data, 0, data.length, address, port);
        this.socket.send(packet);
    }

    public void push(String address, int port, byte[] data) throws IOException {
        this.push(InetAddress.getByName(address), port, data);
    }
}

